/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class WeakDispatcherImpl<V> {
    private ArrayList<Entry> accessing = null;
    private ArrayList<Entry> entries = new ArrayList();

    public <T> void add(T target, BiConsumer<T, V> listener) {
        this.writeQueue().add(new Entry(this, target, listener));
    }

    public <T> void remove(T target) {
        this.writeQueue().removeIf(e -> e.target.get() == target);
    }

    public void send(V value) {
        if (this.entries.isEmpty()) {
            return;
        }
        this.accessing = this.entries;
        this.entries.forEach(e -> e.consumer.accept(value));
        this.accessing = null;
    }

    private ArrayList<Entry> writeQueue() {
        if (this.accessing != this.entries) {
            return this.entries;
        }
        ArrayList<Entry> entries = new ArrayList<Entry>(this.entries);
        this.entries = entries;
        return entries;
    }

    public class Entry {
        final WeakReference<?> target;
        final Consumer<V> consumer;

        <T> Entry(WeakDispatcherImpl this$0, T target, BiConsumer<T, V> listener) {
            WeakReference ref = new WeakReference(target);
            this.target = ref;
            this.consumer = value -> {
                Object target1 = ref.get();
                if (target1 != null) {
                    listener.accept(target1, value);
                }
            };
        }
    }
}

