/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.mojang.blaze3d.platform.InputConstants;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InputManagerImpl {
    public static boolean hasControlDown() {
        return Screen.hasControlDown();
    }

    public static boolean hasShiftDown() {
        return Screen.hasShiftDown();
    }

    public static boolean hasAltDown() {
        return Screen.hasAltDown();
    }

    public static boolean hasSprintDown() {
        return EnvironmentManager.getClient().options.keySprint.isDown();
    }

    public static boolean hasSneakDown() {
        return EnvironmentManager.getClient().options.keyShift.isDown();
    }

    public static boolean hasSpaceDown() {
        return InputManagerImpl.isKeyDown(32);
    }

    public static boolean isKeyDown(int key) {
        return InputConstants.isKeyDown((long)EnvironmentManager.getClient().getWindow().getWindow(), (int)key);
    }

    public static boolean isCut(int i) {
        return Screen.isCut((int)i);
    }

    public static boolean isPaste(int i) {
        return Screen.isPaste((int)i);
    }

    public static boolean isCopy(int i) {
        return Screen.isCopy((int)i);
    }

    public static boolean isSelectAll(int i) {
        return Screen.isSelectAll((int)i);
    }

    public static boolean isSpace(int i) {
        return i == 32;
    }

    public static boolean isEnter(int i) {
        return i == 257 || i == 335;
    }

    public static boolean hasShortcutDown() {
        if (Minecraft.ON_OSX) {
            return InputManagerImpl.isKeyDown(341) || InputManagerImpl.isKeyDown(345);
        }
        return false;
    }

    public static int getShortcutKey(int key) {
        return switch (key) {
            case 65 -> 268;
            case 69 -> 269;
            case 66 -> 263;
            case 70 -> 262;
            case 68 -> 261;
            case 80 -> 265;
            case 78 -> 264;
            default -> key;
        };
    }

    public static String getClipboard() {
        return InputManagerImpl.keyboardHandler().getClipboard();
    }

    public static void setClipboard(String string) {
        InputManagerImpl.keyboardHandler().setClipboard(string);
    }

    private static KeyboardHandler keyboardHandler() {
        return EnvironmentManager.getClient().keyboardHandler;
    }
}

