/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.item;

import cn.mcmod_mmf.mmlib.item.IFoodLike;
import cn.mcmod_mmf.mmlib.item.info.FoodInfo;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemFoodBase
extends Item
implements IFoodLike {
    private final FoodInfo info;

    public ItemFoodBase(Item.Properties prop, FoodInfo info) {
        super(prop.food(new FoodProperties(info.getAmount(), info.getCalories(), info.isAlwaysEat(), (float)info.getEatTime(), Optional.empty(), List.of())));
        this.info = info;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack itemstack = super.finishUsingItem(stack, level, entity);
        if (stack.getCount() > 0) {
            if (entity instanceof Player) {
                Player entityplayer = (Player)entity;
                if (entityplayer.getAbilities().instabuild) {
                    return itemstack;
                }
                if (!entityplayer.addItem(this.getCraftingRemainingItem(stack))) {
                    entityplayer.drop(this.getCraftingRemainingItem(stack), true);
                }
            }
            return itemstack;
        }
        return entity instanceof Player && ((Player)entity).getAbilities().instabuild ? itemstack : this.getCraftingRemainingItem(stack);
    }

    public SoundEvent getDrinkingSound() {
        return super.getDrinkingSound();
    }

    public SoundEvent getEatingSound() {
        return super.getEatingSound();
    }

    @Override
    public FoodInfo getFoodInfo() {
        return this.info;
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        FoodProperties.Builder food = new FoodProperties.Builder().nutrition(this.getFoodInfo().getAmount()).saturationModifier(this.getFoodInfo().getCalories());
        if (this.getFoodInfo().isAlwaysEat()) {
            food.alwaysEdible();
        }
        if (this.getFoodInfo().getEatTime() <= 16) {
            food.fast();
        }
        this.getFoodInfo().getEffects().forEach(k -> food.effect((Supplier)k.getFirst(), ((Float)k.getSecond()).floatValue()));
        return food.build();
    }

    public int getUseDuration(ItemStack stack, LivingEntity p_344979_) {
        if (this.getFoodInfo() != null) {
            return this.getFoodInfo().getEatTime();
        }
        return super.getUseDuration(stack, p_344979_);
    }

    @Override
    public boolean shouldAddEffectTooltips() {
        return this.info != null;
    }
}

