/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.data.loot;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public abstract class AbstartctBlockLoot
extends BlockLootSubProvider {
    private final Set<Block> knownBlocks = new HashSet<Block>();
    public static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    public static final float[] RARE_SAPLING_DROP_RATES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};
    private static final Set<Item> EXPLOSION_RESISTANT = Set.of();

    protected AbstartctBlockLoot(HolderLookup.Provider p_344943_) {
        super(EXPLOSION_RESISTANT, FeatureFlags.REGISTRY.allFlags(), p_344943_);
    }

    protected void add(Block block, LootTable.Builder builder) {
        super.add(block, builder);
        this.knownBlocks.add(block);
    }

    public abstract void addTables();

    protected void generate() {
        this.addTables();
    }

    public LootTable.Builder silkAndStick(Block block, ItemLike nonSilk, float ... nonSilkFortune) {
        LootItemCondition.Builder NOT_SILK_TOUCH_OR_SHEARS = (LootItemCondition.Builder)ObfuscationReflectionHelper.getPrivateValue(BlockLootSubProvider.class, null, (String)"HAS_NO_SHEARS_OR_SILK_TOUCH");
        return this.createSilkTouchOrShearsDispatchTable(block, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)nonSilk.asItem()))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE), (float[])nonSilkFortune))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(NOT_SILK_TOUCH_OR_SHEARS).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
    }

    public void registerEmpty(Block b) {
        this.add(b, LootTable.lootTable());
    }

    public void registerSlab(Block b) {
        this.add(b, this.createSlabItemTable(b));
    }

    public Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }
}

