/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.data;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class AbstractBlockStateProvider
extends BlockStateProvider {
    private final String modid;

    public AbstractBlockStateProvider(PackOutput gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
        this.modid = modid;
    }

    public void simpleBlock(Supplier<Block> block) {
        this.simpleBlock(block.get(), this.cubeAll(block.get()));
    }

    public void chainBlock(Supplier<Block> block) {
        ModelBuilder cross = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block.get()), this.modid + ":block/chain")).texture("all", this.blockTexture(block.get()))).renderType("minecraft:cutout");
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block.get()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)cross).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)cross).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)cross).rotationX(90).rotationY(90).addModel();
    }

    public void sign(Supplier<? extends StandingSignBlock> standingBlock, Supplier<? extends WallSignBlock> wallBlock, String name) {
        this.signBlock(standingBlock.get(), wallBlock.get(), this.modLoc("block/" + name));
    }

    public void hangingSign(Supplier<? extends CeilingHangingSignBlock> standingBlock, Supplier<? extends WallHangingSignBlock> wallBlock, String name) {
        ModelBuilder model = ((BlockModelBuilder)this.models().getBuilder(this.name((Block)standingBlock.get()))).texture("particle", this.modLoc("block/" + name));
        this.simpleBlock((Block)standingBlock.get(), (ModelFile)model);
        this.simpleBlock((Block)wallBlock.get(), (ModelFile)model);
    }

    public void lantern(Supplier<Block> block) {
        ModelBuilder nonHanging = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block.get()), "block/template_lantern")).renderType("minecraft:cutout")).texture("lantern", this.blockTexture(block.get()));
        ModelBuilder hanging = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block.get()) + "_hanging", "block/template_hanging_lantern")).renderType("minecraft:cutout")).texture("lantern", this.blockTexture(block.get()));
        this.getVariantBuilder(block.get()).forAllStates(arg_0 -> AbstractBlockStateProvider.lambda$lantern$0((ModelFile)hanging, (ModelFile)nonHanging, arg_0));
    }

    public void carpet(Supplier<Block> block) {
        ModelBuilder carpet = ((BlockModelBuilder)this.models().withExistingParent(this.name(block.get()), "block/carpet")).texture("wool", this.blockTexture(block.get()));
        this.carpetBlock(block, arg_0 -> AbstractBlockStateProvider.lambda$carpet$1((ModelFile)carpet, arg_0));
    }

    public void carpetBlock(Supplier<Block> block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).build());
    }

    private ResourceLocation suffix(ResourceLocation rl, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(rl.getPath() + suffix));
    }

    public ModelFile cubeLeavesAll(Supplier<Block> block) {
        return ((BlockModelBuilder)this.models().cubeAll(this.name(block.get()), this.blockTexture(block.get()))).renderType("minecraft:cutout_mipped");
    }

    public void simpleLeavesBlock(Supplier<Block> block) {
        this.simpleBlock(block.get(), this.cubeLeavesAll(block));
    }

    public void cutBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get(), this.cutCubeAll(block));
    }

    private ModelFile cutCubeAll(Supplier<? extends Block> block) {
        return ((BlockModelBuilder)this.models().cubeAll(this.name(block.get()), this.blockTexture(block.get()))).renderType("minecraft:cutout");
    }

    public void translucentBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get(), this.translucentCubeAll(block));
    }

    private ModelFile translucentCubeAll(Supplier<? extends Block> block) {
        return ((BlockModelBuilder)this.models().cubeAll(this.name(block.get()), this.blockTexture(block.get()))).renderType("minecraft:translucent");
    }

    public void torchBlock(Supplier<Block> block, Supplier<Block> wall) {
        ModelBuilder torch = ((BlockModelBuilder)this.models().torch(this.name(block.get()), this.texture(this.name(block.get())))).renderType("minecraft:cutout");
        ModelBuilder torchwall = ((BlockModelBuilder)this.models().torchWall(this.name(wall.get()), this.texture(this.name(block.get())))).renderType("minecraft:cutout");
        this.simpleBlock(block.get(), (ModelFile)torch);
        this.getVariantBuilder(wall.get()).forAllStates(arg_0 -> AbstractBlockStateProvider.lambda$torchBlock$3((ModelFile)torchwall, arg_0));
    }

    public void stairs(Supplier<StairBlock> block, Supplier<Block> fullBlock) {
        this.stairsBlock(block.get(), this.texture(this.name(fullBlock.get())));
    }

    public void slab(Supplier<SlabBlock> block, Supplier<Block> fullBlock) {
        this.slabBlock(block.get(), this.texture(this.name(fullBlock.get())), this.texture(this.name(fullBlock.get())));
    }

    public void slab(Supplier<SlabBlock> block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.slabBlock(block.get(), this.texture(this.name((Block)block.get())), side, bottom, top);
    }

    public void crossBlock(Supplier<Block> block) {
        this.crossBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.name(block.get()), this.texture(this.name(block.get())))).renderType("minecraft:cutout"));
    }

    private void crossBlock(Supplier<Block> block, ModelFile model) {
        this.getVariantBuilder(block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).build());
    }

    public void cake(Supplier<Block> block, String name) {
        this.cakeBlockInternal(block, this.name(block.get()), this.texture(name + "_bottom"), this.texture(name + "_top"), this.texture(name + "_side"), this.texture(name + "_inner"));
    }

    private void cakeBlockInternal(Supplier<Block> block, String baseName, ResourceLocation bottom, ResourceLocation top, ResourceLocation side, ResourceLocation inside) {
        ModelBuilder<?> cake = this.cake(baseName + "_uneaten", bottom, top, side);
        ModelBuilder<?> sliced1 = this.slicedCake(baseName + "_slice1", "cake_slice1", bottom, top, side, inside);
        ModelBuilder<?> sliced2 = this.slicedCake(baseName + "_slice2", "cake_slice2", bottom, top, side, inside);
        ModelBuilder<?> sliced3 = this.slicedCake(baseName + "_slice3", "cake_slice3", bottom, top, side, inside);
        ModelBuilder<?> sliced4 = this.slicedCake(baseName + "_slice4", "cake_slice4", bottom, top, side, inside);
        ModelBuilder<?> sliced5 = this.slicedCake(baseName + "_slice5", "cake_slice5", bottom, top, side, inside);
        ModelBuilder<?> sliced6 = this.slicedCake(baseName + "_slice6", "cake_slice6", bottom, top, side, inside);
        this.cakeBlock(block, (ModelFile)cake, (ModelFile)sliced1, (ModelFile)sliced2, (ModelFile)sliced3, (ModelFile)sliced4, (ModelFile)sliced5, (ModelFile)sliced6);
    }

    public void cakeBlock(Supplier<Block> block, ModelFile uneat, ModelFile sliced1, ModelFile sliced2, ModelFile sliced3, ModelFile sliced4, ModelFile sliced5, ModelFile sliced6) {
        this.getVariantBuilder(block.get()).forAllStatesExcept(state -> {
            int bite = (Integer)state.getValue((Property)CakeBlock.BITES);
            return ConfiguredModel.builder().modelFile(switch (bite) {
                case 0 -> uneat;
                case 1 -> sliced1;
                case 2 -> sliced2;
                case 3 -> sliced3;
                case 4 -> sliced4;
                case 5 -> sliced5;
                default -> sliced6;
            }).build();
        }, new Property[]{DoorBlock.POWERED});
    }

    private ModelBuilder<?> slicedCake(String name, String model, ResourceLocation bottom, ResourceLocation top, ResourceLocation side, ResourceLocation inside) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/" + model)).texture("particle", top)).texture("bottom", bottom)).texture("top", top)).texture("side", side)).texture("inside", inside);
    }

    private ModelBuilder<?> cake(String name, ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/cake")).texture("particle", top)).texture("bottom", bottom)).texture("top", top)).texture("side", side);
    }

    public void door(Supplier<? extends DoorBlock> block, String name) {
        this.doorBlock(block.get(), this.texture(name + "_door_bottom"), this.texture(name + "_door_top"));
    }

    public void ancientFormatDoor(Supplier<? extends DoorBlock> block, String name) {
        this.doorBlockInternal(block.get(), BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).toString(), this.texture("tofudoor_" + name + "_lower"), this.texture("tofudoor_" + name + "_upper"));
    }

    private ModelBuilder<?> door(String name, String model, ResourceLocation bottom, ResourceLocation top) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/" + model)).texture("bottom", bottom)).texture("top", top)).renderType("minecraft:cutout");
    }

    private void doorBlockInternal(DoorBlock block, String baseName, ResourceLocation bottom, ResourceLocation top) {
        ModelBuilder<?> bottomLeft = this.door(baseName + "_bottom_left", "door_bottom_left", bottom, top);
        ModelBuilder<?> bottomLeftOpen = this.door(baseName + "_bottom_left_open", "door_bottom_left_open", bottom, top);
        ModelBuilder<?> bottomRight = this.door(baseName + "_bottom_right", "door_bottom_right", bottom, top);
        ModelBuilder<?> bottomRightOpen = this.door(baseName + "_bottom_right_open", "door_bottom_right_open", bottom, top);
        ModelBuilder<?> topLeft = this.door(baseName + "_top_left", "door_top_left", bottom, top);
        ModelBuilder<?> topLeftOpen = this.door(baseName + "_top_left_open", "door_top_left_open", bottom, top);
        ModelBuilder<?> topRight = this.door(baseName + "_top_right", "door_top_right", bottom, top);
        ModelBuilder<?> topRightOpen = this.door(baseName + "_top_right_open", "door_top_right_open", bottom, top);
        this.doorBlock(block, (ModelFile)bottomLeft, (ModelFile)bottomLeftOpen, (ModelFile)bottomRight, (ModelFile)bottomRightOpen, (ModelFile)topLeft, (ModelFile)topLeftOpen, (ModelFile)topRight, (ModelFile)topRightOpen);
    }

    public void doorBlock(DoorBlock block, ModelFile bottomLeft, ModelFile bottomLeftOpen, ModelFile bottomRight, ModelFile bottomRightOpen, ModelFile topLeft, ModelFile topLeftOpen, ModelFile topRight, ModelFile topRightOpen) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.getValue((Property)DoorBlock.FACING)).toYRot() + 90;
            boolean right = state.getValue((Property)DoorBlock.HINGE) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.getValue((Property)DoorBlock.OPEN);
            if (open) {
                yRot += 90;
            }
            if (right && open) {
                yRot += 180;
            }
            return ConfiguredModel.builder().modelFile(state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER ? (right ? (open ? bottomRightOpen : bottomRight) : (open ? bottomLeftOpen : bottomLeft)) : (right ? (open ? topRightOpen : topRight) : (open ? topLeftOpen : topLeft))).rotationY(yRot %= 360).build();
        }, new Property[]{DoorBlock.POWERED});
    }

    public void wall(Supplier<? extends WallBlock> wall, Supplier<? extends Block> fullBlock) {
        this.wallBlock(wall.get(), this.texture(this.name(fullBlock.get())));
    }

    public void trapdoor(Supplier<? extends TrapDoorBlock> block) {
        this.trapdoor(block.get(), this.texture(this.name((Block)block.get())), true);
    }

    public void trapdoor(TrapDoorBlock block, ResourceLocation texture, boolean orientable) {
        this.trapdoorBlockInternal(block, this.name((Block)block), texture, orientable);
    }

    private void trapdoorBlockInternal(TrapDoorBlock block, String baseName, ResourceLocation texture, boolean orientable) {
        ModelBuilder bottom = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableBottom(baseName + "_bottom", texture)).renderType("minecraft:cutout") : ((BlockModelBuilder)this.models().trapdoorBottom(baseName + "_bottom", texture)).renderType("minecraft:cutout");
        ModelBuilder top = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableTop(baseName + "_top", texture)).renderType("minecraft:cutout") : ((BlockModelBuilder)this.models().trapdoorTop(baseName + "_top", texture)).renderType("minecraft:cutout");
        ModelBuilder open = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableOpen(baseName + "_open", texture)).renderType("minecraft:cutout") : ((BlockModelBuilder)this.models().trapdoorOpen(baseName + "_open", texture)).renderType("minecraft:cutout");
        this.trapdoorBlock(block, (ModelFile)bottom, (ModelFile)top, (ModelFile)open, orientable);
    }

    protected VariantBlockStateBuilder make2LayerCubeAllSidesSame(Block block, Block block2, ResourceLocation renderType, int layer1em, int layer2em, boolean shade) {
        return this.make2LayerCube(block, block2, renderType, layer1em, layer1em, layer1em, layer1em, layer1em, layer1em, layer2em, layer2em, layer2em, layer2em, layer2em, layer2em, shade);
    }

    protected VariantBlockStateBuilder make2LayerCubeAllSidesSame(Block block, ResourceLocation renderType, int layer1em, int layer2em, boolean shade) {
        return this.make2LayerCube(block, block, renderType, layer1em, layer1em, layer1em, layer1em, layer1em, layer1em, layer2em, layer2em, layer2em, layer2em, layer2em, layer2em, shade);
    }

    protected VariantBlockStateBuilder make2LayerCube(Block block, Block block2, ResourceLocation renderType, int layer1emN, int layer1emS, int layer1emW, int layer1emE, int layer1emU, int layer1emD, int layer2emN, int layer2emS, int layer2emW, int layer2emE, int layer2emU, int layer2emD, boolean shade) {
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.blockTexture(block).getPath(), "minecraft:block/block")).renderType(renderType)).texture("particle", "#bottom")).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).shade(shade).face(Direction.NORTH).texture("#north").cullface(Direction.NORTH).emissivity(layer1emN, layer1emN).end().face(Direction.EAST).texture("#east").cullface(Direction.EAST).emissivity(layer1emE, layer1emE).end().face(Direction.SOUTH).texture("#south").cullface(Direction.SOUTH).emissivity(layer1emS, layer1emS).end().face(Direction.WEST).texture("#west").cullface(Direction.WEST).emissivity(layer1emW, layer1emW).end().face(Direction.UP).texture("#top").cullface(Direction.UP).emissivity(layer1emU, layer1emU).end().face(Direction.DOWN).texture("#bottom").cullface(Direction.DOWN).emissivity(layer1emD, layer1emD).end().end()).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.NORTH).texture("#north2").cullface(Direction.NORTH).emissivity(layer2emN, layer2emN).tintindex(0).end().face(Direction.EAST).texture("#east2").cullface(Direction.EAST).emissivity(layer2emE, layer2emE).tintindex(0).end().face(Direction.SOUTH).texture("#south2").cullface(Direction.SOUTH).emissivity(layer2emS, layer2emS).tintindex(0).end().face(Direction.WEST).texture("#west2").cullface(Direction.WEST).emissivity(layer2emW, layer2emW).tintindex(0).end().face(Direction.UP).texture("#top2").cullface(Direction.UP).emissivity(layer2emU, layer2emU).tintindex(0).end().face(Direction.DOWN).texture("#bottom2").cullface(Direction.DOWN).emissivity(layer2emD, layer2emD).tintindex(0).end().end()).texture("north", "#all")).texture("south", "#all")).texture("east", "#all")).texture("west", "#all")).texture("top", "#all")).texture("bottom", "#all")).texture("north2", "#all2")).texture("south2", "#all2")).texture("east2", "#all2")).texture("west2", "#all2")).texture("top2", "#all2")).texture("bottom2", "#all2")).texture("all", this.blockTexture(block2))).texture("all2", this.suffix(this.blockTexture(block), "_emissive"));
        return (VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().modelForState().modelFile((ModelFile)builder).addModel();
    }

    protected VariantBlockStateBuilder make2LayerLogSidesSame(RotatedPillarBlock block, ResourceLocation renderType, int layer1em, int layer2em, boolean shade) {
        return this.make2LayerLog(block, renderType, layer1em, layer1em, layer1em, layer1em, layer1em, layer1em, layer2em, layer2em, layer2em, layer2em, layer2em, layer2em, shade);
    }

    protected VariantBlockStateBuilder make2LayerLog(RotatedPillarBlock block, ResourceLocation renderType, int layer1emN, int layer1emS, int layer1emW, int layer1emE, int layer1emU, int layer1emD, int layer2emN, int layer2emS, int layer2emW, int layer2emE, int layer2emU, int layer2emD, boolean shade) {
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.blockTexture((Block)block).getPath(), "minecraft:block/block")).renderType(renderType)).texture("particle", "#side")).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).shade(shade).face(Direction.NORTH).texture("#side").cullface(Direction.NORTH).emissivity(layer1emN, layer1emN).end().face(Direction.EAST).texture("#side").cullface(Direction.EAST).emissivity(layer1emE, layer1emE).end().face(Direction.SOUTH).texture("#side").cullface(Direction.SOUTH).emissivity(layer1emS, layer1emS).end().face(Direction.WEST).texture("#side").cullface(Direction.WEST).emissivity(layer1emW, layer1emW).end().face(Direction.UP).texture("#end").cullface(Direction.UP).emissivity(layer1emU, layer1emU).end().face(Direction.DOWN).texture("#end").cullface(Direction.DOWN).emissivity(layer1emD, layer1emD).end().end()).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.NORTH).texture("#side2").cullface(Direction.NORTH).emissivity(layer2emN, layer2emN).tintindex(0).end().face(Direction.EAST).texture("#side2").cullface(Direction.EAST).emissivity(layer2emE, layer2emE).tintindex(0).end().face(Direction.SOUTH).texture("#side2").cullface(Direction.SOUTH).emissivity(layer2emS, layer2emS).tintindex(0).end().face(Direction.WEST).texture("#side2").cullface(Direction.WEST).emissivity(layer2emW, layer2emW).tintindex(0).end().face(Direction.UP).texture("#end2").cullface(Direction.UP).emissivity(layer2emU, layer2emU).tintindex(0).end().face(Direction.DOWN).texture("#end2").cullface(Direction.DOWN).emissivity(layer2emD, layer2emD).tintindex(0).end().end()).texture("side", this.blockTexture((Block)block))).texture("side2", this.suffix(this.blockTexture((Block)block), "_emissive"))).texture("end", this.suffix(this.blockTexture((Block)block), "_top"))).texture("end2", this.suffix(this.blockTexture((Block)block), "_top_emissive"));
        return (VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)builder).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)builder).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)builder).rotationX(90).rotationY(90).addModel();
    }

    protected ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    protected String name(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$torchBlock$3(ModelFile torchwall, BlockState state) {
        return ConfiguredModel.builder().modelFile(torchwall).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 90) % 360).build();
    }

    private static /* synthetic */ ModelFile lambda$carpet$1(ModelFile carpet, BlockState state) {
        return carpet;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$lantern$0(ModelFile hanging, ModelFile nonHanging, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.getValue((Property)LanternBlock.HANGING) != false ? hanging : nonHanging).build();
    }
}

