/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.block.entity;

import cn.mcmod_mmf.mmlib.CommonTags;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public interface HeatableBlockEntity {
    default public boolean isHeated(Level level, BlockPos pos) {
        BlockState stateBelow = level.getBlockState(pos.below());
        if (stateBelow.is(this.heatSourceTag())) {
            if (stateBelow.hasProperty((Property)BlockStateProperties.LIT)) {
                return (Boolean)stateBelow.getValue((Property)BlockStateProperties.LIT);
            }
            return true;
        }
        if (!this.requiresDirectHeat() && stateBelow.is(this.heatConductorTag())) {
            BlockState stateFurtherBelow = level.getBlockState(pos.below(2));
            if (stateBelow.is(this.heatSourceTag())) {
                if (stateFurtherBelow.hasProperty((Property)BlockStateProperties.LIT)) {
                    return (Boolean)stateFurtherBelow.getValue((Property)BlockStateProperties.LIT);
                }
                return true;
            }
        }
        return false;
    }

    default public TagKey<Block> heatSourceTag() {
        return CommonTags.HEAT_SOURCES;
    }

    default public TagKey<Block> heatConductorTag() {
        return CommonTags.HEAT_CONDUCTORS;
    }

    default public boolean requiresDirectHeat() {
        return false;
    }
}

