/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.playerrevive.PlayerRevive;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.client.TensionSound;
import team.creative.playerrevive.mixin.LocalPlayerAccessor;
import team.creative.playerrevive.mixin.MinecraftAccessor;
import team.creative.playerrevive.packet.GiveUpPacket;
import team.creative.playerrevive.server.PlayerReviveServer;

@OnlyIn(value=Dist.CLIENT)
public class ReviveEventClient {
    private static final ResourceLocation BLUR_SHADER = ResourceLocation.tryBuild((String)"playerrevive", (String)"shaders/post/blobs2.json");
    public static Minecraft mc = Minecraft.getInstance();
    public static TensionSound sound;
    public static UUID helpTarget;
    public static boolean helpActive;
    public boolean lastShader = false;
    public boolean lastHighTension = false;
    private boolean addedEffect = false;
    private int giveUpTimer = 0;
    private boolean inPauseScreen = false;

    public static void render(GuiGraphics graphics, List<Component> list) {
        String text;
        int i;
        int space = 15;
        int width = 0;
        for (i = 0; i < list.size(); ++i) {
            text = list.get(i).getString();
            width = Math.max(width, ReviveEventClient.mc.font.width(text) + 10);
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        for (i = 0; i < list.size(); ++i) {
            text = list.get(i).getString();
            graphics.drawString(ReviveEventClient.mc.font, text, mc.getWindow().getGuiScaledWidth() / 2 - ReviveEventClient.mc.font.width(text) / 2, mc.getWindow().getGuiScaledHeight() / 2 + (list.size() / 2 * space - space * (i + 1)), 0xFCFCFC);
        }
        RenderSystem.enableDepthTest();
    }

    @SubscribeEvent
    public void playerTick(PlayerTickEvent.Post event) {
        IBleeding revive = PlayerReviveServer.getBleeding(event.getEntity());
        if (revive.isBleeding()) {
            event.getEntity().setPose(Pose.SWIMMING);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void click(InputEvent.InteractionKeyMappingTriggered event) {
        IBleeding revive;
        LocalPlayer player = ReviveEventClient.mc.player;
        if (player != null && (revive = PlayerReviveServer.getBleeding((Player)player)).isBleeding()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void screenOpen(ScreenEvent.Opening event) {
        LocalPlayer player = ReviveEventClient.mc.player;
        if (player != null) {
            IBleeding revive = PlayerReviveServer.getBleeding((Player)player);
            if (!revive.isBleeding()) {
                return;
            }
            if (event.getCurrentScreen() == null) {
                this.inPauseScreen = false;
            }
            if (PlayerRevive.CONFIG.bleeding.disableInventoryAccess && event.getNewScreen() instanceof InventoryScreen) {
                event.setCanceled(true);
            } else if (PlayerRevive.CONFIG.bleeding.disableChatAccess && event.getNewScreen() instanceof ChatScreen) {
                event.setCanceled(true);
            } else if (PlayerRevive.CONFIG.bleeding.disableAllGUIAccess && !(event.getNewScreen() instanceof DeathScreen)) {
                if (event.getNewScreen() instanceof PauseScreen) {
                    this.inPauseScreen = true;
                }
                if (!this.inPauseScreen) {
                    event.setCanceled(true);
                }
            } else {
                this.inPauseScreen = true;
            }
        }
    }

    @SubscribeEvent
    public void clientTick(ClientTickEvent.Post event) {
        LocalPlayer player = ReviveEventClient.mc.player;
        if (player != null) {
            IBleeding revive = PlayerReviveServer.getBleeding((Player)player);
            if (revive.isBleeding()) {
                if (ReviveEventClient.mc.options.keyAttack.isDown()) {
                    if (this.giveUpTimer > PlayerRevive.CONFIG.bleeding.giveUpSeconds * 20) {
                        PlayerRevive.NETWORK.sendToServer((CreativePacket)new GiveUpPacket());
                        this.giveUpTimer = 0;
                    } else {
                        ++this.giveUpTimer;
                    }
                } else {
                    this.giveUpTimer = 0;
                }
            } else {
                this.giveUpTimer = 0;
            }
        }
    }

    @SubscribeEvent
    public void frameEvent(RenderFrameEvent.Pre event) {
        Player other;
        IBleeding revive;
        LocalPlayer player = ReviveEventClient.mc.player;
        if (player != null && PlayerRevive.CONFIG.revive.forceLookAt && !(revive = PlayerReviveServer.getBleeding((Player)player)).isBleeding() && helpActive && (other = player.level().getPlayerByUUID(helpTarget)) != null) {
            float partial = event.getPartialTick().getGameTimeDeltaPartialTick(false);
            Vec3 vec3 = player.getEyePosition(partial);
            Vec3 center = other.getPosition(partial);
            double d0 = center.x - vec3.x;
            double d1 = center.y - vec3.y;
            double d2 = center.z - vec3.z;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            player.setXRot(Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d1, (double)d3) * 180.0 / 3.1415927410125732)))));
            player.setYRot(Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 180.0 / 3.1415927410125732) - 90.0f)));
            player.setYHeadRot(player.getYRot());
            player.xRotO = player.getXRot();
            player.yRotO = player.getYRot();
            player.yHeadRotO = player.yHeadRot;
            player.yBodyRotO = player.yBodyRot = player.yHeadRot;
        }
    }

    @SubscribeEvent
    public void tick(RenderGuiLayerEvent.Post event) {
        LocalPlayer player = ReviveEventClient.mc.player;
        if (player != null) {
            IBleeding revive = PlayerReviveServer.getBleeding((Player)player);
            if (!revive.isBleeding()) {
                Player other;
                this.lastHighTension = false;
                if (this.lastShader) {
                    ReviveEventClient.mc.gameRenderer.checkEntityPostEffect(mc.getCameraEntity());
                    this.lastShader = false;
                }
                if (this.addedEffect) {
                    player.removeEffect(MobEffects.JUMP);
                    ((LocalPlayerAccessor)player).setHandsBusy(false);
                    this.addedEffect = false;
                }
                if (sound != null) {
                    mc.getSoundManager().stop((SoundInstance)sound);
                    sound = null;
                }
                if (helpActive && !ReviveEventClient.mc.options.hideGui && ReviveEventClient.mc.screen == null && (other = player.level().getPlayerByUUID(helpTarget)) != null) {
                    ArrayList<Component> list = new ArrayList<Component>();
                    IBleeding bleeding = PlayerReviveServer.getBleeding(other);
                    list.add((Component)Component.translatable((String)"playerrevive.gui.label.time_left", (Object[])new Object[]{this.formatTime(bleeding.timeLeft())}));
                    list.add((Component)Component.literal((String)(bleeding.getProgress() + "/" + PlayerRevive.CONFIG.revive.requiredReviveProgress)));
                    ReviveEventClient.render(event.getGuiGraphics(), list);
                }
            } else {
                player.setPose(Pose.SWIMMING);
                ((LocalPlayerAccessor)player).setHandsBusy(true);
                ((MinecraftAccessor)mc).setMissTime(2);
                player.addEffect(new MobEffectInstance(MobEffects.JUMP, 0, -10));
                player.hurtTime = 0;
                this.addedEffect = true;
                if (revive.timeLeft() < 400) {
                    if (!this.lastHighTension) {
                        if (!PlayerRevive.CONFIG.disableMusic) {
                            mc.getSoundManager().stop((SoundInstance)sound);
                            sound = new TensionSound(ResourceLocation.tryBuild((String)"playerrevive", (String)"hightension"), PlayerRevive.CONFIG.countdownMusicVolume, 1.0f, false);
                            mc.getSoundManager().play((SoundInstance)sound);
                        }
                        this.lastHighTension = true;
                    }
                } else if (!this.lastShader) {
                    if (sound != null) {
                        mc.getSoundManager().stop((SoundInstance)sound);
                    }
                    if (!PlayerRevive.CONFIG.disableMusic) {
                        sound = new TensionSound(ResourceLocation.tryBuild((String)"playerrevive", (String)"tension"), PlayerRevive.CONFIG.bleedingMusicVolume, 1.0f, true);
                        mc.getSoundManager().play((SoundInstance)sound);
                    }
                }
                if (!this.lastShader) {
                    if (PlayerRevive.CONFIG.bleeding.hasShaderEffect) {
                        ReviveEventClient.mc.gameRenderer.loadEffect(BLUR_SHADER);
                    }
                    this.lastShader = true;
                } else if (PlayerRevive.CONFIG.bleeding.hasShaderEffect && (ReviveEventClient.mc.gameRenderer.currentEffect() == null || !ReviveEventClient.mc.gameRenderer.currentEffect().getName().equals(BLUR_SHADER.toString()))) {
                    ReviveEventClient.mc.gameRenderer.loadEffect(BLUR_SHADER);
                }
                if (!ReviveEventClient.mc.options.hideGui && ReviveEventClient.mc.screen == null) {
                    ArrayList<Component> list = new ArrayList<Component>();
                    IBleeding bleeding = PlayerReviveServer.getBleeding((Player)player);
                    list.add((Component)Component.translatable((String)"playerrevive.gui.label.time_left", (Object[])new Object[]{this.formatTime(bleeding.timeLeft())}));
                    list.add((Component)Component.literal((String)(bleeding.getProgress() + "/" + PlayerRevive.CONFIG.revive.requiredReviveProgress)));
                    list.add((Component)Component.translatable((String)"playerrevive.gui.hold", (Object[])new Object[]{ReviveEventClient.mc.options.keyAttack.getKey().getDisplayName(), (PlayerRevive.CONFIG.bleeding.giveUpSeconds * 20 - this.giveUpTimer) / 20 + 1}));
                    ReviveEventClient.render(event.getGuiGraphics(), list);
                }
            }
        }
    }

    public String formatTime(int timeLeft) {
        int lengthOfMinute = 1200;
        int lengthOfHour = lengthOfMinute * 60;
        int hours = timeLeft / lengthOfHour;
        int minutes = (timeLeft -= hours * lengthOfHour) / lengthOfMinute;
        int seconds = (timeLeft -= minutes * lengthOfMinute) / 20;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    static {
        helpActive = false;
    }
}

