/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.premade.MobEffectConfig;
import team.creative.creativecore.common.config.premade.SoundConfig;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;

public class PlayerReviveConfig {
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public boolean disableMusic = true;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    @CreativeConfig.DecimalRange(min=0.0, max=2.0)
    public float bleedingMusicVolume = 1.0f;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    @CreativeConfig.DecimalRange(min=0.0, max=2.0)
    public float countdownMusicVolume = 1.0f;
    @CreativeConfig
    public boolean banPlayerAfterDeath = false;
    @CreativeConfig
    public Bleeding bleeding = new Bleeding();
    @CreativeConfig
    public Revive revive = new Revive();
    @CreativeConfig
    public Sounds sounds = new Sounds();
    @CreativeConfig
    public List<String> bypassDamageSources = Arrays.asList("gorgon", "death.attack.sgcraft:transient", "death.attack.sgcraft:iris", "vampirism_dbno", "hordes:infection");
    @CreativeConfig
    public boolean enableBypassDamage;
    @CreativeConfig
    public int bypassDamage = 10;
    @CreativeConfig
    public List<DamageTypeConfig> bypassSourceByDamage = new ArrayList<DamageTypeConfig>();
    @CreativeConfig
    public boolean bleedInSingleplayer = false;

    static {
        ConfigTypeConveration.registerTypeCreator(DamageTypeConfig.class, () -> new DamageTypeConfig("", 0));
    }

    public static class Bleeding {
        @CreativeConfig
        public int bleedTime = 1200;
        @CreativeConfig(type=ConfigSynchronization.CLIENT)
        public int giveUpSeconds = 5;
        @CreativeConfig
        public boolean triggerForCreative = true;
        @CreativeConfig
        public boolean bleedingMessage = true;
        @CreativeConfig
        public boolean bleedingMessageTrackingOnly = true;
        @CreativeConfig
        public boolean shouldGlow = false;
        @CreativeConfig
        public List<MobEffectConfig> bleedingEffects = Arrays.asList(new MobEffectConfig(BuiltInRegistries.MOB_EFFECT, ResourceLocation.tryBuild((String)"minecraft", (String)"slowness"), 2, 10, true));
        @CreativeConfig
        public boolean affectHunger = true;
        @CreativeConfig
        @CreativeConfig.IntRange(min=1, max=20)
        public int remainingHunger = 6;
        @CreativeConfig
        public int initialDamageCooldown = 10;
        @CreativeConfig
        public int bleedingHealth = 10;
        @CreativeConfig
        public boolean disableMobDamage = true;
        @CreativeConfig
        public boolean disablePlayerDamage = false;
        @CreativeConfig
        public boolean disableOtherDamage = false;
        @CreativeConfig
        public boolean hasShaderEffect = true;
        @CreativeConfig
        public double blurRadius = 4.0;
        @CreativeConfig
        public boolean changePermissionLevel = false;
        @CreativeConfig
        public int permissionLevel = 0;
        @CreativeConfig
        public boolean canBePushed = true;
        @CreativeConfig
        public boolean disableAllGUIAccess = false;
        @CreativeConfig
        public boolean disableInventoryAccess = false;
        @CreativeConfig
        public boolean disableChatAccess = false;
        @CreativeConfig
        public boolean disableServerCommands = false;
    }

    public static class Revive {
        @CreativeConfig
        public float requiredReviveProgress = 100.0f;
        @CreativeConfig
        public float progressPerPlayer = 1.0f;
        @CreativeConfig
        public float exhaustion = 0.5f;
        @CreativeConfig
        public boolean haltBleedTime = true;
        @CreativeConfig
        public boolean abortOnDamage = false;
        @CreativeConfig
        public boolean resetProgress = false;
        @CreativeConfig
        public List<MobEffectConfig> revivedEffects = Arrays.asList(new MobEffectConfig(BuiltInRegistries.MOB_EFFECT, ResourceLocation.tryBuild((String)"minecraft", (String)"slowness"), 2, 1, true));
        @CreativeConfig
        public CreativeIngredient reviveItem = new CreativeIngredientItem(Items.PAPER);
        @CreativeConfig
        public boolean needReviveItem = false;
        @CreativeConfig
        public boolean consumeReviveItem = false;
        @CreativeConfig
        public double maxDistance = 3.0;
        @CreativeConfig
        @CreativeConfig.IntRange(min=1, max=20)
        public int healthAfter = 2;
        @CreativeConfig
        public boolean forceLookAt = false;
    }

    public static class Sounds {
        @CreativeConfig
        public SoundConfig death = new SoundConfig(ResourceLocation.tryBuild((String)"playerrevive", (String)"death"));
        @CreativeConfig
        public SoundConfig revived = new SoundConfig(ResourceLocation.tryBuild((String)"playerrevive", (String)"revived"));
    }

    public static class DamageTypeConfig {
        @CreativeConfig
        public String damageType;
        @CreativeConfig
        public int damageAmount;

        public DamageTypeConfig(String damageType, int damageAmount) {
            this.damageType = damageType;
            this.damageAmount = damageAmount;
        }
    }
}

