/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.core.tile.IBlockEventBlockEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public interface IOrientableBlockEntity
extends IBlockEventBlockEntity {
    default public int getRotation() {
        return (Integer)this.getBlockLevel().getBlockState(this.getBlockPosition()).getValue((Property)ProjectRedBlock.ROTATION);
    }

    default public void setRotation(int r) {
        BlockState state = (BlockState)this.getBlockLevel().getBlockState(this.getBlockPosition()).setValue((Property)ProjectRedBlock.ROTATION, (Comparable)Integer.valueOf(r));
        this.getBlockLevel().setBlockAndUpdate(this.getBlockPosition(), state);
    }

    default public int getSide() {
        return (Integer)this.getBlockLevel().getBlockState(this.getBlockPosition()).getValue((Property)ProjectRedBlock.SIDE);
    }

    default public void setSide(int s) {
        BlockState state = (BlockState)this.getBlockLevel().getBlockState(this.getBlockPosition()).setValue((Property)ProjectRedBlock.SIDE, (Comparable)Integer.valueOf(s));
        this.getBlockLevel().setBlockAndUpdate(this.getBlockPosition(), state);
    }

    @Override
    default public ItemInteractionResult useItemOn(ItemStack held, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = held.getItem();
        if (item instanceof IScrewdriver) {
            IScrewdriver screwdriver = (IScrewdriver)item;
            if (screwdriver.canUse(player, hand)) {
                if (!this.getBlockLevel().isClientSide) {
                    if ((player.isShiftKeyDown() || !this.canOrient()) && this.canRotate()) {
                        this.rotateBlock();
                    } else if (this.canOrient()) {
                        this.orientBlock();
                    }
                    screwdriver.damageScrewdriver(player, hand);
                }
                return ItemInteractionResult.sidedSuccess((boolean)this.getBlockLevel().isClientSide);
            }
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    default public boolean canRotate() {
        return this.getBlockLevel().getBlockState(this.getBlockPosition()).hasProperty((Property)ProjectRedBlock.ROTATION);
    }

    default public boolean canOrient() {
        return this.getBlockLevel().getBlockState(this.getBlockPosition()).hasProperty((Property)ProjectRedBlock.SIDE);
    }

    default public void rotateBlock() {
        this.setRotation((this.getRotation() + 1) % 4);
        this.onOrientationChange();
    }

    default public void orientBlock() {
        this.setSide((this.getSide() + 1) % 6);
        this.onOrientationChange();
    }

    public void onOrientationChange();
}

