/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.inventory;

import mrtjp.projectred.core.ProjectRedCore;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class BaseContainer
extends SimpleContainer {
    private static final String TAG_ITEMS = "items";
    private static final String TAG_SLOT = "slot";

    public BaseContainer(int size) {
        super(size);
    }

    public BaseContainer(ItemStack ... stacks) {
        super(stacks);
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt(TAG_SLOT, i);
            list.add((Object)stack.save(lookupProvider, (Tag)itemTag));
        }
        tag.put(TAG_ITEMS, (Tag)list);
        return tag;
    }

    public void load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.clearContent();
        ListTag list = tag.getList(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag itemTag = list.getCompound(i);
            int slot = itemTag.getInt(TAG_SLOT);
            if (slot < 0 || slot >= this.getContainerSize()) continue;
            ItemStack.parse((HolderLookup.Provider)lookupProvider, (Tag)itemTag).ifPresent(stack -> this.setItem(slot, (ItemStack)stack));
        }
    }

    public void saveTo(CompoundTag parent, String key, HolderLookup.Provider lookupProvider) {
        parent.put(key, (Tag)this.save(new CompoundTag(), lookupProvider));
    }

    public void loadFrom(CompoundTag parent, String key, HolderLookup.Provider lookupProvider) {
        ListTag itemList = parent.getList(key, 10);
        if (!itemList.isEmpty()) {
            this.fromTag(itemList, lookupProvider);
            ProjectRedCore.LOGGER.warn("Inventory {} loaded from non-ordered data. Its contents may have shuffled", (Object)this);
        } else {
            this.load(parent.getCompound(key), lookupProvider);
        }
    }

    public static int getItemCount(CompoundTag tag) {
        return tag.getList(TAG_ITEMS, 10).size();
    }

    @Deprecated
    public ListTag createTag(HolderLookup.Provider lookupProvider) {
        return super.createTag(lookupProvider);
    }

    @Deprecated
    public void fromTag(ListTag pContainerNbt, HolderLookup.Provider lookupProvider) {
        super.fromTag(pContainerNbt, lookupProvider);
    }
}

