/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.multipart.api.RedstoneInteractions;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.redstone.FaceRedstonePart;
import mrtjp.projectred.core.FaceLookup;
import mrtjp.projectred.core.part.IRedwireEmitter;
import mrtjp.projectred.core.part.IRedwirePart;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class RedstoneFaceLookup {
    public static int resolveSignal(FaceLookup lookup, boolean diminishRedwire) {
        MultiPart multiPart = lookup.part;
        if (multiPart instanceof IRedwirePart) {
            IRedwirePart rp = (IRedwirePart)multiPart;
            int signal = rp.getRedwireSignal(lookup.otherRotation);
            if (diminishRedwire && rp.diminishOnSide(lookup.otherRotation)) {
                --signal;
            }
            return Math.max(0, signal);
        }
        MultiPart signal = lookup.part;
        if (signal instanceof IRedwireEmitter) {
            IRedwireEmitter rwe = (IRedwireEmitter)signal;
            return rwe.getRedwireSignal(lookup.otherRotation);
        }
        signal = lookup.part;
        if (signal instanceof FaceRedstonePart) {
            FaceRedstonePart fp = (FaceRedstonePart)signal;
            int s = lookup.otherDir;
            return Math.max(fp.strongPowerLevel(s), fp.weakPowerLevel(s)) * 17;
        }
        return 0;
    }

    public static int resolveVanillaSignal(FaceLookup lookup, MultiPart part, boolean strong, boolean limitDust) {
        if (lookup.block == Blocks.REDSTONE_WIRE) {
            int signal = Math.max((Integer)lookup.state.getValue((Property)RedStoneWireBlock.POWER) - 1, 0);
            if (limitDust) {
                return signal;
            }
        }
        return RedstoneInteractions.getPowerTo((MultiPart)part, (int)lookup.dir) * 17;
    }
}

