/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.util.CoordUtil;
import de.srendi.advancedperipherals.common.util.FingerprintUtil;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalFilter;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemChemicalHandler;
import java.util.Objects;
import java.util.stream.IntStream;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChemicalUtil {
    public static long moveChemical(IChemicalHandler inventoryFrom, IChemicalHandler inventoryTo, ChemicalFilter filter) {
        ChemicalInserter inserter;
        if (inventoryFrom == null) {
            return 0L;
        }
        int fromSlot = filter.getFromSlot();
        int toSlot = filter.getToSlot();
        if (!(inventoryFrom instanceof IStorageSystemChemicalHandler) && fromSlot >= inventoryFrom.getChemicalTanks()) {
            return 0L;
        }
        if (!(inventoryTo instanceof IStorageSystemChemicalHandler) && toSlot >= inventoryTo.getChemicalTanks()) {
            return 0L;
        }
        long needs = filter.getAmount();
        if (needs <= 0L) {
            return 0L;
        }
        if (inventoryTo instanceof IStorageSystemChemicalHandler) {
            IStorageSystemChemicalHandler storageTo = (IStorageSystemChemicalHandler)inventoryTo;
            v0 = stack -> storageTo.insertChemical(stack, Action.EXECUTE);
        } else {
            v0 = inserter = toSlot < 0 ? stack -> inventoryTo.insertChemical(stack, Action.EXECUTE) : stack -> inventoryTo.insertChemical(toSlot, stack, Action.EXECUTE);
        }
        if (inventoryFrom instanceof IStorageSystemChemicalHandler) {
            IStorageSystemChemicalHandler storageFrom = (IStorageSystemChemicalHandler)inventoryFrom;
            return storageFrom.extractChemicals(filter, extracted -> extracted.getAmount() - inserter.insertChemical((ChemicalStack)extracted).getAmount(), Action.EXECUTE);
        }
        int[] fromSlots = (fromSlot >= 0 ? IntStream.of(fromSlot) : IntStream.range(0, inventoryFrom.getChemicalTanks())).filter(i -> filter.test(inventoryFrom.getChemicalInTank(i))).toArray();
        if (fromSlots.length == 0) {
            return 0L;
        }
        for (int i2 : fromSlots) {
            ChemicalStack extracted2 = inventoryFrom.extractChemical(i2, needs, Action.SIMULATE);
            if (extracted2.isEmpty()) continue;
            ChemicalStack remaining = inserter.insertChemical(extracted2);
            long inserted = extracted2.getAmount() - remaining.getAmount();
            if (inserted == 0L) continue;
            inventoryFrom.extractChemical(i2, inserted, Action.SIMULATE);
            if ((needs -= inserted) <= 0L) break;
        }
        return filter.getAmount() - needs;
    }

    public static IChemicalHandler extractHandler(@Nullable Object object, @Nullable Level level, @Nullable BlockPos pos, @Nullable Direction direction) {
        if (object instanceof IChemicalHandler) {
            IChemicalHandler itemHandler = (IChemicalHandler)object;
            return itemHandler;
        }
        if (object instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)object;
            if (level == null && pos == null) {
                pos = blockEntity.getBlockPos();
                level = blockEntity.getLevel();
            }
        }
        if (level != null && pos != null) {
            return (IChemicalHandler)level.getCapability(Capabilities.CHEMICAL.block(), pos, (Object)(direction != null ? direction : Direction.NORTH));
        }
        return null;
    }

    @Nullable
    public static IChemicalHandler getHandlerFromDirection(@NotNull String direction, @NotNull IPeripheralOwner owner) throws LuaException {
        Level level = owner.getLevel();
        Objects.requireNonNull(level);
        Direction relativeDirection = CoordUtil.getDirection(owner.getOrientation(), direction);
        if (relativeDirection == null) {
            return null;
        }
        BlockEntity target = level.getBlockEntity(owner.getPos().relative(relativeDirection));
        if (target == null) {
            return null;
        }
        return ChemicalUtil.extractHandler(target, level, owner.getPos().relative(relativeDirection), relativeDirection);
    }

    @Nullable
    public static IChemicalHandler getHandlerFromName(@NotNull IComputerAccess access, String name) throws LuaException {
        IPeripheral location = access.getAvailablePeripheral(name);
        if (location == null) {
            return null;
        }
        IChemicalHandler handler = ChemicalUtil.extractHandler(location.getTarget(), null, null, null);
        if (handler == null) {
            throw new LuaException("Target '" + name + "' is not a chemical handler");
        }
        return handler;
    }

    public static ChemicalStack toChemicalStack(Chemical chemical, long amount) {
        return new ChemicalStack(MekanismAPI.CHEMICAL_REGISTRY.wrapAsHolder((Object)chemical), amount);
    }

    public static String getFingerprint(@NotNull ChemicalStack stack) {
        FingerprintUtil.FingerprintKey fingerprintKey = new FingerprintUtil.FingerprintKey(ChemicalUtil.getRegistryKey(stack), null, null);
        return FingerprintUtil.hash(fingerprintKey);
    }

    public static ResourceLocation getRegistryKey(Chemical chemical) {
        return MekanismAPI.CHEMICAL_REGISTRY.getKey((Object)chemical);
    }

    public static ResourceLocation getRegistryKey(ChemicalStack chemicalStack) {
        return MekanismAPI.CHEMICAL_REGISTRY.getKey((Object)chemicalStack.getChemical());
    }

    @FunctionalInterface
    private static interface ChemicalInserter {
        public ChemicalStack insertChemical(ChemicalStack var1);
    }
}

