/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.hearth_and_timber.core.block.TimberFrameBlock;
import org.jetbrains.annotations.NotNull;

public class TimberDiagonalFrameBlock
extends TimberFrameBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LEFT = BooleanProperty.create((String)"left");

    public TimberDiagonalFrameBlock(BlockState baseState, BlockBehaviour.Properties properties) {
        super(baseState, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LEFT});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        FluidState fluid = context.getLevel().getFluidState(pos);
        Direction face = context.getClickedFace();
        boolean left = true;
        if (face == Direction.EAST) {
            left = true;
        } else if (face == Direction.WEST) {
            left = false;
        } else if (face == Direction.NORTH) {
            left = context.getClickLocation().x - (double)pos.getX() < 0.5;
        } else if (face == Direction.SOUTH) {
            left = context.getClickLocation().x - (double)pos.getX() > 0.5;
        } else if (face == Direction.UP || face == Direction.DOWN) {
            Direction look = context.getHorizontalDirection();
            double cx = context.getClickLocation().x - (double)pos.getX() - 0.5;
            double cz = context.getClickLocation().z - (double)pos.getZ() - 0.5;
            left = look == Direction.NORTH ? cx < 0.0 : (look == Direction.SOUTH ? cx > 0.0 : (look == Direction.WEST ? cz > 0.0 : cz < 0.0));
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER))).setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(left));
    }

    @Override
    @NotNull
    protected BlockState updateShape(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, dir, neighbor, level, pos, neighborPos);
    }

    @Override
    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return super.getShape(state, level, pos, context);
    }
}

