/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.hearth_and_timber.core.block.PillarBlock;
import net.satisfy.hearth_and_timber.core.block.WoodenBoardBlock;
import net.satisfy.hearth_and_timber.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SupportBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty CONNECTED = BooleanProperty.create((String)"connected");
    public static final BooleanProperty EXTENDED = BooleanProperty.create((String)"extended");
    public static final BooleanProperty REST = BooleanProperty.create((String)"rest");
    public static final BooleanProperty REINFORCED = BooleanProperty.create((String)"reinforced");
    private static final Map<Direction, VoxelShape> SHAPE_SINGLE = (Map)Util.make(new HashMap(), map -> {
        VoxelShape base = Shapes.empty();
        base = Shapes.join((VoxelShape)base, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.875, (double)0.6875, (double)0.625, (double)1.0), (BooleanOp)BooleanOp.OR);
        base = Shapes.join((VoxelShape)base, (VoxelShape)Shapes.box((double)0.3125, (double)0.625, (double)0.0, (double)0.6875, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        for (Direction dir : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(dir, GeneralUtil.rotateShape(Direction.NORTH, dir, base));
        }
    });
    private static final Map<Direction, VoxelShape> SHAPE_CONNECTED = (Map)Util.make(new HashMap(), map -> {
        VoxelShape base = Shapes.box((double)0.3125, (double)0.625, (double)0.0, (double)0.6875, (double)1.0, (double)1.0);
        for (Direction dir : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(dir, GeneralUtil.rotateShape(Direction.NORTH, dir, base));
        }
    });
    private static final Map<Direction, VoxelShape> SHAPE_EXTENDED = (Map)Util.make(new HashMap(), map -> {
        VoxelShape base = Shapes.box((double)0.3125, (double)0.625, (double)0.625, (double)0.6875, (double)1.0, (double)1.0);
        for (Direction dir : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(dir, GeneralUtil.rotateShape(Direction.NORTH, dir, base));
        }
    });
    private static final Map<Direction, VoxelShape> SHAPE_NO_REST = (Map)Util.make(new HashMap(), map -> {
        VoxelShape base = Shapes.box((double)0.3125, (double)0.0, (double)0.875, (double)0.6875, (double)1.0, (double)1.0);
        for (Direction dir : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(dir, GeneralUtil.rotateShape(Direction.NORTH, dir, base));
        }
    });
    private static final Map<Direction, VoxelShape> SHAPE_REINFORCED = (Map)Util.make(new HashMap(), map -> {
        VoxelShape base = Shapes.empty();
        base = Shapes.join((VoxelShape)base, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.875, (double)0.6875, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        base = Shapes.join((VoxelShape)base, (VoxelShape)Shapes.box((double)0.3125, (double)0.625, (double)0.0, (double)0.6875, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        base = Shapes.join((VoxelShape)base, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.0, (double)0.3125, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        base = Shapes.join((VoxelShape)base, (VoxelShape)Shapes.box((double)0.6875, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        for (Direction dir : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(dir, GeneralUtil.rotateShape(Direction.NORTH, dir, base));
        }
    });

    public SupportBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false))).setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false))).setValue((Property)REST, (Comparable)Boolean.valueOf(true))).setValue((Property)REINFORCED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction defaultFacing = context.getHorizontalDirection().getOpposite();
        Direction clickedFace = context.getClickedFace();
        if (!clickedFace.getAxis().isHorizontal()) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)defaultFacing)).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false))).setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false))).setValue((Property)REST, (Comparable)Boolean.valueOf(true))).setValue((Property)REINFORCED, (Comparable)Boolean.valueOf(false));
        }
        BlockPos attachedPos = pos.relative(clickedFace.getOpposite());
        BlockState attached = level.getBlockState(attachedPos);
        boolean attachesToPillar = attached.getBlock() instanceof PillarBlock;
        boolean attachesToSupport = attached.getBlock() instanceof SupportBlock && attached.hasProperty((Property)FACING);
        Direction facing = defaultFacing;
        if (attachesToPillar) {
            facing = clickedFace.getOpposite();
        } else if (attachesToSupport) {
            facing = (Direction)attached.getValue((Property)FACING);
        }
        boolean connected = false;
        if (attachesToPillar) {
            connected = true;
        } else if (attachesToSupport) {
            connected = attached.getValue((Property)FACING) == facing;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(connected))).setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false))).setValue((Property)REST, (Comparable)Boolean.valueOf(true))).setValue((Property)REINFORCED, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CONNECTED, EXTENDED, REST, REINFORCED});
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (((Boolean)state.getValue((Property)EXTENDED)).booleanValue()) {
            return SHAPE_EXTENDED.get(facing);
        }
        if (!((Boolean)state.getValue((Property)REST)).booleanValue()) {
            return SHAPE_NO_REST.get(facing);
        }
        if (((Boolean)state.getValue((Property)REINFORCED)).booleanValue()) {
            return SHAPE_REINFORCED.get(facing);
        }
        return ((Boolean)state.getValue((Property)CONNECTED) != false ? SHAPE_CONNECTED : SHAPE_SINGLE).get(facing);
    }

    private boolean isSameSupportFacing(BlockState state, Direction facing) {
        if (state.getBlock() != this) {
            return false;
        }
        if (!state.hasProperty((Property)FACING)) {
            return false;
        }
        return state.getValue((Property)FACING) == facing;
    }

    private boolean isMiddleOfConnectedRun(Level level, BlockPos pos, Direction facing) {
        BlockState frontState = level.getBlockState(pos.relative(facing));
        BlockState behindState = level.getBlockState(pos.relative(facing.getOpposite()));
        boolean frontOk = this.isSameSupportFacing(frontState, facing) && frontState.hasProperty((Property)CONNECTED) && (Boolean)frontState.getValue((Property)CONNECTED) != false;
        boolean behindOk = this.isSameSupportFacing(behindState, facing) && behindState.hasProperty((Property)CONNECTED) && (Boolean)behindState.getValue((Property)CONNECTED) != false;
        return frontOk && behindOk;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = stack.getItem();
        if (Block.byItem((Item)item) instanceof WoodenBoardBlock) {
            if (((Boolean)state.getValue((Property)EXTENDED)).booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (!level.isClientSide) {
                boolean wasReinforced = (Boolean)state.getValue((Property)REINFORCED);
                boolean newReinforced = !wasReinforced;
                level.setBlock(pos, (BlockState)state.setValue((Property)REINFORCED, (Comparable)Boolean.valueOf(newReinforced)), 3);
                level.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!(item instanceof AxeItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                server.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), (double)pos.getX() + 0.5, (double)pos.getY() + 1.02, (double)pos.getZ() + 0.5, 12, 0.2, 0.0, 0.2, 0.08);
            }
            level.playSound(null, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (((Boolean)state.getValue((Property)CONNECTED)).booleanValue()) {
                Direction facing = (Direction)state.getValue((Property)FACING);
                if (this.isMiddleOfConnectedRun(level, pos, facing)) {
                    return ItemInteractionResult.sidedSuccess((boolean)false);
                }
                boolean newExtended = (Boolean)state.getValue((Property)EXTENDED) == false;
                level.setBlock(pos, (BlockState)state.setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(newExtended)), 3);
            } else {
                boolean newRest = (Boolean)state.getValue((Property)REST) == false;
                level.setBlock(pos, (BlockState)state.setValue((Property)REST, (Comparable)Boolean.valueOf(newRest)), 3);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.support.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

