/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class SplitstoneBlock
extends Block {
    private final Supplier<Block> pathBlock;

    public SplitstoneBlock(BlockBehaviour.Properties properties, Supplier<Block> pathBlock) {
        super(properties);
        this.pathBlock = pathBlock;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.getItem() instanceof PickaxeItem) {
            if (!level.isClientSide) {
                level.levelEvent(player, 2001, pos, Block.getId((BlockState)state));
                level.playSound(null, pos, SoundEvents.DEEPSLATE_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlock(pos, this.pathBlock.get().defaultBlockState(), 3);
            } else {
                RandomSource r = level.getRandom();
                for (int i = 0; i < 12; ++i) {
                    double x = (double)pos.getX() + 0.5 + (r.nextDouble() - 0.5) * 0.4;
                    double y = (double)pos.getY() + 1.02;
                    double z = (double)pos.getZ() + 0.5 + (r.nextDouble() - 0.5) * 0.4;
                    double vx = (r.nextDouble() - 0.5) * 0.08;
                    double vy = 0.25 + r.nextDouble() * 0.25;
                    double vz = (r.nextDouble() - 0.5) * 0.08;
                    level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), x, y, z, vx, vy, vz);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.splitstone.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

