/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.hearth_and_timber.core.block.SupportBlock;
import org.jetbrains.annotations.NotNull;

public class PillarBlock
extends Block {
    public static final BooleanProperty NORTH_CONNECTED = BooleanProperty.create((String)"north_connected");
    public static final BooleanProperty SOUTH_CONNECTED = BooleanProperty.create((String)"south_connected");
    public static final BooleanProperty WEST_CONNECTED = BooleanProperty.create((String)"west_connected");
    public static final BooleanProperty EAST_CONNECTED = BooleanProperty.create((String)"east_connected");
    public static final BooleanProperty EXTENDED_TOP = BooleanProperty.create((String)"extended_top");
    protected static final VoxelShape SHAPE;
    protected static final VoxelShape CONNECT_N;
    protected static final VoxelShape CONNECT_S;
    protected static final VoxelShape CONNECT_W;
    protected static final VoxelShape CONNECT_E;

    public PillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH_CONNECTED, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH_CONNECTED, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST_CONNECTED, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST_CONNECTED, (Comparable)Boolean.valueOf(false))).setValue((Property)EXTENDED_TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{NORTH_CONNECTED, SOUTH_CONNECTED, WEST_CONNECTED, EAST_CONNECTED, EXTENDED_TOP});
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!(stack.getItem() instanceof AxeItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            boolean ext = (Boolean)state.getValue((Property)EXTENDED_TOP);
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                server.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), (double)pos.getX() + 0.5, (double)pos.getY() + 1.02, (double)pos.getZ() + 0.5, 12, 0.2, 0.0, 0.2, 0.08);
            }
            level.playSound(null, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlock(pos, (BlockState)state.setValue((Property)EXTENDED_TOP, (Comparable)Boolean.valueOf(!ext)), 3);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos p = ctx.getClickedPos();
        Level level = ctx.getLevel();
        boolean n = PillarBlock.isSupport(level.getBlockState(p.relative(Direction.NORTH)), Direction.NORTH);
        boolean s = PillarBlock.isSupport(level.getBlockState(p.relative(Direction.SOUTH)), Direction.SOUTH);
        boolean w = PillarBlock.isSupport(level.getBlockState(p.relative(Direction.WEST)), Direction.WEST);
        boolean e = PillarBlock.isSupport(level.getBlockState(p.relative(Direction.EAST)), Direction.EAST);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH_CONNECTED, (Comparable)Boolean.valueOf(n))).setValue((Property)SOUTH_CONNECTED, (Comparable)Boolean.valueOf(s))).setValue((Property)WEST_CONNECTED, (Comparable)Boolean.valueOf(w))).setValue((Property)EAST_CONNECTED, (Comparable)Boolean.valueOf(e));
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction dir, BlockState adj, LevelAccessor level, BlockPos pos, BlockPos pos2) {
        if (dir == Direction.NORTH) {
            return (BlockState)state.setValue((Property)NORTH_CONNECTED, (Comparable)Boolean.valueOf(PillarBlock.isSupport(adj, Direction.NORTH)));
        }
        if (dir == Direction.SOUTH) {
            return (BlockState)state.setValue((Property)SOUTH_CONNECTED, (Comparable)Boolean.valueOf(PillarBlock.isSupport(adj, Direction.SOUTH)));
        }
        if (dir == Direction.WEST) {
            return (BlockState)state.setValue((Property)WEST_CONNECTED, (Comparable)Boolean.valueOf(PillarBlock.isSupport(adj, Direction.WEST)));
        }
        if (dir == Direction.EAST) {
            return (BlockState)state.setValue((Property)EAST_CONNECTED, (Comparable)Boolean.valueOf(PillarBlock.isSupport(adj, Direction.EAST)));
        }
        return state;
    }

    private static boolean isSupport(BlockState state, Direction fromPillarDirection) {
        if (!(state.getBlock() instanceof SupportBlock)) {
            return false;
        }
        if (!state.hasProperty((Property)SupportBlock.FACING)) {
            return false;
        }
        if (!state.hasProperty((Property)SupportBlock.CONNECTED)) {
            return false;
        }
        Direction supportFacing = (Direction)state.getValue((Property)SupportBlock.FACING);
        boolean supportConnected = (Boolean)state.getValue((Property)SupportBlock.CONNECTED);
        if (!supportConnected) {
            return false;
        }
        return supportFacing == fromPillarDirection.getOpposite();
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = SHAPE;
        if (((Boolean)state.getValue((Property)NORTH_CONNECTED)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)CONNECT_N, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)SOUTH_CONNECTED)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)CONNECT_S, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)WEST_CONNECTED)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)CONNECT_W, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)EAST_CONNECTED)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)CONNECT_E, (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    static {
        VoxelShape shape = Shapes.empty();
        SHAPE = shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.OR);
        CONNECT_N = Shapes.box((double)0.3125, (double)0.625, (double)0.0, (double)0.6875, (double)1.0, (double)0.3125);
        CONNECT_S = Shapes.box((double)0.3125, (double)0.625, (double)0.6875, (double)0.6875, (double)1.0, (double)1.0);
        CONNECT_W = Shapes.box((double)0.0, (double)0.625, (double)0.3125, (double)0.3125, (double)1.0, (double)0.6875);
        CONNECT_E = Shapes.box((double)0.625, (double)0.625, (double)0.3125, (double)1.0, (double)1.0, (double)0.6875);
    }
}

