/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.hearth_and_timber.HearthAndTimber;
import net.satisfy.hearth_and_timber.client.renderer.model.SlidingBarnDoorModel;
import net.satisfy.hearth_and_timber.client.renderer.model.SlidingHayloftDoorModel;
import net.satisfy.hearth_and_timber.client.renderer.model.SlidingStableDoorModel;
import net.satisfy.hearth_and_timber.core.block.SlidingBarnDoorBlock;
import net.satisfy.hearth_and_timber.core.block.SlidingHayloftDoorBlock;
import net.satisfy.hearth_and_timber.core.block.SlidingStableDoorBlock;
import net.satisfy.hearth_and_timber.core.block.entity.SlidingDoorBlockEntity;

public class SlidingDoorRenderer
implements BlockEntityRenderer<SlidingDoorBlockEntity> {
    private final SlidingHayloftDoorModel hayloftModel;
    private final SlidingBarnDoorModel barnModel;
    private final SlidingStableDoorModel stableModel;
    private final Map<SlidingDoorBlockEntity, Float> slideCache = new WeakHashMap<SlidingDoorBlockEntity, Float>();

    public SlidingDoorRenderer(BlockEntityRendererProvider.Context context) {
        this.hayloftModel = new SlidingHayloftDoorModel(context.bakeLayer(SlidingHayloftDoorModel.LAYER_LOCATION));
        this.barnModel = new SlidingBarnDoorModel(context.bakeLayer(SlidingBarnDoorModel.LAYER_LOCATION));
        this.stableModel = new SlidingStableDoorModel(context.bakeLayer(SlidingStableDoorModel.LAYER_LOCATION));
    }

    private static boolean isHayloft(BlockState state) {
        return state.getBlock() instanceof SlidingHayloftDoorBlock;
    }

    private static boolean isBarn(BlockState state) {
        return state.getBlock() instanceof SlidingBarnDoorBlock;
    }

    private static boolean isStable(BlockState state) {
        return state.getBlock() instanceof SlidingStableDoorBlock;
    }

    private static boolean isBottomLeft(BlockState state) {
        if (SlidingDoorRenderer.isHayloft(state)) {
            return state.getValue(SlidingHayloftDoorBlock.PART) == SlidingHayloftDoorBlock.Quarter.BL;
        }
        if (SlidingDoorRenderer.isBarn(state)) {
            return state.getValue(SlidingBarnDoorBlock.PART) == SlidingBarnDoorBlock.Quarter.BL;
        }
        if (SlidingDoorRenderer.isStable(state)) {
            return state.getValue(SlidingStableDoorBlock.PART) == SlidingStableDoorBlock.Half.BOTTOM;
        }
        return false;
    }

    private static Direction getFacing(BlockState state) {
        if (SlidingDoorRenderer.isHayloft(state)) {
            return (Direction)state.getValue((Property)SlidingHayloftDoorBlock.FACING);
        }
        if (SlidingDoorRenderer.isStable(state)) {
            return (Direction)state.getValue((Property)SlidingStableDoorBlock.FACING);
        }
        return (Direction)state.getValue((Property)SlidingBarnDoorBlock.FACING);
    }

    private static boolean isRightHinge(BlockState state) {
        if (SlidingDoorRenderer.isHayloft(state)) {
            return state.getValue(SlidingHayloftDoorBlock.HINGE) == SlidingHayloftDoorBlock.HingeSide.RIGHT;
        }
        if (SlidingDoorRenderer.isStable(state)) {
            return state.getValue(SlidingStableDoorBlock.HINGE) == SlidingStableDoorBlock.HingeSide.RIGHT;
        }
        return state.getValue(SlidingBarnDoorBlock.HINGE) == SlidingBarnDoorBlock.HingeSide.RIGHT;
    }

    private ResourceLocation textureFor(SlidingDoorBlockEntity be) {
        String wood = be.getWood();
        if (be.isReinforced()) {
            return HearthAndTimber.identifier("textures/entity/sliding_doors/" + wood + "_reinforced.png");
        }
        return HearthAndTimber.identifier("textures/entity/sliding_doors/" + wood + ".png");
    }

    public void render(SlidingDoorBlockEntity be, float pt, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        BlockState state = be.getBlockState();
        if (!(SlidingDoorRenderer.isHayloft(state) || SlidingDoorRenderer.isBarn(state) || SlidingDoorRenderer.isStable(state))) {
            return;
        }
        if (!SlidingDoorRenderer.isBottomLeft(state)) {
            return;
        }
        poseStack.pushPose();
        Direction facing = SlidingDoorRenderer.getFacing(state);
        boolean right = SlidingDoorRenderer.isRightHinge(state);
        if (SlidingDoorRenderer.isHayloft(state)) {
            block0 : switch (right ? SlidingHayloftDoorBlock.HingeSide.RIGHT : SlidingHayloftDoorBlock.HingeSide.LEFT) {
                case LEFT: {
                    switch (facing) {
                        case EAST: {
                            poseStack.translate(1.3125, 1.5, 0.5);
                            break block0;
                        }
                        case WEST: {
                            poseStack.translate(-0.3125, 1.5, 0.5);
                            break block0;
                        }
                        case NORTH: {
                            poseStack.translate(0.5, 1.5, -0.3125);
                            break block0;
                        }
                        case SOUTH: {
                            poseStack.translate(0.5, 1.5, 1.3125);
                        }
                    }
                    break;
                }
                case RIGHT: {
                    switch (facing) {
                        case EAST: {
                            poseStack.translate(1.3125, 1.5, 1.5);
                            break block0;
                        }
                        case WEST: {
                            poseStack.translate(-0.3125, 1.5, -0.5);
                            break block0;
                        }
                        case NORTH: {
                            poseStack.translate(1.5, 1.5, -0.3125);
                            break block0;
                        }
                        case SOUTH: {
                            poseStack.translate(-0.5, 1.5, 1.3125);
                        }
                    }
                }
            }
        } else if (SlidingDoorRenderer.isBarn(state)) {
            block16 : switch (right ? SlidingBarnDoorBlock.HingeSide.RIGHT : SlidingBarnDoorBlock.HingeSide.LEFT) {
                case LEFT: {
                    switch (facing) {
                        case EAST: {
                            poseStack.translate(1.375, 1.5, 0.5);
                            break block16;
                        }
                        case WEST: {
                            poseStack.translate(-0.375, 1.5, 0.5);
                            break block16;
                        }
                        case NORTH: {
                            poseStack.translate(0.5, 1.5, -0.375);
                            break block16;
                        }
                        case SOUTH: {
                            poseStack.translate(0.5, 1.5, 1.375);
                        }
                    }
                    break;
                }
                case RIGHT: {
                    switch (facing) {
                        case EAST: {
                            poseStack.translate(1.375, 1.5, 1.5);
                            break block16;
                        }
                        case WEST: {
                            poseStack.translate(-0.375, 1.5, -0.5);
                            break block16;
                        }
                        case NORTH: {
                            poseStack.translate(1.5, 1.5, -0.375);
                            break block16;
                        }
                        case SOUTH: {
                            poseStack.translate(-0.5, 1.5, 1.375);
                        }
                    }
                }
            }
        } else {
            block32 : switch (right ? SlidingStableDoorBlock.HingeSide.RIGHT : SlidingStableDoorBlock.HingeSide.LEFT) {
                case LEFT: {
                    switch (facing) {
                        case EAST: {
                            poseStack.translate(1.3125, 1.5, 0.5);
                            break;
                        }
                        case WEST: {
                            poseStack.translate(-0.3125, 1.5, 0.5);
                            break;
                        }
                        case NORTH: {
                            poseStack.translate(0.5, 1.5, -0.3125);
                            break;
                        }
                        case SOUTH: {
                            poseStack.translate(0.5, 1.5, 1.3125);
                        }
                    }
                    break;
                }
                case RIGHT: {
                    switch (facing) {
                        case EAST: {
                            poseStack.translate(1.3125, 1.5, 1.5);
                            break block32;
                        }
                        case WEST: {
                            poseStack.translate(-0.3125, 1.5, -0.5);
                            break block32;
                        }
                        case NORTH: {
                            poseStack.translate(1.5, 1.5, -0.3125);
                            break block32;
                        }
                        case SOUTH: {
                            poseStack.translate(-0.5, 1.5, 1.3125);
                        }
                    }
                }
            }
        }
        float max = SlidingDoorRenderer.isStable(state) ? 0.8125f : 1.625f;
        float rawSlide = be.getSlide();
        float previous = this.slideCache.getOrDefault((Object)be, Float.valueOf(rawSlide)).floatValue();
        float smoothed = previous + (rawSlide - previous) * 0.35f;
        this.slideCache.put(be, Float.valueOf(smoothed));
        float distance = smoothed * max;
        Direction lateral = right ? facing.getClockWise() : facing.getCounterClockWise();
        double offsetX = 0.0;
        double offsetZ = 0.0;
        switch (lateral) {
            case NORTH: {
                offsetZ -= (double)distance;
                break;
            }
            case SOUTH: {
                offsetZ += (double)distance;
                break;
            }
            case WEST: {
                offsetX -= (double)distance;
                break;
            }
            case EAST: {
                offsetX += (double)distance;
            }
        }
        double forwardOffset = 0.0625 * (double)distance;
        switch (facing) {
            case NORTH: {
                offsetZ -= forwardOffset;
                break;
            }
            case SOUTH: {
                offsetZ += forwardOffset;
                break;
            }
            case WEST: {
                offsetX -= forwardOffset;
                break;
            }
            case EAST: {
                offsetX += forwardOffset;
            }
        }
        poseStack.translate(offsetX, 0.0, offsetZ);
        poseStack.mulPose(Axis.YN.rotationDegrees(facing.toYRot()));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        if (right) {
            poseStack.translate(1.0, 0.0, 0.0);
            poseStack.scale(-1.0f, 1.0f, 1.0f);
        }
        if (SlidingDoorRenderer.isBarn(state)) {
            VertexConsumer vc = buffers.getBuffer(this.barnModel.renderType(this.textureFor(be)));
            this.barnModel.renderToBuffer(poseStack, vc, packedLight, OverlayTexture.NO_OVERLAY, -1);
        } else if (SlidingDoorRenderer.isHayloft(state)) {
            VertexConsumer vc = buffers.getBuffer(this.hayloftModel.renderType(this.textureFor(be)));
            this.hayloftModel.renderToBuffer(poseStack, vc, packedLight, OverlayTexture.NO_OVERLAY, -1);
        } else {
            VertexConsumer vc = buffers.getBuffer(this.stableModel.renderType(this.textureFor(be)));
            this.stableModel.renderToBuffer(poseStack, vc, packedLight, OverlayTexture.NO_OVERLAY, -1);
        }
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(SlidingDoorBlockEntity be) {
        return true;
    }
}

