/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.util.styled;

import com.google.common.base.Preconditions;
import de.lucalabs.fairylights.util.styled.Style;
import de.lucalabs.fairylights.util.styled.StyledStringBuilder;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public final class StyledString
implements Comparable<StyledString>,
CharSequence {
    private final String value;
    private final Style[] styling;
    private int hash;

    public StyledString() {
        this("", new Style());
    }

    public StyledString(String value, Style style) {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(style, "style");
        this.value = value;
        this.styling = new Style[value.length()];
        Arrays.fill(this.styling, style);
    }

    public StyledString(String value, Style[] styling) {
        this.value = value;
        this.styling = Objects.requireNonNull(styling, "styling");
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    public Style styleAt(int index) {
        return this.styling[index];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.value.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
        return this.value.getBytes(charsetName);
    }

    public byte[] getBytes(Charset charset) {
        return this.value.getBytes(charset);
    }

    public byte[] getBytes() {
        return this.value.getBytes();
    }

    public Style[] getStyling() {
        return (Style[])this.styling.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StyledString) {
            StyledString other = (StyledString)obj;
            return this.value.equals(other.value) && Arrays.equals(this.styling, other.styling);
        }
        return false;
    }

    public boolean contentEquals(StringBuffer sb) {
        return this.value.contentEquals(sb);
    }

    public boolean contentEquals(CharSequence cs) {
        return this.value.contentEquals(cs);
    }

    public boolean equalsIgnoreCase(StyledString anotherString) {
        return this.equalsIgnoreCase(anotherString.value);
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return this.value.equalsIgnoreCase(anotherString);
    }

    @Override
    public int compareTo(StyledString anotherString) {
        int len1 = this.value.length();
        int len2 = anotherString.value.length();
        int lim = Math.min(len1, len2);
        char[] v1 = this.toCharArray();
        char[] v2 = anotherString.toCharArray();
        for (int k = 0; k < lim; ++k) {
            char c1 = v1[k];
            char c2 = v2[k];
            if (c1 != c2) {
                return c1 - c2;
            }
            Style s1 = this.styling[k];
            Style s2 = anotherString.styling[k];
            int c = s1.compareTo(s2);
            if (c == 0) continue;
            return c;
        }
        return len1 - len2;
    }

    public int compareToIgnoreCase(StyledString anotherString) {
        int len1 = this.value.length();
        int len2 = anotherString.value.length();
        int lim = Math.min(len1, len2);
        char[] v1 = this.toCharArray();
        char[] v2 = anotherString.toCharArray();
        for (int k = 0; k < lim; ++k) {
            char c1 = v1[k];
            char c2 = v2[k];
            if (c1 != c2 && (c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                return c1 - c2;
            }
            Style s1 = this.styling[k];
            Style s2 = anotherString.styling[k];
            int c = s1.compareTo(s2);
            if (c == 0) continue;
            return c;
        }
        return len1 - len2;
    }

    public int compareToIgnoreCase(String anotherString) {
        return this.value.compareToIgnoreCase(anotherString);
    }

    public boolean regionMatches(int tOffset, StyledString other, int oOffset, int len) {
        return this.regionMatches(tOffset, other.value, oOffset, len);
    }

    public boolean regionMatches(int tOffset, String other, int oOffset, int len) {
        return this.value.regionMatches(tOffset, other, oOffset, len);
    }

    public boolean regionMatches(boolean ignoreCase, int tOffset, StyledString other, int oOffset, int len) {
        return this.regionMatches(ignoreCase, tOffset, other.value, oOffset, len);
    }

    public boolean regionMatches(boolean ignoreCase, int tOffset, String other, int oOffset, int len) {
        return this.value.regionMatches(ignoreCase, tOffset, other, oOffset, len);
    }

    public boolean startsWith(StyledString prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(StyledString prefix, int tOffset) {
        char[] ta = this.toCharArray();
        char[] pa = prefix.toCharArray();
        int to = tOffset;
        int po = 0;
        int pc = prefix.value.length();
        if (tOffset < 0 || tOffset > this.value.length() - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (ta[to] == pa[po] && this.styling[to++].equals(prefix.styling[po++])) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(String prefix, int tOffset) {
        return this.value.startsWith(prefix, tOffset);
    }

    public boolean endsWith(StyledString suffix) {
        return this.startsWith(suffix, this.length() - suffix.length());
    }

    public boolean endsWith(String suffix) {
        return this.value.endsWith(suffix);
    }

    public int hashCode() {
        if (this.hash == 0 && this.length() > 0) {
            this.hash = 31 * this.value.hashCode() + Arrays.hashCode(this.styling);
        }
        return this.hash;
    }

    public int indexOf(char chr) {
        return this.value.indexOf(chr);
    }

    public int indexOf(char chr, int fromIndex) {
        return this.value.indexOf(chr, fromIndex);
    }

    public int indexOf(char chr, Style style) {
        return this.indexOf(chr, 0, style);
    }

    public int indexOf(char chr, int fromIndex, Style style) {
        int max = this.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= max) {
            return -1;
        }
        char[] value = this.toCharArray();
        for (int i = fromIndex; i < max; ++i) {
            if (value[i] != chr || !this.styling[i].equals(style)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char chr) {
        return this.value.lastIndexOf(chr);
    }

    public int lastIndexOf(char chr, int fromIndex) {
        return this.value.lastIndexOf(chr, fromIndex);
    }

    public int lastIndexOf(char chr, Style style) {
        return this.lastIndexOf(chr, this.length() - 1, style);
    }

    public int lastIndexOf(char chr, int fromIndex, Style style) {
        char[] value = this.toCharArray();
        for (int i = Math.min(fromIndex, this.length() - 1); i >= 0; --i) {
            if (value[i] != chr || !this.styling[i].equals(style)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String str) {
        return this.value.indexOf(str);
    }

    public int indexOf(String str, int fromIndex) {
        return this.value.indexOf(str, fromIndex);
    }

    public int indexOf(StyledString str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(StyledString str, int fromIndex) {
        char[] source = this.toCharArray();
        Style[] sourceStyling = this.styling;
        char[] target = str.toCharArray();
        Style[] targetStyling = str.styling;
        int sourceCount = this.length();
        int targetCount = str.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[0];
        Style firstStyling = targetStyling[0];
        int max = fromIndex + sourceCount - targetCount;
        for (int i = fromIndex + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (!(++i > max || source[i] == first && sourceStyling[i].equals(firstStyling))) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && source[j] == target[k] && sourceStyling[j].equals(targetStyling[k])) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - fromIndex;
        }
        return -1;
    }

    public int lastIndexOf(String str) {
        return this.value.lastIndexOf(str);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return this.value.lastIndexOf(str, fromIndex);
    }

    public int lastIndexOf(StyledString str) {
        return this.lastIndexOf(str, this.length());
    }

    public int lastIndexOf(StyledString str, int fromIndex) {
        int start;
        char[] source = this.toCharArray();
        Style[] sourceStyling = this.styling;
        char[] target = str.toCharArray();
        Style[] targetStyling = str.styling;
        int sourceCount = this.length();
        int targetCount = str.length();
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetCount - 1;
        char strLastChar = target[strLastIndex];
        Style strLastStyling = targetStyling[strLastIndex];
        int min = fromIndex + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (!(i < min || source[i] == strLastChar && sourceStyling[i].equals(strLastStyling))) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                boolean isDifferent = source[j] != target[k] || !sourceStyling[j].equals(targetStyling[k]);
                --j;
                --k;
                if (!isDifferent) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - fromIndex + 1;
    }

    public StyledString substring(int beginIndex) {
        return this.substring(beginIndex, this.length());
    }

    public StyledString substring(int beginIndex, int endIndex) {
        String value = this.value.substring(beginIndex, endIndex);
        Style[] styling = new Style[endIndex - beginIndex];
        System.arraycopy(this.styling, beginIndex, styling, 0, styling.length);
        return new StyledString(value, styling);
    }

    @Override
    @NotNull
    public StyledString subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public StyledString concat(StyledString str) {
        if (str.value.isEmpty()) {
            return this;
        }
        String value = this.value.concat(str.value);
        Style[] styling = new Style[this.styling.length + str.styling.length];
        System.arraycopy(this.styling, 0, styling, 0, this.styling.length);
        System.arraycopy(str.styling, 0, styling, this.styling.length, str.styling.length);
        return new StyledString(value, styling);
    }

    public StyledString replace(char oldChar, char newChar) {
        return new StyledString(this.value.replace(oldChar, newChar), this.styling);
    }

    public boolean matches(String regex) {
        return Pattern.matches(regex, this);
    }

    public boolean contains(CharSequence s) {
        return this.indexOf(s.toString()) > -1;
    }

    public boolean contains(StyledString s) {
        return this.indexOf(s) > -1;
    }

    public StyledString toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public StyledString toLowerCase(Locale locale) {
        String value = this.value.toLowerCase(locale);
        if (value.length() != this.length()) {
            throw new UnsupportedOperationException("Characters with surrogate pairs not supported");
        }
        return new StyledString(value, this.styling);
    }

    public StyledString toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public StyledString toUpperCase(Locale locale) {
        String value = this.value.toUpperCase(locale);
        if (value.length() != this.length()) {
            throw new UnsupportedOperationException("Characters with surrogate pairs not supported");
        }
        return new StyledString(value, this.styling);
    }

    public StyledString trim() {
        int st;
        String val = this.value;
        int len = val.length();
        for (st = 0; st < len && val.charAt(st) <= ' '; ++st) {
        }
        while (st < len && val.charAt(len - 1) <= ' ') {
            --len;
        }
        return st > 0 || len < this.value.length() ? this.substring(st, len) : this;
    }

    public StyledString withStyling(Style style) {
        return this.withStyling(0, this.length(), style);
    }

    public StyledString withStyling(int beginIndex, int endIndex, Style style) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.length()) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        int subLen = endIndex - beginIndex;
        if (subLen < 0) {
            throw new StringIndexOutOfBoundsException(subLen);
        }
        String value = this.value;
        Style[] styling = this.styling;
        Object[] newStyling = new Style[styling.length];
        System.arraycopy(styling, 0, newStyling, 0, beginIndex);
        System.arraycopy(styling, endIndex, newStyling, endIndex, styling.length - endIndex);
        Arrays.fill(newStyling, beginIndex, endIndex, style);
        return new StyledString(value, (Style[])newStyling);
    }

    public StyledString withStyling(class_124 formatting, boolean state) {
        return this.withStyling(0, this.length(), formatting, state);
    }

    public StyledString withStyling(int beginIndex, int endIndex, class_124 formatting, boolean state) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.length()) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        int subLen = endIndex - beginIndex;
        if (subLen < 0) {
            throw new StringIndexOutOfBoundsException(subLen);
        }
        String value = this.value;
        Style[] styling = this.styling;
        Style[] newStyling = new Style[styling.length];
        System.arraycopy(styling, 0, newStyling, 0, beginIndex);
        System.arraycopy(styling, endIndex, newStyling, endIndex, styling.length - endIndex);
        for (int i = beginIndex; i < endIndex; ++i) {
            newStyling[i] = styling[i].withStyling(formatting, state);
        }
        return new StyledString(value, newStyling);
    }

    @Override
    @NotNull
    public String toString() {
        return this.value;
    }

    public class_2561 toTextText() {
        String value = this.value;
        if (value.isEmpty()) {
            return class_2561.method_43473();
        }
        class_5250 text = null;
        Style[] styling = this.styling;
        StringBuilder bob = new StringBuilder();
        Style currentStyle = styling[0];
        int i = 0;
        while (true) {
            Style style;
            Style style2 = style = i < value.length() ? styling[i] : null;
            if (!currentStyle.equals(style)) {
                class_5250 t = class_2561.method_43470((String)bob.toString());
                t.method_27692(currentStyle.getColor());
                if (currentStyle.isObfuscated()) {
                    t.method_27692(class_124.field_1051);
                }
                if (currentStyle.isBold()) {
                    t.method_27692(class_124.field_1067);
                }
                if (currentStyle.isStrikethrough()) {
                    t.method_27692(class_124.field_1055);
                }
                if (currentStyle.isUnderline()) {
                    t.method_27692(class_124.field_1073);
                }
                if (currentStyle.isItalic()) {
                    t.method_27692(class_124.field_1056);
                }
                if (text == null) {
                    text = t;
                } else {
                    text.method_10852((class_2561)t);
                }
                bob.setLength(0);
            }
            currentStyle = style;
            if (i >= value.length()) break;
            bob.appendCodePoint(value.charAt(i++));
        }
        return text;
    }

    public String toUnstyledString() {
        return this.value;
    }

    public char[] toCharArray() {
        return this.value.toCharArray();
    }

    public static class_2487 serialize(StyledString str) {
        class_2487 compound = new class_2487();
        compound.method_10582("value", str.value);
        compound.method_10539("styling", Arrays.stream(str.styling).mapToInt(Style::packed).toArray());
        return compound;
    }

    public static StyledString deserialize(class_2487 compound) {
        String value = compound.method_10558("value");
        Style[] styling = (Style[])Arrays.stream(compound.method_10561("styling")).mapToObj(Style::new).toArray(Style[]::new);
        if (styling.length != value.length()) {
            styling = (Style[])Arrays.stream(Arrays.copyOf(styling, value.length())).map(s -> Optional.ofNullable(s).orElseGet(Style::new)).toArray(Style[]::new);
        }
        return new StyledString(value, styling);
    }

    public static StyledString valueOf(String str) {
        Style plainStyle;
        StyledStringBuilder builder = new StyledStringBuilder(str.length());
        Style style = plainStyle = new Style();
        char[] chars = str.toCharArray();
        boolean hasFToken = false;
        for (char chr : chars) {
            if (chr == '\u00a7') {
                hasFToken = true;
                continue;
            }
            if (hasFToken) {
                char ch = Character.toLowerCase(chr);
                int colorIndex = "0123456789abcdef".indexOf(ch);
                if (colorIndex != -1) {
                    class_124 color = class_124.method_534((int)colorIndex);
                    if (color != null) {
                        style = style.withColor(color);
                    }
                } else if (ch == 'k') {
                    style = style.withObfuscated(true);
                } else if (ch == 'l') {
                    style = style.withBold(true);
                } else if (ch == 'm') {
                    style = style.withStrikethrough(true);
                } else if (ch == 'n') {
                    style = style.withUnderline(true);
                } else if (ch == 'o') {
                    style = style.withItalic(true);
                } else if (ch == 'r') {
                    style = plainStyle;
                } else {
                    builder.append(chr);
                }
                builder.setStyle(style);
                hasFToken = false;
                continue;
            }
            builder.append(chr);
        }
        return builder.toStyledString();
    }

    public static int getColor(class_124 color) {
        Integer rgb = color.method_532();
        Preconditions.checkNotNull((Object)rgb, (Object)"Must be a color");
        return rgb;
    }
}

