/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.util;

import de.lucalabs.fairylights.util.Curve;
import net.minecraft.class_3532;

public final class Curve3D
implements Curve {
    private final int count;
    private final float[] x;
    private final float[] y;
    private final float[] z;
    private final float length;

    public Curve3D(int count, float[] x, float[] y, float[] z, float length) {
        this.count = count;
        this.x = x;
        this.y = y;
        this.z = z;
        this.length = length;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public float getX() {
        return this.x[this.count - 1];
    }

    @Override
    public float getY() {
        return this.y[this.count - 1];
    }

    @Override
    public float getZ() {
        return this.z[this.count - 1];
    }

    @Override
    public float getX(int i) {
        return this.x[i];
    }

    @Override
    public float getX(int i, float lerp) {
        return class_3532.method_16439((float)lerp, (float)this.x[i], (float)this.x[i + 1]);
    }

    @Override
    public float getY(int i) {
        return this.y[i];
    }

    @Override
    public float getY(int i, float lerp) {
        return class_3532.method_16439((float)lerp, (float)this.y[i], (float)this.y[i + 1]);
    }

    @Override
    public float getZ(int i) {
        return this.z[i];
    }

    @Override
    public float getZ(int i, float lerp) {
        return class_3532.method_16439((float)lerp, (float)this.z[i], (float)this.z[i + 1]);
    }

    @Override
    public float getDx(int i) {
        return this.x[i + 1] - this.x[i];
    }

    @Override
    public float getDy(int i) {
        return this.y[i + 1] - this.y[i];
    }

    @Override
    public float getDz(int i) {
        return this.z[i + 1] - this.z[i];
    }

    @Override
    public float getLength() {
        return this.length;
    }

    @Override
    public Curve lerp(Curve other, float delta) {
        return other;
    }

    @Override
    public Curve.SegmentIterator iterator(boolean inclusive) {
        return new Curve.CurveSegmentIterator<Curve3D>(this, this, inclusive){

            @Override
            public float getYaw() {
                this.checkIndex(1.0f);
                if (this.inclusive) {
                    throw new IllegalStateException();
                }
                float dx = ((Curve3D)this.curve).x[this.index + 1] - ((Curve3D)this.curve).x[this.index];
                float dz = ((Curve3D)this.curve).z[this.index + 1] - ((Curve3D)this.curve).z[this.index];
                return (float)class_3532.method_15349((double)dz, (double)dx);
            }

            @Override
            protected float getPitch(int index) {
                float dx = ((Curve3D)this.curve).x[index + 1] - ((Curve3D)this.curve).x[index];
                float dy = ((Curve3D)this.curve).y[index + 1] - ((Curve3D)this.curve).y[index];
                float dz = ((Curve3D)this.curve).z[index + 1] - ((Curve3D)this.curve).z[index];
                return (float)class_3532.method_15349((double)dy, (double)class_3532.method_15355((float)(dx * dx + dz * dz)));
            }

            @Override
            public float getLength(int index) {
                float dx = ((Curve3D)this.curve).x[index + 1] - ((Curve3D)this.curve).x[index];
                float dy = ((Curve3D)this.curve).y[index + 1] - ((Curve3D)this.curve).y[index];
                float dz = ((Curve3D)this.curve).z[index + 1] - ((Curve3D)this.curve).z[index];
                return class_3532.method_15355((float)(dx * dx + dy * dy + dz * dz));
            }
        };
    }
}

