/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.renderer.block.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.lucalabs.fairylights.connection.PennantBuntingConnection;
import de.lucalabs.fairylights.feature.Pennant;
import de.lucalabs.fairylights.items.FairyLightItems;
import de.lucalabs.fairylights.renderer.FairyLightModelLayers;
import de.lucalabs.fairylights.renderer.block.entity.ConnectionRenderer;
import de.lucalabs.fairylights.renderer.block.entity.FastenerRenderer;
import de.lucalabs.fairylights.util.Curve;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_630;
import net.minecraft.class_7833;

@Environment(value=EnvType.CLIENT)
public class PennantBuntingRenderer
extends ConnectionRenderer<PennantBuntingConnection> {
    private static final class_2960 TRIANGLE_MODEL = class_2960.method_60655((String)"fairylights", (String)"entity/triangle_pennant");
    private static final class_2960 SQUARE_MODEL = class_2960.method_60655((String)"fairylights", (String)"entity/square_pennant");
    public static final ImmutableSet<class_2960> MODELS = ImmutableSet.of((Object)TRIANGLE_MODEL, (Object)SQUARE_MODEL);
    private final ImmutableMap<class_1792, class_2960> models = ImmutableMap.of((Object)FairyLightItems.TRIANGLE_PENNANT, (Object)TRIANGLE_MODEL, (Object)FairyLightItems.SQUARE_PENNANT, (Object)SQUARE_MODEL);

    public PennantBuntingRenderer(Function<class_5601, class_630> baker) {
        super(baker, FairyLightModelLayers.PENNANT_WIRE, 0.25f);
    }

    @Override
    protected void render(PennantBuntingConnection conn, Curve catenary, float delta, class_4587 matrix, class_4597 source, int packedLight, int packedOverlay) {
        super.render(conn, catenary, delta, matrix, source, packedLight, packedOverlay);
        Pennant[] currLights = (Pennant[])conn.getFeatures();
        if (currLights != null) {
            class_4588 buf = source.getBuffer(class_4722.method_24074());
            int count = currLights.length;
            if (count == 0) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                Pennant currPennant = currLights[i];
                int color = currPennant.getColor();
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                class_1087 model = class_310.method_1551().method_1554().getModel((class_2960)this.models.getOrDefault((Object)currPennant.getItem(), (Object)TRIANGLE_MODEL));
                class_243 pos = currPennant.getPoint(delta);
                matrix.method_22903();
                matrix.method_22904(pos.field_1352, pos.field_1351, pos.field_1350);
                matrix.method_22907(class_7833.field_40716.rotation(-currPennant.getYaw(delta)));
                matrix.method_22907(class_7833.field_40718.rotation(currPennant.getPitch(delta)));
                matrix.method_22907(class_7833.field_40714.rotation(currPennant.getRoll(delta)));
                matrix.method_22903();
                FastenerRenderer.renderBakedModel(model, matrix, buf, r, g, b, packedLight, packedOverlay);
                matrix.method_22909();
                matrix.method_22909();
            }
        }
    }

    public static float diffuseLight(float p_144949_, float p_144950_, float p_144951_) {
        return Math.min(p_144949_ * p_144949_ * 0.6f + p_144950_ * p_144950_ * ((3.0f + p_144950_) / 4.0f) + p_144951_ * p_144951_ * 0.8f, 1.0f);
    }

    public static class_5607 wireLayer() {
        return ConnectionRenderer.WireModel.createLayer(0, 17, 1);
    }
}

