/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.renderer.block.entity;

import com.google.common.collect.ImmutableMap;
import de.lucalabs.fairylights.feature.light.Light;
import de.lucalabs.fairylights.feature.light.LightBehavior;
import de.lucalabs.fairylights.items.LightVariant;
import de.lucalabs.fairylights.items.SimpleLightVariant;
import de.lucalabs.fairylights.model.light.CandleLanternModel;
import de.lucalabs.fairylights.model.light.ColorCandleLanternModel;
import de.lucalabs.fairylights.model.light.FairyLightModel;
import de.lucalabs.fairylights.model.light.FlowerLightModel;
import de.lucalabs.fairylights.model.light.GhostLightModel;
import de.lucalabs.fairylights.model.light.HeartLightModel;
import de.lucalabs.fairylights.model.light.IcicleLightsModel;
import de.lucalabs.fairylights.model.light.IncandescentLightModel;
import de.lucalabs.fairylights.model.light.JackOLanternLightModel;
import de.lucalabs.fairylights.model.light.LightModel;
import de.lucalabs.fairylights.model.light.MeteorLightModel;
import de.lucalabs.fairylights.model.light.MoonLightModel;
import de.lucalabs.fairylights.model.light.OilLanternModel;
import de.lucalabs.fairylights.model.light.OrbLanternModel;
import de.lucalabs.fairylights.model.light.PaperLanternModel;
import de.lucalabs.fairylights.model.light.SkullLightModel;
import de.lucalabs.fairylights.model.light.SnowflakeLightModel;
import de.lucalabs.fairylights.model.light.SpiderLightModel;
import de.lucalabs.fairylights.model.light.StarLightModel;
import de.lucalabs.fairylights.model.light.WitchLightModel;
import de.lucalabs.fairylights.renderer.FairyLightModelLayers;
import de.lucalabs.fairylights.renderer.RenderConstants;
import de.lucalabs.fairylights.renderer.block.entity.ForwardingVertexConsumer;
import de.lucalabs.fairylights.util.ColorUtils;
import de.lucalabs.fairylights.util.MathHelper;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5601;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public class LightRenderer {
    private final LightModelProvider<LightBehavior> defaultLight = LightModelProvider.of(new DefaultModel());
    private final Map<LightVariant<?>, LightModelProvider<?>> lights;

    public LightRenderer(Function<class_5601, class_630> baker) {
        this.lights = new ImmutableMap.Builder().put(SimpleLightVariant.FAIRY_LIGHT, LightModelProvider.of(new FairyLightModel(baker.apply(FairyLightModelLayers.FAIRY_LIGHT)))).put(SimpleLightVariant.INCANDESCENT_LIGHT, LightModelProvider.of(new IncandescentLightModel(baker.apply(FairyLightModelLayers.INCANDESCENT_LIGHT)))).put(SimpleLightVariant.PAPER_LANTERN, LightModelProvider.of(new PaperLanternModel(baker.apply(FairyLightModelLayers.PAPER_LANTERN)))).put(SimpleLightVariant.ORB_LANTERN, LightModelProvider.of(new OrbLanternModel(baker.apply(FairyLightModelLayers.ORB_LANTERN)))).put(SimpleLightVariant.FLOWER_LIGHT, LightModelProvider.of(new FlowerLightModel(baker.apply(FairyLightModelLayers.FLOWER_LIGHT)))).put(SimpleLightVariant.CANDLE_LANTERN_LIGHT, LightModelProvider.of(new ColorCandleLanternModel(baker.apply(FairyLightModelLayers.CANDLE_LANTERN_LIGHT)))).put(SimpleLightVariant.JACK_O_LANTERN, LightModelProvider.of(new JackOLanternLightModel(baker.apply(FairyLightModelLayers.JACK_O_LANTERN)))).put(SimpleLightVariant.SKULL_LIGHT, LightModelProvider.of(new SkullLightModel(baker.apply(FairyLightModelLayers.SKULL_LIGHT)))).put(SimpleLightVariant.GHOST_LIGHT, LightModelProvider.of(new GhostLightModel(baker.apply(FairyLightModelLayers.GHOST_LIGHT)))).put(SimpleLightVariant.SPIDER_LIGHT, LightModelProvider.of(new SpiderLightModel(baker.apply(FairyLightModelLayers.SPIDER_LIGHT)))).put(SimpleLightVariant.WITCH_LIGHT, LightModelProvider.of(new WitchLightModel(baker.apply(FairyLightModelLayers.WITCH_LIGHT)))).put(SimpleLightVariant.SNOWFLAKE_LIGHT, LightModelProvider.of(new SnowflakeLightModel(baker.apply(FairyLightModelLayers.SNOWFLAKE_LIGHT)))).put(SimpleLightVariant.HEART_LIGHT, LightModelProvider.of(new HeartLightModel(baker.apply(FairyLightModelLayers.HEART_LIGHT)))).put(SimpleLightVariant.MOON_LIGHT, LightModelProvider.of(new MoonLightModel(baker.apply(FairyLightModelLayers.MOON_LIGHT)))).put(SimpleLightVariant.STAR_LIGHT, LightModelProvider.of(new StarLightModel(baker.apply(FairyLightModelLayers.STAR_LIGHT)))).put(SimpleLightVariant.ICICLE_LIGHTS, LightModelProvider.of(new IcicleLightsModel[]{new IcicleLightsModel(baker.apply(FairyLightModelLayers.ICICLE_LIGHTS_1), 1), new IcicleLightsModel(baker.apply(FairyLightModelLayers.ICICLE_LIGHTS_2), 2), new IcicleLightsModel(baker.apply(FairyLightModelLayers.ICICLE_LIGHTS_3), 3), new IcicleLightsModel(baker.apply(FairyLightModelLayers.ICICLE_LIGHTS_4), 4)}, (models, i) -> models[i < 0 ? 3 : MathHelper.mod(MathHelper.hash(i), 4)])).put(SimpleLightVariant.METEOR_LIGHT, LightModelProvider.of(new MeteorLightModel(baker.apply(FairyLightModelLayers.METEOR_LIGHT)))).put(SimpleLightVariant.OIL_LANTERN, LightModelProvider.of(new OilLanternModel(baker.apply(FairyLightModelLayers.OIL_LANTERN)))).put(SimpleLightVariant.CANDLE_LANTERN, LightModelProvider.of(new CandleLanternModel(baker.apply(FairyLightModelLayers.CANDLE_LANTERN)))).build();
    }

    public Data start(class_4597 source) {
        final class_4588 buf = RenderConstants.TRANSLUCENT_TEXTURE.method_24145(source, class_1921::method_23580);
        ForwardingVertexConsumer translucent = new ForwardingVertexConsumer(this){

            @Override
            protected class_4588 delegate() {
                return buf;
            }

            @Override
            public class_4588 method_22914(float x, float y, float z) {
                return super.method_22914(0.0f, 1.0f, 0.0f);
            }
        };
        return new Data(buf, translucent);
    }

    public <T extends LightBehavior> LightModel<T> getModel(Light<?> light, int index) {
        return this.getModel(light.getVariant(), index);
    }

    public <T extends LightBehavior> LightModel<T> getModel(LightVariant<?> variant, int index) {
        return this.lights.getOrDefault(variant, this.defaultLight).get(index);
    }

    public void render(class_4587 matrix, Data data, Light<?> light, int index, float delta, int packedLight, int packedOverlay) {
        this.render(matrix, data, light, this.getModel(light, index), delta, packedLight, packedOverlay);
    }

    public <T extends LightBehavior> void render(class_4587 matrix, Data data, Light<T> light, LightModel<T> model, float delta, int packedLight, int packedOverlay) {
        model.animate(light, light.getBehavior(), delta);
        model.method_2828(matrix, data.solid, packedLight, packedOverlay, ColorUtils.WHITE);
        model.renderTranslucent(matrix, data.translucent, packedLight, packedOverlay, ColorUtils.WHITE);
    }

    @Environment(value=EnvType.CLIENT)
    static class DefaultModel
    extends LightModel<LightBehavior> {
        private static final class_630 EMPTY = new class_630(List.of(), Map.of());

        public DefaultModel() {
            super(new class_630(List.of(), Map.of("lit", EMPTY, "lit_tint", EMPTY, "lit_tint_glow", EMPTY, "unlit", EMPTY)));
        }

        @Override
        public void method_2828(class_4587 matrix, class_4588 builder, int light, int overlay, int color) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    static interface LightModelProvider<T extends LightBehavior> {
        public static <T extends LightBehavior> LightModelProvider<T> of(LightModel<T> model) {
            return i -> model;
        }

        public static <T extends LightBehavior> LightModelProvider<T> of(Supplier<LightModel<T>> model) {
            return i -> (LightModel)((Object)((Object)model.get()));
        }

        public static <T extends LightBehavior, D> LightModelProvider<T> of(D data, BiFunction<? super D, Integer, LightModel<T>> function) {
            return i -> (LightModel)((Object)((Object)function.apply((Object)data, i)));
        }

        public LightModel<T> get(int var1);
    }

    @Environment(value=EnvType.CLIENT)
    public record Data(class_4588 solid, class_4588 translucent) {
    }
}

