/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.renderer.block.entity;

import de.lucalabs.fairylights.connection.GarlandVineConnection;
import de.lucalabs.fairylights.renderer.FairyLightModelLayers;
import de.lucalabs.fairylights.renderer.RenderConstants;
import de.lucalabs.fairylights.renderer.block.entity.ConnectionRenderer;
import de.lucalabs.fairylights.util.Curve;
import de.lucalabs.fairylights.util.RandomArray;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_630;
import net.minecraft.class_7833;

@Environment(value=EnvType.CLIENT)
public class GarlandVineRenderer
extends ConnectionRenderer<GarlandVineConnection> {
    private static final int RING_COUNT = 7;
    private static final RandomArray RAND = new RandomArray(8411L, 28);
    private final RingsModel rings;

    protected GarlandVineRenderer(Function<class_5601, class_630> baker) {
        super(baker, FairyLightModelLayers.VINE_WIRE);
        this.rings = new RingsModel(baker.apply(FairyLightModelLayers.GARLAND_RINGS));
    }

    @Override
    protected void render(GarlandVineConnection conn, Curve catenary, float delta, class_4587 matrix, class_4597 source, int packedLight, int packedOverlay) {
        super.render(conn, catenary, delta, matrix, source, packedLight, packedOverlay);
        int hash = conn.getUUID().hashCode();
        class_4588 buf = RenderConstants.SOLID_TEXTURE.method_24145(source, class_1921::method_23576);
        catenary.visitPoints(0.25f, false, (index, x, y, z, yaw, pitch) -> {
            matrix.method_22903();
            matrix.method_46416(x, y, z);
            matrix.method_22907(class_7833.field_40716.rotation(-yaw));
            matrix.method_22907(class_7833.field_40718.rotation(pitch));
            matrix.method_22907(class_7833.field_40718.rotationDegrees(RAND.get(index + hash) * 45.0f));
            matrix.method_22907(class_7833.field_40716.rotationDegrees(RAND.get(index + 8 + hash) * 60.0f + 90.0f));
            this.rings.setWhich(index % 7);
            this.rings.method_2828(matrix, buf, packedLight, packedOverlay, -1);
            matrix.method_22909();
        });
    }

    public static class_5607 wireLayer() {
        return ConnectionRenderer.WireModel.createLayer(39, 0, 1);
    }

    @Environment(value=EnvType.CLIENT)
    public static class RingsModel
    extends class_3879 {
        final class_630[] roots;
        int which;

        RingsModel(class_630 root) {
            super(class_1921::method_23576);
            class_630[] roots = new class_630[7];
            for (int i = 0; i < 7; ++i) {
                roots[i] = root.method_32086(Integer.toString(i));
            }
            this.roots = roots;
        }

        public static class_5607 createLayer() {
            float size = 4.0f;
            class_5606 root = class_5606.method_32108().method_32101(14, 91).method_32097(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f);
            class_5603 crossPose = class_5603.method_32092((float)0.0f, (float)0.0f, (float)1.5707964f);
            class_5609 mesh = new class_5609();
            for (int i = 0; i < 7; ++i) {
                mesh.method_32111().method_32117(Integer.toString(i), root, class_5603.field_27701).method_32117("cross_" + i, class_5606.method_32108().method_32101(i * 8, 64).method_32097(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 0.0f).method_32097(-4.0f, 0.0f, -4.0f, 8.0f, 0.0f, 8.0f), crossPose);
            }
            return class_5607.method_32110((class_5609)mesh, (int)128, (int)128);
        }

        public void setWhich(int which) {
            this.which = which;
        }

        public void method_2828(class_4587 matrix, class_4588 builder, int light, int overlay, int color) {
            this.roots[this.which].method_22699(matrix, builder, light, overlay, color);
        }
    }
}

