/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.renderer.block.entity;

import de.lucalabs.fairylights.connection.GarlandTinselConnection;
import de.lucalabs.fairylights.renderer.FairyLightModelLayers;
import de.lucalabs.fairylights.renderer.RenderConstants;
import de.lucalabs.fairylights.renderer.block.entity.ConnectionRenderer;
import de.lucalabs.fairylights.util.Curve;
import de.lucalabs.fairylights.util.RandomArray;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_630;
import net.minecraft.class_7833;

@Environment(value=EnvType.CLIENT)
public class GarlandTinselRenderer
extends ConnectionRenderer<GarlandTinselConnection> {
    private static final RandomArray RAND = new RandomArray(9171L, 128);
    private final StripModel strip;

    public GarlandTinselRenderer(Function<class_5601, class_630> baker) {
        super(baker, FairyLightModelLayers.TINSEL_WIRE);
        this.strip = new StripModel(baker.apply(FairyLightModelLayers.TINSEL_STRIP));
    }

    @Override
    protected int getWireColor(GarlandTinselConnection conn) {
        return conn.getColor();
    }

    @Override
    protected void renderSegment(GarlandTinselConnection connection, Curve.SegmentView it, float delta, class_4587 matrix, int packedLight, class_4597 source, int packedOverlay) {
        super.renderSegment(connection, it, delta, matrix, packedLight, source, packedOverlay);
        int color = connection.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        matrix.method_22903();
        matrix.method_46416(it.getX(0.0f), it.getY(0.0f), it.getZ(0.0f));
        matrix.method_22907(class_7833.field_40716.rotation(-it.getYaw()));
        matrix.method_22907(class_7833.field_40718.rotation(it.getPitch()));
        float length = it.getLength();
        int rings = class_3532.method_15386((float)(length * 64.0f));
        int hash = connection.getUUID().hashCode();
        int index = it.getIndex();
        class_4588 buf = RenderConstants.SOLID_TEXTURE.method_24145(source, class_1921::method_23576);
        for (int i = 0; i < rings; ++i) {
            double t = (float)i / (float)rings * length;
            matrix.method_22903();
            matrix.method_22904(t, 0.0, 0.0);
            float rotX = RAND.get(31 * (index + 31 * i) + hash) * 22.0f;
            float rotY = RAND.get(31 * (index + 3 + 31 * i) + hash) * 180.0f;
            float rotZ = RAND.get(31 * (index + 7 + 31 * i) + hash) * 180.0f;
            matrix.method_22907(class_7833.field_40714.rotationDegrees(rotZ));
            matrix.method_22907(class_7833.field_40716.rotationDegrees(rotY));
            matrix.method_22907(class_7833.field_40718.rotationDegrees(rotX));
            matrix.method_22905(1.0f, RAND.get(i * 63) * 0.1f + 1.0f, 0.5f);
            this.strip.method_2828(matrix, buf, packedLight, packedOverlay, class_5253.class_5254.method_59554((float)1.0f, (float)r, (float)g, (float)b));
            matrix.method_22909();
        }
        matrix.method_22909();
    }

    public static class_5607 wireLayer() {
        return ConnectionRenderer.WireModel.createLayer(62, 0, 1);
    }

    @Environment(value=EnvType.CLIENT)
    public static class StripModel
    extends class_3879 {
        final class_630 root;

        StripModel(class_630 root) {
            super(class_1921::method_23576);
            this.root = root;
        }

        public static class_5607 createLayer() {
            class_5609 mesh = new class_5609();
            mesh.method_32111().method_32117("root", class_5606.method_32108().method_32101(62, 0).method_32097(-0.5f, -3.0f, 0.0f, 1.0f, 6.0f, 0.0f), class_5603.field_27701);
            return class_5607.method_32110((class_5609)mesh, (int)128, (int)128);
        }

        public void method_2828(class_4587 matrix, class_4588 builder, int light, int overlay, int color) {
            this.root.method_22699(matrix, builder, light, overlay, color);
        }
    }
}

