/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.renderer.block.entity;

import de.lucalabs.fairylights.connection.Connection;
import de.lucalabs.fairylights.connection.GarlandTinselConnection;
import de.lucalabs.fairylights.connection.GarlandVineConnection;
import de.lucalabs.fairylights.connection.HangingLightsConnection;
import de.lucalabs.fairylights.connection.PennantBuntingConnection;
import de.lucalabs.fairylights.fastener.Fastener;
import de.lucalabs.fairylights.fastener.FenceFastener;
import de.lucalabs.fairylights.model.light.BowModel;
import de.lucalabs.fairylights.renderer.FairyLightModelLayers;
import de.lucalabs.fairylights.renderer.RenderConstants;
import de.lucalabs.fairylights.renderer.block.entity.GarlandTinselRenderer;
import de.lucalabs.fairylights.renderer.block.entity.GarlandVineRenderer;
import de.lucalabs.fairylights.renderer.block.entity.HangingLightsRenderer;
import de.lucalabs.fairylights.renderer.block.entity.PennantBuntingRenderer;
import de.lucalabs.fairylights.util.ColorUtils;
import de.lucalabs.fairylights.util.Tags;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5601;
import net.minecraft.class_5819;
import net.minecraft.class_630;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_811;

@Environment(value=EnvType.CLIENT)
public class FastenerRenderer {
    private final HangingLightsRenderer hangingLights;
    private final PennantBuntingRenderer pennants;
    private final GarlandVineRenderer garland;
    private final GarlandTinselRenderer tinsel;
    private final BowModel bow;

    public FastenerRenderer(Function<class_5601, class_630> baker) {
        this.hangingLights = new HangingLightsRenderer(baker);
        this.pennants = new PennantBuntingRenderer(baker);
        this.garland = new GarlandVineRenderer(baker);
        this.tinsel = new GarlandTinselRenderer(baker);
        this.bow = new BowModel(baker.apply(FairyLightModelLayers.BOW));
    }

    public void render(Fastener<?> fastener, float delta, class_4587 matrix, class_4597 source, int packedLight, int packedOverlay) {
        boolean renderBow = true;
        for (Connection conn : fastener.getAllConnections()) {
            if (conn.getFastener() == fastener) {
                this.renderConnection(delta, matrix, source, packedLight, packedOverlay, conn);
            }
            if (!renderBow || !(conn instanceof GarlandVineConnection) || !this.renderBow(fastener, matrix, source, packedLight, packedOverlay)) continue;
            renderBow = false;
        }
    }

    private boolean renderBow(Fastener<?> fastener, class_4587 matrix, class_4597 source, int packedLight, int packedOverlay) {
        if (fastener instanceof FenceFastener) {
            class_1937 world = fastener.getWorld();
            if (world == null) {
                return false;
            }
            class_2680 state = world.method_8320(fastener.getPos());
            if (!state.method_26164(Tags.FENCES)) {
                return false;
            }
            class_4588 buf = RenderConstants.SOLID_TEXTURE.method_24145(source, class_1921::method_23576);
            float offset = -0.09375f;
            boolean north = (Boolean)state.method_11654((class_2769)class_2354.field_10905);
            boolean east = (Boolean)state.method_11654((class_2769)class_2354.field_10907);
            boolean south = (Boolean)state.method_11654((class_2769)class_2354.field_10904);
            boolean west = (Boolean)state.method_11654((class_2769)class_2354.field_10903);
            boolean tryDirX = true;
            boolean bow = false;
            if (!north && (east || west)) {
                this.bow(matrix, class_2350.field_11043, -0.09375f, buf, packedLight, packedOverlay);
                tryDirX = false;
                bow = true;
            }
            if (!south && (east || west)) {
                this.bow(matrix, class_2350.field_11035, -0.09375f, buf, packedLight, packedOverlay);
                tryDirX = false;
                bow = true;
            }
            if (tryDirX) {
                if (!east && (north || south)) {
                    this.bow(matrix, class_2350.field_11034, -0.09375f, buf, packedLight, packedOverlay);
                    bow = true;
                }
                if (!west && (north || south)) {
                    this.bow(matrix, class_2350.field_11039, -0.09375f, buf, packedLight, packedOverlay);
                    bow = true;
                }
            }
            return bow;
        }
        if (fastener.getFacing().method_10166() != class_2350.class_2351.field_11052) {
            class_4588 buf = RenderConstants.SOLID_TEXTURE.method_24145(source, class_1921::method_23576);
            this.bow(matrix, fastener.getFacing(), 0.0f, buf, packedLight, packedOverlay);
            return true;
        }
        return false;
    }

    private void bow(class_4587 matrix, class_2350 dir, float offset, class_4588 buf, int packedLight, int packedOverlay) {
        matrix.method_22903();
        matrix.method_22907(class_7833.field_40716.rotationDegrees(180.0f - dir.method_10144()));
        if (offset != 0.0f) {
            matrix.method_22904(0.0, 0.0, (double)offset);
        }
        this.bow.method_2828(matrix, buf, packedLight, packedOverlay, ColorUtils.WHITE);
        matrix.method_22909();
    }

    private void renderConnection(float delta, class_4587 matrix, class_4597 source, int packedLight, int packedOverlay, Connection conn) {
        if (conn instanceof HangingLightsConnection) {
            this.hangingLights.render((HangingLightsConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof PennantBuntingConnection) {
            this.pennants.render((PennantBuntingConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof GarlandTinselConnection) {
            this.tinsel.render((GarlandTinselConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof GarlandVineConnection) {
            this.garland.render((GarlandVineConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        }
    }

    public static void renderBakedModel(class_2960 path, class_4587 matrix, class_4588 buf, float r, float g, float b, int packedLight, int packedOverlay) {
        FastenerRenderer.renderBakedModel(class_310.method_1551().method_1554().getModel(path), matrix, buf, r, g, b, packedLight, packedOverlay);
    }

    public static void renderBakedModel(class_1087 model, class_4587 matrix, class_4588 buf, float r, float g, float b, int packedLight, int packedOverlay) {
        FastenerRenderer.renderBakedModel(model, class_811.field_4319, matrix, buf, r, g, b, packedLight, packedOverlay);
    }

    public static void renderBakedModel(class_1087 model, class_811 type, class_4587 matrix, class_4588 buf, float r, float g, float b, int packedLight, int packedOverlay) {
        model.method_4709().method_3503(type).method_23075(false, matrix);
        class_4587.class_4665 lastStack = matrix.method_23760();
        class_5819 randSource = class_5819.method_43047();
        for (class_2350 side : class_2350.values()) {
            randSource.method_43052(42L);
            for (class_777 quad : model.method_4707(null, side, randSource)) {
                buf.method_22919(lastStack, quad, r, g, b, 1.0f, packedLight, packedOverlay);
            }
        }
        randSource.method_43052(42L);
        for (class_777 quad : model.method_4707(null, null, randSource)) {
            buf.method_22919(lastStack, quad, r, g, b, 1.0f, packedLight, packedOverlay);
        }
    }
}

