/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.renderer.block.entity;

import de.lucalabs.fairylights.connection.Connection;
import de.lucalabs.fairylights.renderer.RenderConstants;
import de.lucalabs.fairylights.util.Curve;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_630;
import net.minecraft.class_7833;

@Environment(value=EnvType.CLIENT)
public abstract class ConnectionRenderer<C extends Connection> {
    private final WireModel model;
    private final float wireInflate;

    protected ConnectionRenderer(Function<class_5601, class_630> baker, class_5601 wireModelLocation) {
        this(baker, wireModelLocation, 0.0f);
    }

    protected ConnectionRenderer(Function<class_5601, class_630> baker, class_5601 wireModelLocation, float wireInflate) {
        this.model = new WireModel(baker.apply(wireModelLocation));
        this.wireInflate = wireInflate;
    }

    public void render(C conn, float delta, class_4587 matrix, class_4597 source, int packedLight, int packedOverlay) {
        Curve currCat = ((Connection)conn).getCatenary();
        Curve prevCat = ((Connection)conn).getPrevCatenary();
        if (currCat != null && prevCat != null) {
            Curve cat = prevCat.lerp(currCat, delta);
            Curve.SegmentIterator it = cat.iterator();
            class_4588 buf = RenderConstants.SOLID_TEXTURE.method_24145(source, class_1921::method_23576);
            int color = this.getWireColor(conn);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            while (it.next()) {
                matrix.method_22903();
                matrix.method_46416(it.getX(0.0f), it.getY(0.0f), it.getZ(0.0f));
                matrix.method_22907(class_7833.field_40716.rotation(1.5707964f - it.getYaw()));
                matrix.method_22907(class_7833.field_40714.rotation(-it.getPitch()));
                matrix.method_22905(1.0f + this.wireInflate, 1.0f, it.getLength() * 16.0f);
                this.model.method_2828(matrix, buf, packedLight, packedOverlay, class_5253.class_5254.method_59554((float)1.0f, (float)r, (float)g, (float)b));
                matrix.method_22909();
                this.renderSegment(conn, it, delta, matrix, packedLight, source, packedOverlay);
            }
            this.render(conn, cat, delta, matrix, source, packedLight, packedOverlay);
        }
    }

    protected int getWireColor(C conn) {
        return 0xFFFFFF;
    }

    protected void render(C conn, Curve catenary, float delta, class_4587 matrix, class_4597 source, int packedLight, int packedOverlay) {
    }

    protected void renderSegment(C connection, Curve.SegmentView it, float delta, class_4587 matrix, int packedLight, class_4597 source, int packedOverlay) {
    }

    @Environment(value=EnvType.CLIENT)
    public static class WireModel
    extends class_3879 {
        final class_630 root;

        WireModel(class_630 root) {
            super(class_1921::method_23576);
            this.root = root;
        }

        public void method_2828(class_4587 matrix, class_4588 builder, int light, int overlay, int color) {
            this.root.method_22699(matrix, builder, light, overlay, color);
        }

        public static class_5607 createLayer(int u, int v, int size) {
            class_5609 mesh = new class_5609();
            mesh.method_32111().method_32117("root", class_5606.method_32108().method_32101(u, v).method_32097((float)(-size) * 0.5f, (float)(-size) * 0.5f, 0.0f, (float)size, (float)size, 1.0f), class_5603.field_27701);
            return class_5607.method_32110((class_5609)mesh, (int)128, (int)128);
        }
    }
}

