/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.model.light;

import de.lucalabs.fairylights.feature.light.Light;
import de.lucalabs.fairylights.feature.light.MeteorLightBehavior;
import de.lucalabs.fairylights.model.light.EasyMeshBuilder;
import de.lucalabs.fairylights.model.light.LightModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5607;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public class MeteorLightModel
extends LightModel<MeteorLightBehavior> {
    private static final int LIGHT_COUNT = 12;
    private final PartPair[] lights;
    private final class_630 connector;
    private final class_630 cap;
    private float stage;

    public MeteorLightModel(class_630 root) {
        super(root);
        this.connector = this.unlit.method_32086("connector");
        this.cap = this.unlit.method_32086("cap");
        this.lights = new PartPair[12];
        for (int i = 0; i < 12; ++i) {
            String key = "light_" + i;
            this.lights[i] = new PartPair(this.litTint.method_32086(key), this.litTintGlow.method_32086(key));
        }
    }

    @Override
    public void animate(Light<?> light, MeteorLightBehavior behavior, float delta) {
        super.animate(light, behavior, delta);
        this.red = behavior.getRed(delta);
        this.green = behavior.getGreen(delta);
        this.blue = behavior.getBlue(delta);
        this.stage = behavior.getProgress(delta) * 3.0f - 1.0f;
    }

    private float computeBrightness(float t) {
        return class_3532.method_15363((float)(t - this.stage > 0.0f ? 1.0f - Math.abs(t - this.stage) * 4.0f : 1.0f - Math.abs(t - this.stage)), (float)0.0f, (float)1.0f);
    }

    @Override
    public void method_2828(class_4587 matrix, class_4588 builder, int light, int overlay, int color) {
        for (int i = 0; i < this.lights.length; ++i) {
            this.brightness = this.computeBrightness((float)i / (float)this.lights.length);
            for (int n = 0; n < this.lights.length; ++n) {
                this.lights[n].setVisible(i == n);
            }
            this.connector.field_3665 = i == 0;
            this.cap.field_3665 = i == this.lights.length - 1;
            super.method_2828(matrix, builder, light, overlay, color);
        }
    }

    @Override
    public void renderTranslucent(class_4587 matrix, class_4588 builder, int light, int overlay, int color) {
        for (int i = 0; i < this.lights.length; ++i) {
            this.brightness = this.computeBrightness((float)i / (float)this.lights.length);
            for (int n = 0; n < this.lights.length; ++n) {
                this.lights[n].setVisible(i == n);
            }
            super.renderTranslucent(matrix, builder, light, overlay, color);
        }
    }

    public static class_5607 createLayer() {
        LightModel.LightMeshHelper helper = LightModel.LightMeshHelper.create();
        EasyMeshBuilder connector = new EasyMeshBuilder("connector", 77, 0);
        connector.addBox(-1.0f, -0.5f, -1.0f, 2.0f, 2.0f, 2.0f, -0.05f);
        helper.unlit().addChild(connector);
        EasyMeshBuilder cap = new EasyMeshBuilder("cap", 77, 0);
        cap.addBox(-1.0f, -25.400002f, -1.0f, 2.0f, 1.0f, 2.0f, 0.0f);
        helper.unlit().addChild(cap);
        float rodScale = 0.8f;
        LightModel.BulbBuilder bulb = helper.createBulb();
        for (int i = 0; i < 12; ++i) {
            LightModel.BulbBuilder light = bulb.createChild("light_" + i, 37, 72);
            light.addBox(-1.0f, (float)(-i * 2) - 2.5f + 0.05f, -1.0f, 2.0f, 2.0f, 2.0f, class_3532.method_15374((float)((float)i * (float)Math.PI / 12.0f)) * 0.1f);
        }
        return helper.build();
    }

    @Environment(value=EnvType.CLIENT)
    private record PartPair(class_630 first, class_630 second) {
        void setVisible(boolean visible) {
            this.first().field_3665 = visible;
            this.second().field_3665 = visible;
        }
    }
}

