/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.items.crafting;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.math.IntMath;
import de.lucalabs.fairylights.items.crafting.GenericIngredient;
import de.lucalabs.fairylights.items.crafting.IllegalRecipeException;
import de.lucalabs.fairylights.items.crafting.RegularIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.AuxiliaryIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.EmptyRegularIngredient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9323;
import net.minecraft.class_9335;
import net.minecraft.class_9694;
import org.jetbrains.annotations.Nullable;

public final class GenericRecipe
extends class_1852 {
    public static final EmptyRegularIngredient EMPTY = new EmptyRegularIngredient();
    private final class_2960 id;
    private final Supplier<? extends class_1865<GenericRecipe>> serializer;
    private final class_1799 output;
    private final RegularIngredient[] ingredients;
    private final AuxiliaryIngredient<?>[] auxiliaryIngredients;
    private final int width;
    private final int height;
    private final int outputIngredient;
    private final ImmutableList<IntUnaryOperator> xFunctions = ImmutableList.of((Object)IntUnaryOperator.identity(), i -> this.getWidth() - 1 - i);
    private class_1799 result = class_1799.field_8037;
    private int room;

    GenericRecipe(class_2960 id, Supplier<? extends class_1865<GenericRecipe>> serializer, class_1799 output, RegularIngredient[] ingredients, AuxiliaryIngredient<?>[] auxiliaryIngredients, int width, int height, int outputIngredient) {
        super(class_7710.field_40251);
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"width must be greater than zero");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"height must be greater than zero");
        this.id = id;
        this.serializer = Objects.requireNonNull(serializer, "serializer");
        this.output = Objects.requireNonNull(output, "output");
        this.ingredients = Objects.requireNonNull(ingredients, "ingredients");
        this.auxiliaryIngredients = GenericRecipe.checkIngredients(ingredients, Objects.requireNonNull(auxiliaryIngredients, "auxiliaryIngredients"));
        this.width = width;
        this.height = height;
        this.outputIngredient = outputIngredient;
        this.room = -1;
    }

    private static AuxiliaryIngredient<?>[] checkIngredients(RegularIngredient[] ingredients, AuxiliaryIngredient<?>[] auxiliaryIngredients) {
        GenericRecipe.checkForNulls(ingredients);
        GenericRecipe.checkForNulls(auxiliaryIngredients);
        boolean ingredientDictator = GenericRecipe.checkDictatorship(false, ingredients);
        GenericRecipe.checkDictatorship(ingredientDictator, auxiliaryIngredients);
        return auxiliaryIngredients;
    }

    private static void checkForNulls(GenericIngredient<?, ?>[] ingredients) {
        for (int i = 0; i < ingredients.length; ++i) {
            if (ingredients[i] != null) continue;
            throw new NullPointerException("Must not have null ingredients, found at index " + i);
        }
    }

    private static boolean checkDictatorship(boolean foundDictator, GenericIngredient<?, ?>[] ingredients) {
        for (GenericIngredient<?, ?> ingredient : ingredients) {
            if (!ingredient.dictatesOutputType()) continue;
            if (foundDictator) {
                throw new IllegalRecipeException("Only one ingredient can dictate output type");
            }
            foundDictator = true;
        }
        return foundDictator;
    }

    public class_2960 getId() {
        return this.id;
    }

    private int getRoom() {
        if (this.room < 0) {
            int room = 0;
            for (RegularIngredient regularIngredient : this.ingredients) {
                if (!regularIngredient.getInputs().isEmpty()) continue;
                ++room;
            }
            for (GenericIngredient<RegularIngredient, MatchResultRegular> genericIngredient : this.auxiliaryIngredients) {
                if (!genericIngredient.isRequired()) continue;
                --room;
            }
            this.room = room;
        }
        return this.room;
    }

    private class_2371<class_1856> getDisplayIngredients() {
        int i;
        class_2371 ingredients = class_2371.method_10213((int)9, (Object)class_1856.field_9017);
        for (i = 0; i < this.ingredients.length; ++i) {
            int x = i % this.width;
            int y = i / this.width;
            class_1799[] stacks = (class_1799[])this.ingredients[i].getInputs().toArray((Object[])new class_1799[0]);
            ingredients.set(x + y * 3, (Object)class_1856.method_8101((class_1799[])stacks));
        }
        i = 0;
        block1: for (int slot = 0; slot < ingredients.size(); ++slot) {
            class_1856 ing = (class_1856)ingredients.get(slot);
            if (!ing.method_8103()) continue;
            while (i < this.auxiliaryIngredients.length) {
                AuxiliaryIngredient<?> aux;
                if (!(aux = this.auxiliaryIngredients[i++]).isRequired()) continue;
                class_1799[] stacks = (class_1799[])aux.getInputs().toArray((Object[])new class_1799[0]);
                ingredients.set(slot, (Object)class_1856.method_8101((class_1799[])stacks));
                continue block1;
            }
        }
        return ingredients;
    }

    public boolean method_8118() {
        return this.output.method_7960();
    }

    public class_1865<?> method_8119() {
        return this.serializer.get();
    }

    public class_1799 getOutput() {
        return this.output.method_7972();
    }

    public RegularIngredient[] getGenericIngredients() {
        return (RegularIngredient[])this.ingredients.clone();
    }

    public AuxiliaryIngredient<?>[] getAuxiliaryIngredients() {
        return (AuxiliaryIngredient[])this.auxiliaryIngredients.clone();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public class_2371<class_1856> method_8117() {
        return this.getDisplayIngredients();
    }

    public boolean method_8113(int width, int height) {
        return this.width <= width && this.height <= height && (this.getRoom() >= 0 || width * height - this.width * this.height + this.getRoom() >= 0);
    }

    public boolean matches(class_9694 inventory, @Nullable class_1937 world) {
        if (!this.method_8113(inventory.method_59991(), inventory.method_59992())) {
            return false;
        }
        int scanWidth = inventory.method_59991() + 1 - this.width;
        int scanHeight = inventory.method_59992() + 1 - this.height;
        int end = scanWidth * scanHeight;
        for (int i = 0; i < end; ++i) {
            int x = i % scanWidth;
            int y = i / scanWidth;
            for (IntUnaryOperator func : this.xFunctions) {
                class_1799 result = this.getResult(inventory, x, y, func);
                if (result.method_7960()) continue;
                this.result = result;
                return true;
            }
        }
        this.result = class_1799.field_8037;
        return false;
    }

    private class_1799 getResult(class_9694 inventory, int originX, int originY, IntUnaryOperator funcX) {
        MatchResultRegular[] match = new MatchResultRegular[this.ingredients.length];
        LinkedListMultimap auxMatchResults = LinkedListMultimap.create();
        HashMap auxMatchTotals = new HashMap();
        HashSet presentCalled = new HashSet();
        ArrayList<MatchResultAuxiliary> auxResults = new ArrayList<MatchResultAuxiliary>();
        class_1792 item = this.output.method_7909();
        class_9335 comps = new class_9335(class_9335.field_49584);
        int w = inventory.method_59991();
        int size = w * inventory.method_59992();
        for (int i = 0; i < size; ++i) {
            int x = i % w;
            int y = i / w;
            int ingX = x - originX;
            int ingY = y - originY;
            class_1799 input = inventory.method_59985(x, y);
            if (this.contains(ingX, ingY)) {
                int index = funcX.applyAsInt(ingX) + ingY * this.width;
                RegularIngredient ingredient = this.ingredients[index];
                MatchResultRegular result = (MatchResultRegular)ingredient.matches(input);
                if (!result.doesMatch()) {
                    return class_1799.field_8037;
                }
                match[index] = result;
                result.forMatch(presentCalled, comps);
                if (index != this.outputIngredient) continue;
                comps.method_57933(input.method_57353());
                item = input.method_7909();
                continue;
            }
            if (EMPTY.matches(input).doesMatch()) continue;
            boolean nonAuxiliary = true;
            for (AuxiliaryIngredient<?> auxiliaryIngredient : this.auxiliaryIngredients) {
                MatchResultAuxiliary result = (MatchResultAuxiliary)auxiliaryIngredient.matches(input);
                if (result.doesMatch()) {
                    if (result.isAtLimit(auxMatchTotals.getOrDefault(result.ingredient, 0))) {
                        return class_1799.field_8037;
                    }
                    result.forMatch(presentCalled, comps);
                    auxMatchTotals.merge(result.ingredient, 1, IntMath::checkedAdd);
                    nonAuxiliary = false;
                    result.propagate((Multimap<AuxiliaryIngredient<?>, MatchResultAuxiliary>)auxMatchResults);
                }
                auxResults.add(result);
            }
            if (!nonAuxiliary) continue;
            return class_1799.field_8037;
        }
        HashSet absentCalled = new HashSet();
        for (MatchResultRegular result : match) {
            result.notifyAbsence(presentCalled, absentCalled, comps);
        }
        for (MatchResultAuxiliary result : auxResults) {
            result.notifyAbsence(presentCalled, absentCalled, comps);
        }
        for (AuxiliaryIngredient<?> ingredient : this.auxiliaryIngredients) {
            if (!ingredient.process((Multimap<AuxiliaryIngredient<?>, MatchResultAuxiliary>)auxMatchResults, comps)) continue;
            return class_1799.field_8037;
        }
        class_1799 output = this.output.method_7960() ? new class_1799((class_1935)item) : this.output.method_7972();
        output.method_57365((class_9323)comps);
        return output;
    }

    private boolean contains(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public class_1799 craft(class_9694 inventory, class_7225.class_7874 lookup) {
        class_1799 result = this.result;
        return result.method_7960() ? result : result.method_7972();
    }

    public static class MatchResultRegular
    implements MatchResult<RegularIngredient, MatchResultRegular> {
        protected final RegularIngredient ingredient;
        protected final class_1799 input;
        protected final boolean doesMatch;
        protected final ImmutableList<MatchResultRegular> supplementaryResults;

        public MatchResultRegular(RegularIngredient ingredient, class_1799 input, boolean doesMatch, List<MatchResultRegular> supplementaryResults) {
            this.ingredient = Objects.requireNonNull(ingredient, "ingredient");
            this.input = input;
            this.doesMatch = doesMatch;
            this.supplementaryResults = ImmutableList.copyOf(supplementaryResults);
        }

        @Override
        public final RegularIngredient getIngredient() {
            return this.ingredient;
        }

        @Override
        public final class_1799 getInput() {
            return this.input;
        }

        @Override
        public final boolean doesMatch() {
            return this.doesMatch;
        }

        @Override
        public void forMatch(Set<GenericIngredient<?, ?>> called, class_9335 comps) {
            this.ingredient.matched(this.input, comps);
            if (called.add(this.ingredient)) {
                this.ingredient.present(comps);
            }
        }

        @Override
        public void notifyAbsence(Set<GenericIngredient<?, ?>> presentCalled, Set<GenericIngredient<?, ?>> absentCalled, class_9335 comps) {
            if (!presentCalled.contains(this.ingredient) && !absentCalled.contains(this.ingredient)) {
                this.ingredient.absent(comps);
                absentCalled.add(this.ingredient);
            }
            for (MatchResultRegular result : this.supplementaryResults) {
                result.notifyAbsence(presentCalled, absentCalled, comps);
            }
        }

        @Override
        public MatchResultRegular withParent(MatchResultRegular parent) {
            return new MatchResultParentedRegular(this.ingredient, this.input, this.doesMatch, (List<MatchResultRegular>)this.supplementaryResults, parent);
        }
    }

    public static interface MatchResult<I extends GenericIngredient<I, M>, M extends MatchResult<I, M>> {
        public I getIngredient();

        public class_1799 getInput();

        public boolean doesMatch();

        public void forMatch(Set<GenericIngredient<?, ?>> var1, class_9335 var2);

        public void notifyAbsence(Set<GenericIngredient<?, ?>> var1, Set<GenericIngredient<?, ?>> var2, class_9335 var3);

        public M withParent(M var1);
    }

    public static class MatchResultAuxiliary
    implements MatchResult<AuxiliaryIngredient<?>, MatchResultAuxiliary> {
        protected final AuxiliaryIngredient<?> ingredient;
        protected final class_1799 input;
        protected final boolean doesMatch;
        protected final ImmutableList<MatchResultAuxiliary> supplementaryResults;

        public MatchResultAuxiliary(AuxiliaryIngredient<?> ingredient, class_1799 input, boolean doesMatch, List<MatchResultAuxiliary> supplementaryResults) {
            this.ingredient = Objects.requireNonNull(ingredient, "ingredient");
            this.input = input;
            this.doesMatch = doesMatch;
            this.supplementaryResults = ImmutableList.copyOf(supplementaryResults);
        }

        @Override
        public final AuxiliaryIngredient<?> getIngredient() {
            return this.ingredient;
        }

        @Override
        public final class_1799 getInput() {
            return this.input;
        }

        @Override
        public final boolean doesMatch() {
            return this.doesMatch;
        }

        @Override
        public void forMatch(Set<GenericIngredient<?, ?>> called, class_9335 comps) {
            if (!called.contains(this.ingredient)) {
                this.ingredient.present(comps);
                called.add(this.ingredient);
            }
        }

        @Override
        public void notifyAbsence(Set<GenericIngredient<?, ?>> presentCalled, Set<GenericIngredient<?, ?>> absentCalled, class_9335 comps) {
            if (!presentCalled.contains(this.ingredient) && !absentCalled.contains(this.ingredient)) {
                this.ingredient.absent(comps);
                absentCalled.add(this.ingredient);
            }
            for (MatchResultAuxiliary result : this.supplementaryResults) {
                result.notifyAbsence(presentCalled, absentCalled, comps);
            }
        }

        @Override
        public MatchResultAuxiliary withParent(MatchResultAuxiliary parent) {
            return new MatchResultParentedAuxiliary(this.ingredient, this.input, this.doesMatch, (List<MatchResultAuxiliary>)this.supplementaryResults, parent);
        }

        public boolean isAtLimit(int count) {
            return count >= this.ingredient.getLimit();
        }

        public void propagate(Multimap<AuxiliaryIngredient<?>, MatchResultAuxiliary> map) {
            map.put(this.ingredient, (Object)this);
        }
    }

    public static class MatchResultParentedAuxiliary
    extends MatchResultAuxiliary {
        protected final MatchResultAuxiliary parent;

        public MatchResultParentedAuxiliary(AuxiliaryIngredient<?> ingredient, class_1799 input, boolean doesMatch, List<MatchResultAuxiliary> supplementaryResults, MatchResultAuxiliary parent) {
            super(ingredient, input, doesMatch, supplementaryResults);
            this.parent = Objects.requireNonNull(parent, "parent");
        }

        @Override
        public void forMatch(Set<GenericIngredient<?, ?>> called, class_9335 comps) {
            super.forMatch(called, comps);
            this.parent.forMatch(called, comps);
        }

        @Override
        public void notifyAbsence(Set<GenericIngredient<?, ?>> presentCalled, Set<GenericIngredient<?, ?>> absentCalled, class_9335 comps) {
            super.notifyAbsence(presentCalled, absentCalled, comps);
            this.parent.notifyAbsence(presentCalled, absentCalled, comps);
        }

        @Override
        public MatchResultAuxiliary withParent(MatchResultAuxiliary parent) {
            return this.parent.withParent(new MatchResultParentedAuxiliary(this.ingredient, this.input, this.doesMatch, (List<MatchResultAuxiliary>)this.supplementaryResults, parent));
        }

        @Override
        public boolean isAtLimit(int count) {
            return super.isAtLimit(count) || this.parent.isAtLimit(count);
        }

        @Override
        public void propagate(Multimap<AuxiliaryIngredient<?>, MatchResultAuxiliary> map) {
            super.propagate(map);
            this.parent.propagate(map);
        }
    }

    public static class MatchResultParentedRegular
    extends MatchResultRegular {
        protected final MatchResultRegular parent;

        public MatchResultParentedRegular(RegularIngredient ingredient, class_1799 input, boolean doesMatch, List<MatchResultRegular> supplementaryResults, MatchResultRegular parent) {
            super(ingredient, input, doesMatch, supplementaryResults);
            this.parent = Objects.requireNonNull(parent, "parent");
        }

        @Override
        public void forMatch(Set<GenericIngredient<?, ?>> called, class_9335 comps) {
            super.forMatch(called, comps);
            this.parent.forMatch(called, comps);
        }

        @Override
        public void notifyAbsence(Set<GenericIngredient<?, ?>> presentCalled, Set<GenericIngredient<?, ?>> absentCalled, class_9335 comps) {
            super.notifyAbsence(presentCalled, absentCalled, comps);
            this.parent.notifyAbsence(presentCalled, absentCalled, comps);
        }

        @Override
        public MatchResultRegular withParent(MatchResultRegular parent) {
            return this.parent.withParent(new MatchResultParentedRegular(this.ingredient, this.input, this.doesMatch, (List<MatchResultRegular>)this.supplementaryResults, parent));
        }
    }
}

