/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.items.crafting;

import com.google.common.collect.ImmutableList;
import de.lucalabs.fairylights.FairyLights;
import de.lucalabs.fairylights.items.DyeableItem;
import de.lucalabs.fairylights.items.FairyLightItems;
import de.lucalabs.fairylights.items.components.FairyLightItemComponents;
import de.lucalabs.fairylights.items.crafting.CopyColorRecipe;
import de.lucalabs.fairylights.items.crafting.GenericRecipe;
import de.lucalabs.fairylights.items.crafting.GenericRecipeBuilder;
import de.lucalabs.fairylights.items.crafting.RegularIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.BasicAuxiliaryIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.BasicRegularIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.InertBasicAuxiliaryIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.LazyTagIngredient;
import de.lucalabs.fairylights.string.StringType;
import de.lucalabs.fairylights.string.StringTypes;
import de.lucalabs.fairylights.util.Blender;
import de.lucalabs.fairylights.util.OreDictUtils;
import de.lucalabs.fairylights.util.Tags;
import de.lucalabs.fairylights.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_9335;

public final class FairyLightCraftingRecipes {
    public static final class_1865<GenericRecipe> HANGING_LIGHTS = FairyLightCraftingRecipes.register("crafting_special_hanging_lights", id -> new class_1866(x -> FairyLightCraftingRecipes.createHangingLights(id, x)));
    public static final class_1865<GenericRecipe> HANGING_LIGHTS_AUGMENTATION = FairyLightCraftingRecipes.register("crafting_special_hanging_lights_augmentation", id -> new class_1866(x -> FairyLightCraftingRecipes.createHangingLightsAugmentation(id, x)));
    public static final class_1865<GenericRecipe> PENNANT_BUNTING = FairyLightCraftingRecipes.register("crafting_special_pennant_bunting", id -> new class_1866(x -> FairyLightCraftingRecipes.createPennantBunting(id, x)));
    public static final class_1865<GenericRecipe> PENNANT_BUNTING_AUGMENTATION = FairyLightCraftingRecipes.register("crafting_special_pennant_bunting_augmentation", id -> new class_1866(x -> FairyLightCraftingRecipes.createPennantBuntingAugmentation(id, x)));
    public static final class_1865<GenericRecipe> TINSEL_GARLAND = FairyLightCraftingRecipes.register("crafting_special_tinsel_garland", id -> new class_1866(x -> FairyLightCraftingRecipes.createTinselGarland(id, x)));
    public static final class_1865<GenericRecipe> TRIANGLE_PENNANT = FairyLightCraftingRecipes.register("crafting_special_triangle_pennant", id -> new class_1866(x -> FairyLightCraftingRecipes.createTrianglePennant(id, x)));
    public static final class_1865<GenericRecipe> SQUARE_PENNANT = FairyLightCraftingRecipes.register("crafting_special_square_pennant", id -> new class_1866(x -> FairyLightCraftingRecipes.createSquarePennant(id, x)));
    public static final class_1865<GenericRecipe> FAIRY_LIGHT = FairyLightCraftingRecipes.register("crafting_special_fairy_light", id -> new class_1866(x -> FairyLightCraftingRecipes.createFairyLight(id, x)));
    public static final class_1865<GenericRecipe> PAPER_LANTERN = FairyLightCraftingRecipes.register("crafting_special_paper_lantern", id -> new class_1866(x -> FairyLightCraftingRecipes.createPaperLantern(id, x)));
    public static final class_1865<GenericRecipe> ORB_LANTERN = FairyLightCraftingRecipes.register("crafting_special_orb_lantern", id -> new class_1866(x -> FairyLightCraftingRecipes.createOrbLantern(id, x)));
    public static final class_1865<GenericRecipe> FLOWER_LIGHT = FairyLightCraftingRecipes.register("crafting_special_flower_light", id -> new class_1866(x -> FairyLightCraftingRecipes.createFlowerLight(id, x)));
    public static final class_1865<GenericRecipe> CANDLE_LANTERN_LIGHT = FairyLightCraftingRecipes.register("crafting_special_candle_lantern_light", id -> new class_1866(x -> FairyLightCraftingRecipes.createCandleLanternLight(id, x)));
    public static final class_1865<GenericRecipe> JACK_O_LANTERN = FairyLightCraftingRecipes.register("crafting_special_jack_o_lantern", id -> new class_1866(x -> FairyLightCraftingRecipes.createJackOLantern(id, x)));
    public static final class_1865<GenericRecipe> SKULL_LIGHT = FairyLightCraftingRecipes.register("crafting_special_skull_light", id -> new class_1866(x -> FairyLightCraftingRecipes.createSkullLight(id, x)));
    public static final class_1865<GenericRecipe> GHOST_LIGHT = FairyLightCraftingRecipes.register("crafting_special_ghost_light", id -> new class_1866(x -> FairyLightCraftingRecipes.createGhostLight(id, x)));
    public static final class_1865<GenericRecipe> SPIDER_LIGHT = FairyLightCraftingRecipes.register("crafting_special_spider_light", id -> new class_1866(x -> FairyLightCraftingRecipes.createSpiderLight(id, x)));
    public static final class_1865<GenericRecipe> WITCH_LIGHT = FairyLightCraftingRecipes.register("crafting_special_witch_light", id -> new class_1866(x -> FairyLightCraftingRecipes.createWitchLight(id, x)));
    public static final class_1865<GenericRecipe> SNOWFLAKE_LIGHT = FairyLightCraftingRecipes.register("crafting_special_snowflake_light", id -> new class_1866(x -> FairyLightCraftingRecipes.createSnowflakeLight(id, x)));
    public static final class_1865<GenericRecipe> HEART_LIGHT = FairyLightCraftingRecipes.register("crafting_special_heart_light", id -> new class_1866(x -> FairyLightCraftingRecipes.createHeartLight(id, x)));
    public static final class_1865<GenericRecipe> MOON_LIGHT = FairyLightCraftingRecipes.register("crafting_special_moon_light", id -> new class_1866(x -> FairyLightCraftingRecipes.createMoonLight(id, x)));
    public static final class_1865<GenericRecipe> STAR_LIGHT = FairyLightCraftingRecipes.register("crafting_special_star_light", id -> new class_1866(x -> FairyLightCraftingRecipes.createStarLight(id, x)));
    public static final class_1865<GenericRecipe> ICICLE_LIGHTS = FairyLightCraftingRecipes.register("crafting_special_icicle_lights", id -> new class_1866(x -> FairyLightCraftingRecipes.createIcicleLights(id, x)));
    public static final class_1865<GenericRecipe> METEOR_LIGHT = FairyLightCraftingRecipes.register("crafting_special_meteor_light", id -> new class_1866(x -> FairyLightCraftingRecipes.createMeteorLight(id, x)));
    public static final class_1865<GenericRecipe> LIGHT_TWINKLE = FairyLightCraftingRecipes.register("crafting_special_light_twinkle", id -> new class_1866(x -> FairyLightCraftingRecipes.createLightTwinkle(id, x)));
    public static final class_1865<GenericRecipe> COLOR_CHANGING_LIGHT = FairyLightCraftingRecipes.register("crafting_special_color_changing_light", id -> new class_1866(x -> FairyLightCraftingRecipes.createColorChangingLight(id, x)));
    public static final class_1865<GenericRecipe> EDIT_COLOR = FairyLightCraftingRecipes.register("crafting_special_edit_color", id -> new class_1866(x -> FairyLightCraftingRecipes.createDyeColor(id, x)));
    public static final class_1865<class_1852> COPY_COLOR = FairyLightCraftingRecipes.register("crafting_special_copy_color", id -> new class_1866(CopyColorRecipe::new));
    public static final RegularIngredient DYE_SUBTYPE_INGREDIENT = new BasicRegularIngredient(LazyTagIngredient.of(Tags.DYES)){

        @Override
        public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
            return DyeableItem.getDyeColor(output).map(dye -> ImmutableList.of(OreDictUtils.getDyes(dye))).orElse(ImmutableList.of());
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public void matched(class_1799 ingredient, class_9335 comps) {
            comps.method_57938(FairyLightItemComponents.COLOR, (Object)DyeableItem.getColor(OreDictUtils.getDyeColor(ingredient)));
        }
    };

    private FairyLightCraftingRecipes() {
    }

    private static GenericRecipe createDyeColor(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> EDIT_COLOR).withShape("I").withIngredient('I', Tags.DYEABLE).withOutput('I').withAuxiliaryIngredient(new BasicAuxiliaryIngredient<Blender>((class_1856)LazyTagIngredient.of(Tags.DYES), true, 8){

            @Override
            public Blender accumulator() {
                return new Blender();
            }

            @Override
            public void consume(Blender data, class_1799 ingredient) {
                data.add(DyeableItem.getColor(OreDictUtils.getDyeColor(ingredient)));
            }

            @Override
            public boolean finish(Blender data, class_9335 comps) {
                comps.method_57938(FairyLightItemComponents.COLOR, (Object)data.blend());
                return false;
            }
        }).build();
    }

    private static GenericRecipe createLightTwinkle(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> LIGHT_TWINKLE).withShape("L").withIngredient('L', Tags.TWINKLING_LIGHTS).withOutput('L').withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8601}), true, 1){

            @Override
            public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
                return Boolean.TRUE.equals(output.method_57824(FairyLightItemComponents.TWINKLE)) ? super.getInput(output) : ImmutableList.of();
            }

            @Override
            public void present(class_9335 comps) {
                comps.method_57938(FairyLightItemComponents.TWINKLE, (Object)true);
            }

            @Override
            public void absent(class_9335 comps) {
                comps.method_57938(FairyLightItemComponents.TWINKLE, (Object)false);
            }

            @Override
            public List<class_5348> getTooltip() {
                List<class_5348> tooltips = super.getTooltip();
                tooltips.add((class_5348)Utils.formatRecipeTooltip("recipe.fairylights.twinkling_lights.glowstone"));
                return tooltips;
            }
        }).build();
    }

    private static GenericRecipe createColorChangingLight(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> COLOR_CHANGING_LIGHT).withShape("IG").withIngredient('I', Tags.DYEABLE_LIGHTS).withOutput('I').withIngredient('G', class_1802.field_8397).withAuxiliaryIngredient(new BasicAuxiliaryIngredient<List<Integer>>((class_1856)LazyTagIngredient.of(Tags.DYES), true, 8){

            @Override
            public List<Integer> accumulator() {
                return Collections.emptyList();
            }

            @Override
            public void consume(List<Integer> data, class_1799 ingredient) {
                data.add(DyeableItem.getColor(OreDictUtils.getDyeColor(ingredient)));
            }

            @Override
            public boolean finish(List<Integer> data, class_9335 comps) {
                if (!data.isEmpty()) {
                    if (comps.method_57832(FairyLightItemComponents.COLOR)) {
                        data.addFirst((Integer)comps.method_57829(FairyLightItemComponents.COLOR));
                        comps.method_57939(FairyLightItemComponents.COLOR);
                    }
                    comps.method_57938(FairyLightItemComponents.COLORS, Utils.deepCopyList(data, Function.identity()));
                }
                return false;
            }
        }).build();
    }

    private static GenericRecipe createHangingLights(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> HANGING_LIGHTS, FairyLightItems.HANGING_LIGHTS).withShape("I-I").withIngredient('I', class_1802.field_8620).withIngredient('-', class_1802.field_8276).withAuxiliaryIngredient(new LightIngredient(true)).withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(LazyTagIngredient.of(Tags.DYES_WHITE), false, 1){

            @Override
            public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
                StringType string = (StringType)output.method_57824(FairyLightItemComponents.STRING);
                return string != null && string.equals(StringTypes.WHITE_STRING) ? super.getInput(output) : ImmutableList.of();
            }

            @Override
            public void present(class_9335 comps) {
                comps.method_57938(FairyLightItemComponents.STRING, (Object)StringTypes.WHITE_STRING);
            }

            @Override
            public void absent(class_9335 comps) {
                comps.method_57938(FairyLightItemComponents.STRING, (Object)StringTypes.BLACK_STRING);
            }

            @Override
            public List<class_5348> getTooltip() {
                List<class_5348> tooltip = super.getTooltip();
                tooltip.add((class_5348)Utils.formatRecipeTooltip("recipe.fairylights.hangingLights.string"));
                return tooltip;
            }
        }).build();
    }

    private static GenericRecipe createHangingLightsAugmentation(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> HANGING_LIGHTS_AUGMENTATION, FairyLightItems.HANGING_LIGHTS).withShape("F").withIngredient('F', new BasicRegularIngredient(class_1856.method_8091((class_1935[])new class_1935[]{FairyLightItems.HANGING_LIGHTS})){

            @Override
            public ImmutableList<class_1799> getInputs() {
                return (ImmutableList)Arrays.stream(this.ingredient.method_8105()).map(class_1799::method_7972).flatMap(stack -> FairyLightCraftingRecipes.makeHangingLightsExamples(stack).stream()).collect(ImmutableList.toImmutableList());
            }

            @Override
            public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
                class_1799 stack = output.method_7972();
                if (stack.method_57353().method_57837()) {
                    return ImmutableList.of();
                }
                stack.method_7939(1);
                return ImmutableList.of((Object)ImmutableList.of((Object)stack));
            }

            @Override
            public void matched(class_1799 ingredient, class_9335 comps) {
                comps.method_57933(ingredient.method_57353());
            }
        }).withAuxiliaryIngredient(new LightIngredient(true){

            @Override
            public ImmutableList<class_1799> getInputs() {
                return ImmutableList.of();
            }

            @Override
            public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
                return ImmutableList.of();
            }
        }).build();
    }

    private static ImmutableList<class_1799> makeHangingLightsExamples(class_1799 stack) {
        return ImmutableList.of((Object)FairyLightCraftingRecipes.makeHangingLights(stack, class_1767.field_7955, class_1767.field_7958, class_1767.field_7955, class_1767.field_7952), (Object)FairyLightCraftingRecipes.makeHangingLights(stack, class_1767.field_7955, class_1767.field_7951, class_1767.field_7955, class_1767.field_7951), (Object)FairyLightCraftingRecipes.makeHangingLights(stack, class_1767.field_7967, class_1767.field_7954, class_1767.field_7955, class_1767.field_7942), (Object)FairyLightCraftingRecipes.makeHangingLights(stack, class_1767.field_7967, class_1767.field_7945, class_1767.field_7967, class_1767.field_7942), (Object)FairyLightCraftingRecipes.makeHangingLights(stack, class_1767.field_7955, class_1767.field_7947, class_1767.field_7955, class_1767.field_7945));
    }

    public static class_1799 makeHangingLights(class_1799 base, class_1767 ... colors) {
        class_1799 stack = base.method_7972();
        ArrayList<class_1799> lights = new ArrayList<class_1799>();
        for (class_1767 color : colors) {
            lights.add(DyeableItem.setColor(new class_1799((class_1935)FairyLightItems.FAIRY_LIGHT), color));
        }
        stack.method_57379(FairyLightItemComponents.PATTERN, lights);
        stack.method_57379(FairyLightItemComponents.STRING, (Object)StringTypes.BLACK_STRING);
        return stack;
    }

    private static GenericRecipe createPennantBunting(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> PENNANT_BUNTING, FairyLightItems.PENNANT_BUNTING).withShape("I-I").withIngredient('I', class_1802.field_8620).withIngredient('-', class_1802.field_8276).withAuxiliaryIngredient(new PennantIngredient()).build();
    }

    private static GenericRecipe createTinselGarland(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> TINSEL_GARLAND, FairyLightItems.TINSEL).withShape(" P ", "I-I", " D ").withIngredient('P', class_1802.field_8407).withIngredient('I', class_1802.field_8620).withIngredient('-', class_1802.field_8276).withIngredient('D', DYE_SUBTYPE_INGREDIENT).build();
    }

    private static GenericRecipe createPennantBuntingAugmentation(class_2960 name, class_7710 craftingBookCategory) {
        return new GenericRecipeBuilder(name, () -> PENNANT_BUNTING_AUGMENTATION, FairyLightItems.PENNANT_BUNTING).withShape("B").withIngredient('B', new BasicRegularIngredient(class_1856.method_8091((class_1935[])new class_1935[]{FairyLightItems.PENNANT_BUNTING})){

            @Override
            public ImmutableList<class_1799> getInputs() {
                return (ImmutableList)Arrays.stream(this.ingredient.method_8105()).map(class_1799::method_7972).flatMap(stack -> FairyLightCraftingRecipes.makePennantExamples(stack).stream()).collect(ImmutableList.toImmutableList());
            }

            @Override
            public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
                if (output.method_57353().method_57837()) {
                    return ImmutableList.of();
                }
                return ImmutableList.of(FairyLightCraftingRecipes.makePennantExamples(output));
            }

            @Override
            public void matched(class_1799 ingredient, class_9335 comps) {
                comps.method_57933(ingredient.method_57353());
            }
        }).withAuxiliaryIngredient(new PennantIngredient()).build();
    }

    private static ImmutableList<class_1799> makePennantExamples(class_1799 stack) {
        return ImmutableList.of((Object)FairyLightCraftingRecipes.makePennant(stack, class_1767.field_7966, class_1767.field_7947, class_1767.field_7964), (Object)FairyLightCraftingRecipes.makePennant(stack, class_1767.field_7954, class_1767.field_7951), (Object)FairyLightCraftingRecipes.makePennant(stack, class_1767.field_7946, class_1767.field_7952), (Object)FairyLightCraftingRecipes.makePennant(stack, class_1767.field_7961, class_1767.field_7947));
    }

    public static class_1799 makePennant(class_1799 base, class_1767 ... colors) {
        class_1799 stack = base.method_7972();
        ArrayList<class_1799> pennants = new ArrayList<class_1799>();
        for (class_1767 color : colors) {
            class_1799 pennant = new class_1799((class_1935)FairyLightItems.TRIANGLE_PENNANT);
            DyeableItem.setColor(pennant, color);
            pennants.add(pennant);
        }
        stack.method_57379(FairyLightItemComponents.PATTERN, pennants);
        return stack;
    }

    private static GenericRecipe createPennant(class_2960 name, Supplier<class_1865<GenericRecipe>> serializer, class_1792 item, String pattern) {
        return new GenericRecipeBuilder(name, serializer, item).withShape("- -", "PDP", pattern).withIngredient('P', class_1802.field_8407).withIngredient('-', class_1802.field_8276).withIngredient('D', DYE_SUBTYPE_INGREDIENT).build();
    }

    private static GenericRecipe createTrianglePennant(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createPennant(name, () -> TRIANGLE_PENNANT, FairyLightItems.TRIANGLE_PENNANT, " P ");
    }

    private static GenericRecipe createSquarePennant(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createPennant(name, () -> SQUARE_PENNANT, FairyLightItems.SQUARE_PENNANT, "PPP");
    }

    private static GenericRecipe createFairyLight(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> FAIRY_LIGHT, () -> FairyLightItems.FAIRY_LIGHT, b -> b.withShape(" I ", "IDI", " G ").withIngredient('G', class_1802.field_8141));
    }

    private static GenericRecipe createPaperLantern(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> PAPER_LANTERN, () -> FairyLightItems.PAPER_LANTERN, b -> b.withShape(" I ", "PDP", "PPP").withIngredient('P', class_1802.field_8407));
    }

    private static GenericRecipe createOrbLantern(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> ORB_LANTERN, () -> FairyLightItems.ORB_LANTERN, b -> b.withShape(" I ", "SDS", " W ").withIngredient('S', class_1802.field_8276).withIngredient('W', class_1802.field_19044));
    }

    private static GenericRecipe createFlowerLight(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> FLOWER_LIGHT, () -> FairyLightItems.FLOWER_LIGHT, b -> b.withShape(" I ", "RDB", " Y ").withIngredient('R', class_1802.field_8880).withIngredient('Y', class_1802.field_8491).withIngredient('B', class_1802.field_17499));
    }

    private static GenericRecipe createCandleLanternLight(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> CANDLE_LANTERN_LIGHT, () -> FairyLightItems.CANDLE_LANTERN_LIGHT, b -> b.withShape(" I ", "GDG", "IGI").withIngredient('G', class_1802.field_8397));
    }

    private static GenericRecipe createJackOLantern(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> JACK_O_LANTERN, () -> FairyLightItems.JACK_O_LANTERN, b -> b.withShape(" I ", "SDS", "GPG").withIngredient('S', (class_6862<class_1792>)class_3489.field_15534).withIngredient('G', class_1802.field_8810).withIngredient('P', class_1802.field_8693));
    }

    private static GenericRecipe createSkullLight(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> SKULL_LIGHT, () -> FairyLightItems.SKULL_LIGHT, b -> b.withShape(" I ", "IDI", " B ").withIngredient('B', class_1802.field_8606));
    }

    private static GenericRecipe createGhostLight(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> GHOST_LIGHT, () -> FairyLightItems.GHOST_LIGHT, b -> b.withShape(" I ", "PDP", "IGI").withIngredient('P', class_1802.field_8407).withIngredient('G', class_1802.field_8736));
    }

    private static GenericRecipe createSpiderLight(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> SPIDER_LIGHT, () -> FairyLightItems.SPIDER_LIGHT, b -> b.withShape(" I ", "WDW", "SES").withIngredient('W', class_1802.field_8786).withIngredient('S', class_1802.field_8276).withIngredient('E', class_1802.field_8680));
    }

    private static GenericRecipe createWitchLight(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> WITCH_LIGHT, () -> FairyLightItems.WITCH_LIGHT, b -> b.withShape(" I ", "BDW", " S ").withIngredient('B', class_1802.field_8469).withIngredient('W', class_1802.field_8861).withIngredient('S', class_1802.field_8600));
    }

    private static GenericRecipe createSnowflakeLight(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> SNOWFLAKE_LIGHT, () -> FairyLightItems.SNOWFLAKE_LIGHT, b -> b.withShape(" I ", "SDS", " G ").withIngredient('S', class_1802.field_8543).withIngredient('G', class_1802.field_8736));
    }

    private static GenericRecipe createHeartLight(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> HEART_LIGHT, () -> FairyLightItems.HEART_LIGHT, b -> b.withShape(" I ", "IDI", " G ").withIngredient('G', class_1802.field_8879));
    }

    private static GenericRecipe createMoonLight(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> MOON_LIGHT, () -> FairyLightItems.MOON_LIGHT, b -> b.withShape(" I ", "GDG", " C ").withIngredient('G', class_1802.field_8736).withIngredient('C', class_1802.field_8557));
    }

    private static GenericRecipe createStarLight(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> STAR_LIGHT, () -> FairyLightItems.STAR_LIGHT, b -> b.withShape(" I ", "PDP", " G ").withIngredient('P', class_1802.field_8736).withIngredient('G', class_1802.field_8397));
    }

    private static GenericRecipe createIcicleLights(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> ICICLE_LIGHTS, () -> FairyLightItems.ICICLE_LIGHTS, b -> b.withShape(" I ", "GDG", " B ").withIngredient('G', class_1802.field_8141).withIngredient('B', class_1802.field_8705));
    }

    private static GenericRecipe createMeteorLight(class_2960 name, class_7710 craftingBookCategory) {
        return FairyLightCraftingRecipes.createLight(name, () -> METEOR_LIGHT, () -> FairyLightItems.METEOR_LIGHT, b -> b.withShape(" I ", "GDG", "IPI").withIngredient('G', class_1802.field_8601).withIngredient('P', class_1802.field_8407));
    }

    private static GenericRecipe createLight(class_2960 name, Supplier<? extends class_1865<GenericRecipe>> serializer, Supplier<? extends class_1792> variant, UnaryOperator<GenericRecipeBuilder> recipe) {
        return ((GenericRecipeBuilder)recipe.apply(new GenericRecipeBuilder(name, serializer))).withIngredient('I', class_1802.field_8620).withIngredient('D', DYE_SUBTYPE_INGREDIENT).withOutput(variant.get(), 4).build();
    }

    private static <T extends class_1865<?>> T register(String name, Function<class_2960, T> supplier) {
        class_2960 identifier = class_2960.method_60655((String)"fairylights", (String)name);
        return (T)((class_1865)class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)identifier, (Object)((class_1865)supplier.apply(identifier))));
    }

    public static void initialize() {
        FairyLights.LOGGER.info("Registering items");
    }

    private static class LightIngredient
    extends BasicAuxiliaryIngredient<List<class_1799>> {
        private LightIngredient(boolean isRequired) {
            super(LazyTagIngredient.of(Tags.LIGHTS), isRequired, 8);
        }

        @Override
        public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
            List pattern = (List)output.method_57824(FairyLightItemComponents.PATTERN);
            if (pattern == null || pattern.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder lights = ImmutableList.builder();
            for (class_1799 itemStack : pattern) {
                lights.add((Object)ImmutableList.of((Object)itemStack));
            }
            return lights.build();
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public List<class_1799> accumulator() {
            return new ArrayList<class_1799>();
        }

        @Override
        public void consume(List<class_1799> patternList, class_1799 ingredient) {
            patternList.add(ingredient);
        }

        @Override
        public boolean finish(List<class_1799> pattern, class_9335 comps) {
            if (!pattern.isEmpty()) {
                comps.method_57938(FairyLightItemComponents.PATTERN, Utils.deepCopyList(pattern, class_1799::method_7972));
            }
            return false;
        }

        @Override
        public List<class_5348> getTooltip() {
            return Collections.singletonList(Utils.formatRecipeTooltip("recipe.fairylights.hangingLights.light"));
        }
    }

    private static class PennantIngredient
    extends BasicAuxiliaryIngredient<List<class_1799>> {
        private PennantIngredient() {
            super(LazyTagIngredient.of(Tags.PENNANTS), true, 8);
        }

        @Override
        public ImmutableList<ImmutableList<class_1799>> getInput(class_1799 output) {
            List pattern = (List)output.method_57824(FairyLightItemComponents.PATTERN);
            if (pattern == null || pattern.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder pennants = ImmutableList.builder();
            for (class_1799 itemStack : pattern) {
                pennants.add((Object)ImmutableList.of((Object)itemStack));
            }
            return pennants.build();
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public List<class_1799> accumulator() {
            return new ArrayList<class_1799>();
        }

        @Override
        public void consume(List<class_1799> patternList, class_1799 ingredient) {
            patternList.add(ingredient);
        }

        @Override
        public boolean finish(List<class_1799> pattern, class_9335 comps) {
            if (!pattern.isEmpty()) {
                comps.method_57938(FairyLightItemComponents.PATTERN, Utils.deepCopyList(pattern, class_1799::method_7972));
            }
            return false;
        }

        @Override
        public List<class_5348> getTooltip() {
            return Collections.singletonList(Utils.formatRecipeTooltip("recipe.fairylights.pennantBunting.pennant"));
        }
    }
}

