/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.items.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.lucalabs.fairylights.fastener.FastenerType;
import de.lucalabs.fairylights.fastener.accessor.BlockFastenerAccessor;
import de.lucalabs.fairylights.fastener.accessor.FastenerAccessor;
import de.lucalabs.fairylights.fastener.accessor.FenceFastenerAccessor;
import de.lucalabs.fairylights.fastener.accessor.PlayerFastenerAccessor;
import de.lucalabs.fairylights.items.components.FairyLightItemComponents;
import de.lucalabs.fairylights.string.StringType;
import de.lucalabs.fairylights.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_9323;
import net.minecraft.class_9335;
import org.jetbrains.annotations.NotNull;

public class ComponentRecords {

    public record ConnectionStatus(boolean isOn, boolean drop, float slack, Set<class_2338> litBlocks, FastenerAccessorData destination, ConnectionLogic logic) {
        public static final Codec<ConnectionStatus> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("isOn").forGetter(ConnectionStatus::isOn), (App)Codec.BOOL.fieldOf("drop").forGetter(ConnectionStatus::drop), (App)Codec.FLOAT.fieldOf("slack").forGetter(ConnectionStatus::slack), (App)class_2338.field_25064.listOf().fieldOf("litBlocks").forGetter(x -> x.litBlocks.stream().toList()), (App)FastenerAccessorData.CODEC.fieldOf("destination").forGetter(ConnectionStatus::destination), (App)ConnectionLogic.CODEC.fieldOf("logic").forGetter(ConnectionStatus::logic)).apply((Applicative)i, (o, d, s, l, ds, lo) -> new ConnectionStatus((boolean)o, (boolean)d, s.floatValue(), (Set<class_2338>)new HashSet<class_2338>((Collection<class_2338>)l), (FastenerAccessorData)ds, (ConnectionLogic)lo)));

        public static class Builder {
            private boolean isOn = false;
            private boolean drop = false;
            private float slack = 0.0f;
            @NotNull
            private Set<class_2338> litBlocks = Collections.emptySet();
            @NotNull
            private ConnectionLogic logic = new ConnectionLogic.Builder().build();
            @NotNull
            private FastenerAccessorData accessorData = new FastenerAccessorData(FastenerType.PLAYER, new PlayerFastenerAccessor());

            public Builder slack(float slack) {
                this.slack = slack;
                return this;
            }

            public Builder isOn(boolean isOn) {
                this.isOn = isOn;
                return this;
            }

            public Builder drop(boolean drop) {
                this.drop = drop;
                return this;
            }

            public Builder logic(ConnectionLogic logic) {
                this.logic = logic;
                return this;
            }

            public Builder destination(FastenerAccessor accessor) {
                this.accessorData = new FastenerAccessorData(accessor.getType(), accessor);
                return this;
            }

            public Builder litBlocks(Set<class_2338> litBlocks) {
                this.litBlocks = litBlocks;
                return this;
            }

            public ConnectionStatus build() {
                return new ConnectionStatus(this.isOn, this.drop, this.slack, this.litBlocks, this.accessorData, this.logic);
            }
        }
    }

    public record FastenerAccessorData(FastenerType type, FastenerAccessor accessor) {
        public static final Codec<FastenerAccessorData> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2487.field_25128.fieldOf("accessor").forGetter(data -> data.accessor().serialize()), (App)Codec.INT.fieldOf("type").forGetter(data -> data.type.ordinal())).apply((Applicative)i, (data, t) -> {
            FastenerType type = Utils.getEnumValue(FastenerType.class, t);
            FastenerAccessor accessor = switch (type) {
                default -> throw new MatchException(null, null);
                case FastenerType.BLOCK -> new BlockFastenerAccessor();
                case FastenerType.FENCE -> new FenceFastenerAccessor();
                case FastenerType.PLAYER -> new PlayerFastenerAccessor();
            };
            accessor.deserialize((class_2487)data);
            return new FastenerAccessorData(type, accessor);
        }));

        public static FastenerAccessorData from(FastenerAccessor accessor) {
            return new FastenerAccessorData(accessor.getType(), accessor);
        }
    }

    public record ConnectionLogic(List<class_1799> pattern, Optional<StringType> string, Optional<Integer> color) {
        public static final Codec<ConnectionLogic> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.listOf().fieldOf("pattern").forGetter(ConnectionLogic::pattern), (App)StringType.CODEC.optionalFieldOf("string").forGetter(ConnectionLogic::string), (App)Codec.INT.optionalFieldOf("color").forGetter(ConnectionLogic::color)).apply((Applicative)instance, ConnectionLogic::new));

        public class_9335 toComponents() {
            class_9335 comps = new class_9335(class_9323.field_49584);
            comps.method_57938(FairyLightItemComponents.PATTERN, this.pattern());
            this.string.ifPresent(string -> comps.method_57938(FairyLightItemComponents.STRING, string));
            return comps;
        }

        public boolean matchesItemStack(class_1799 stack) {
            Optional<Integer> stackColor = Optional.ofNullable((Integer)stack.method_57824(FairyLightItemComponents.COLOR));
            Optional<StringType> stackString = Optional.ofNullable((StringType)stack.method_57824(FairyLightItemComponents.STRING));
            List pattern = Objects.requireNonNullElse((List)stack.method_57824(FairyLightItemComponents.PATTERN), Collections.emptyList());
            boolean patternEqual = this.pattern().size() == pattern.size() && IntStream.range(0, pattern.size()).allMatch(i -> class_1799.method_31577((class_1799)((class_1799)pattern.get(i)), (class_1799)this.pattern().get(i)));
            return this.string().equals(stackString) && this.color().equals(stackColor) && patternEqual;
        }

        public static ConnectionLogic fromItemStack(class_1799 i) {
            Builder b = new Builder();
            if (i.method_57826(FairyLightItemComponents.STRING)) {
                b.stringType((StringType)i.method_57824(FairyLightItemComponents.STRING));
            }
            if (i.method_57826(FairyLightItemComponents.PATTERN)) {
                b.pattern((List)i.method_57824(FairyLightItemComponents.PATTERN));
            }
            if (i.method_57826(FairyLightItemComponents.COLOR)) {
                b.color((Integer)i.method_57824(FairyLightItemComponents.COLOR));
            }
            return b.build();
        }

        public static class Builder {
            @NotNull
            private List<class_1799> pattern = Collections.emptyList();
            @NotNull
            private Optional<StringType> string = Optional.empty();
            @NotNull
            private Optional<Integer> color = Optional.empty();

            public Builder pattern(List<class_1799> pattern) {
                this.pattern = pattern;
                return this;
            }

            public Builder stringType(StringType string) {
                this.string = Optional.of(string);
                return this;
            }

            public Builder color(int color) {
                this.color = Optional.of(color);
                return this;
            }

            public ConnectionLogic build() {
                return new ConnectionLogic(this.pattern, this.string, this.color);
            }
        }
    }
}

