/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.items;

import de.lucalabs.fairylights.feature.light.BrightnessLightBehavior;
import de.lucalabs.fairylights.feature.light.ColorChangingBehavior;
import de.lucalabs.fairylights.feature.light.ColorLightBehavior;
import de.lucalabs.fairylights.feature.light.CompositeBehavior;
import de.lucalabs.fairylights.feature.light.DefaultBrightnessBehavior;
import de.lucalabs.fairylights.feature.light.FixedColorBehavior;
import de.lucalabs.fairylights.feature.light.IncandescentBehavior;
import de.lucalabs.fairylights.feature.light.LightBehavior;
import de.lucalabs.fairylights.feature.light.MeteorLightBehavior;
import de.lucalabs.fairylights.feature.light.MultiLightBehavior;
import de.lucalabs.fairylights.feature.light.StandardLightBehavior;
import de.lucalabs.fairylights.feature.light.TorchLightBehavior;
import de.lucalabs.fairylights.feature.light.TwinkleBehavior;
import de.lucalabs.fairylights.items.LightVariant;
import de.lucalabs.fairylights.items.components.FairyLightItemComponents;
import de.lucalabs.fairylights.registries.FairyLightRegistries;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2960;

public class SimpleLightVariant<T extends LightBehavior>
extends LightVariant<T> {
    public static final LightVariant<StandardLightBehavior> FAIRY_LIGHT = SimpleLightVariant.getRegistered("var_fairy_light", true, 1.0f, new class_238(-0.138, -0.138, -0.138, 0.138, 0.138, 0.138), 0.044, SimpleLightVariant::standardBehavior, true);
    public static final LightVariant<StandardLightBehavior> PAPER_LANTERN = SimpleLightVariant.getRegistered("var_paper_lantern", false, 1.0f, new class_238(-0.25, -0.906, -0.25, 0.25, 0.091, 0.25), 0.0, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> ORB_LANTERN = SimpleLightVariant.getRegistered("var_orb_lantern", false, 1.0f, new class_238(-0.262, -0.512, -0.262, 0.262, 0.091, 0.262), 0.044, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> FLOWER_LIGHT = SimpleLightVariant.getRegistered("var_flower_light", true, 1.0f, new class_238(-0.483, -0.227, -0.483, 0.436, 0.185, 0.436), 0.069, SimpleLightVariant::standardBehavior, true);
    public static final LightVariant<StandardLightBehavior> CANDLE_LANTERN_LIGHT = SimpleLightVariant.getRegistered("var_candle_lantern", false, 1.5f, new class_238(-0.198, -0.531, -0.198, 0.198, 0.091, 0.198), 0.0, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> JACK_O_LANTERN = SimpleLightVariant.getRegistered("var_jack_o_lantern", true, 1.0f, new class_238(-0.231, -0.419, -0.231, 0.231, 0.122, 0.231), 0.044, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> SKULL_LIGHT = SimpleLightVariant.getRegistered("var_skull_light", true, 1.0f, new class_238(-0.2, -0.404, -0.2, 0.2, 0.122, 0.2), 0.044, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> GHOST_LIGHT = SimpleLightVariant.getRegistered("var_ghost_light", true, 1.0f, new class_238(-0.27, -0.39, -0.27, 0.27, 0.169, 0.27), 0.075, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> SPIDER_LIGHT = SimpleLightVariant.getRegistered("var_spider_light", true, 1.0f, new class_238(-0.575, -0.834, -0.2, 0.575, 0.122, 0.2), 0.06, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> WITCH_LIGHT = SimpleLightVariant.getRegistered("var_witch_light", true, 1.0f, new class_238(-0.294, -0.419, -0.294, 0.294, 0.173, 0.294), 0.044, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> SNOWFLAKE_LIGHT = SimpleLightVariant.getRegistered("var_snowflake_light", true, 1.0f, new class_238(-0.518, -1.05, -0.082, 0.517, 0.072, 0.082), 0.044, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> HEART_LIGHT = SimpleLightVariant.getRegistered("var_heart_light", true, 1.0f, new class_238(-0.28, -0.408, -0.106, 0.274, 0.063, 0.106), 0.062, SimpleLightVariant::standardBehavior, true);
    public static final LightVariant<StandardLightBehavior> MOON_LIGHT = SimpleLightVariant.getRegistered("var_moon_light", true, 1.0f, new class_238(-0.2, -0.669, -0.144, 0.3, 0.063, 0.144), 0.044, SimpleLightVariant::standardBehavior, true);
    public static final LightVariant<StandardLightBehavior> STAR_LIGHT = SimpleLightVariant.getRegistered("var_star_light", true, 1.0f, new class_238(-0.2, -0.669, -0.144, 0.3, 0.063, 0.144), 0.044, SimpleLightVariant::standardBehavior, true);
    public static final LightVariant<MultiLightBehavior> ICICLE_LIGHTS = SimpleLightVariant.getRegistered("var_icicle_lights", false, 0.625f, new class_238(-0.264, -1.032, -0.253, 0.276, 0.091, 0.266), 0.012, stack -> MultiLightBehavior.create(4, () -> SimpleLightVariant.standardBehavior(stack)));
    public static final LightVariant<MeteorLightBehavior> METEOR_LIGHT = SimpleLightVariant.getRegistered("var_meteor_light", false, 1.5f, new class_238(-0.09, -1.588, -0.09, 0.09, 0.091, 0.09), 0.0, stack -> {
        ColorLightBehavior color = ColorChangingBehavior.exists(stack) ? ColorChangingBehavior.create(stack) : FixedColorBehavior.create(stack);
        return new MeteorLightBehavior(color);
    });
    public static final LightVariant<BrightnessLightBehavior> CANDLE_LANTERN = SimpleLightVariant.getRegistered("var_candle_lantern", false, 1.5f, new class_238(-0.198, -0.531, -0.198, 0.198, 0.091, 0.198), 0.0, stack -> new TorchLightBehavior(0.2));
    public static final LightVariant<BrightnessLightBehavior> OIL_LANTERN = SimpleLightVariant.getRegistered("var_oil_lantern", false, 1.5f, new class_238(-0.219, -0.656, -0.188, 0.219, 0.091, 0.188), 0.0, stack -> new TorchLightBehavior(0.13));
    public static final LightVariant<BrightnessLightBehavior> INCANDESCENT_LIGHT = SimpleLightVariant.getRegistered("var_incandescent", true, 1.0f, new class_238(-0.166, -0.291, -0.166, 0.166, 0.062, 0.166), 0.103, stack -> new IncandescentBehavior(), true);
    private final class_2960 id;
    private final boolean parallelsCord;
    private final float spacing;
    private final class_238 bounds;
    private final double floorOffset;
    private final Function<class_1799, T> behaviorFactory;
    private final boolean orientable;

    SimpleLightVariant(class_2960 id, boolean parallelsCord, float spacing, class_238 bounds, double floorOffset, Function<class_1799, T> behaviorFactory) {
        this(id, parallelsCord, spacing, bounds, floorOffset, behaviorFactory, false);
    }

    SimpleLightVariant(class_2960 id, boolean parallelsCord, float spacing, class_238 bounds, double floorOffset, Function<class_1799, T> behaviorFactory, boolean orientable) {
        this.id = id;
        this.parallelsCord = parallelsCord;
        this.spacing = spacing;
        this.bounds = bounds;
        this.floorOffset = floorOffset;
        this.behaviorFactory = behaviorFactory;
        this.orientable = orientable;
    }

    public static LightVariant<?> getLightVariantOrDefault(class_1799 i) {
        LightVariant variant = LightVariant.getLightVariant((class_2960)i.method_57824(FairyLightItemComponents.LIGHT_VARIANT));
        return Objects.requireNonNullElse(variant, FAIRY_LIGHT);
    }

    private static StandardLightBehavior standardBehavior(class_1799 stack) {
        BrightnessLightBehavior brightness = TwinkleBehavior.exists(stack) ? new TwinkleBehavior(0.05f, 40) : new DefaultBrightnessBehavior();
        ColorLightBehavior color = ColorChangingBehavior.exists(stack) ? ColorChangingBehavior.create(stack) : FixedColorBehavior.create(stack);
        return new CompositeBehavior(brightness, color);
    }

    private static <T extends LightBehavior> LightVariant<T> getRegistered(String id, boolean parallelsCord, float spacing, class_238 bounds, double floorOffset, Function<class_1799, T> behaviorFactory) {
        return SimpleLightVariant.getRegistered(id, parallelsCord, spacing, bounds, floorOffset, behaviorFactory, false);
    }

    private static <T extends LightBehavior> LightVariant<T> getRegistered(String id, boolean parallelsCord, float spacing, class_238 bounds, double floorOffset, Function<class_1799, T> behaviorFactory, boolean orientable) {
        class_2960 identifier = class_2960.method_60655((String)"fairylights", (String)id);
        return (LightVariant)class_2378.method_10230(FairyLightRegistries.LIGHT_VARIANTS, (class_2960)identifier, new SimpleLightVariant<T>(identifier, parallelsCord, spacing, bounds, floorOffset, behaviorFactory, orientable));
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public boolean parallelsCord() {
        return this.parallelsCord;
    }

    @Override
    public float getSpacing() {
        return this.spacing;
    }

    @Override
    public class_238 getBounds() {
        return this.bounds;
    }

    @Override
    public double getFloorOffset() {
        return this.floorOffset;
    }

    @Override
    public T createBehavior(class_1799 stack) {
        return (T)((LightBehavior)this.behaviorFactory.apply(stack));
    }

    @Override
    public boolean isOrientable() {
        return this.orientable;
    }
}

