/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.items;

import de.lucalabs.fairylights.feature.light.ColorChangingBehavior;
import de.lucalabs.fairylights.items.DyeableItem;
import de.lucalabs.fairylights.items.FairyLightItems;
import de.lucalabs.fairylights.items.components.FairyLightItemComponents;
import de.lucalabs.fairylights.string.StringType;
import de.lucalabs.fairylights.string.StringTypes;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;

@Environment(value=EnvType.CLIENT)
public final class ItemColorManager {
    private static final class_1792[] COLORABLE_LIGHTS = new class_1792[]{FairyLightItems.FAIRY_LIGHT, FairyLightItems.PAPER_LANTERN, FairyLightItems.ORB_LANTERN, FairyLightItems.FLOWER_LIGHT, FairyLightItems.CANDLE_LANTERN_LIGHT, FairyLightItems.JACK_O_LANTERN, FairyLightItems.SKULL_LIGHT, FairyLightItems.GHOST_LIGHT, FairyLightItems.SPIDER_LIGHT, FairyLightItems.WITCH_LIGHT, FairyLightItems.SNOWFLAKE_LIGHT, FairyLightItems.HEART_LIGHT, FairyLightItems.MOON_LIGHT, FairyLightItems.STAR_LIGHT, FairyLightItems.ICICLE_LIGHTS, FairyLightItems.METEOR_LIGHT};
    private static final class_1792[] HANGING_LIGHTS_LINES = new class_1792[]{FairyLightItems.HANGING_LIGHTS};
    private static final class_1792[] PENNANT_BUNTING_LINES = new class_1792[]{FairyLightItems.PENNANT_BUNTING};
    private static final class_1792[] PENNANTS = new class_1792[]{FairyLightItems.TRIANGLE_PENNANT, FairyLightItems.SQUARE_PENNANT};

    private ItemColorManager() {
    }

    public static void setupColors() {
        ColorProviderRegistry.ITEM.register((stack, index) -> {
            if (index == 1) {
                if (ColorChangingBehavior.exists(stack)) {
                    return ColorChangingBehavior.animate(stack);
                }
                return DyeableItem.getColor(stack);
            }
            return -1;
        }, (Object[])COLORABLE_LIGHTS);
        ColorProviderRegistry.ITEM.register((stack, index) -> index == 0 ? DyeableItem.getColor(stack) : -1, (Object[])new class_1935[]{FairyLightItems.TINSEL});
        ColorProviderRegistry.ITEM.register((stack, index) -> {
            if (index == 0) {
                if (stack.method_57826(FairyLightItemComponents.STRING)) {
                    return Objects.requireNonNull((StringType)stack.method_57824(FairyLightItemComponents.STRING)).color();
                }
                return StringTypes.BLACK_STRING.color();
            }
            List pattern = (List)stack.method_57824(FairyLightItemComponents.PATTERN);
            if (pattern != null && !pattern.isEmpty()) {
                class_1799 stack2 = (class_1799)pattern.get((index - 1) % pattern.size());
                if (ColorChangingBehavior.exists(stack2)) {
                    return ColorChangingBehavior.animate(stack2);
                }
                return DyeableItem.getColor(stack2);
            }
            return -10876;
        }, (Object[])HANGING_LIGHTS_LINES);
        ColorProviderRegistry.ITEM.register((stack, index) -> {
            if (index == 0) {
                return -1;
            }
            List pattern = (List)stack.method_57824(FairyLightItemComponents.PATTERN);
            if (pattern != null && !pattern.isEmpty()) {
                class_1799 light = (class_1799)pattern.get((index - 1) % pattern.size());
                return DyeableItem.getColor(light);
            }
            return -1;
        }, (Object[])PENNANT_BUNTING_LINES);
        ColorProviderRegistry.ITEM.register((stack, index) -> index == 0 ? 0xFFFFFF : DyeableItem.getColor(stack), (Object[])PENNANTS);
    }
}

