/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.items;

import de.lucalabs.fairylights.items.components.FairyLightItemComponents;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class DyeableItem {
    private DyeableItem() {
    }

    public static class_2561 getColorName(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        class_1767 closest = class_1767.field_7952;
        int closestDist = Integer.MAX_VALUE;
        for (class_1767 dye : class_1767.values()) {
            int dyeColor = DyeableItem.getColor(dye);
            if (dyeColor == color) {
                closest = dye;
                closestDist = 0;
                break;
            }
            int dr = dyeColor >> 16 & 0xFF;
            int dg = dyeColor >> 8 & 0xFF;
            int db = dyeColor & 0xFF;
            int dist = (dr - r) * (dr - r) + (dg - g) * (dg - g) + (db - b) * (db - b);
            if (dist >= closestDist) continue;
            closest = dye;
            closestDist = dist;
        }
        class_5250 colorName = class_2561.method_43471((String)("color.fairylights." + closest.method_7792()));
        return closestDist == 0 ? colorName : class_2561.method_43469((String)"format.fairylights.dyed_colored", (Object[])new Object[]{colorName});
    }

    public static class_2561 getDisplayName(class_1799 stack, class_2561 name) {
        return class_2561.method_43469((String)"format.fairylights.colored", (Object[])new Object[]{DyeableItem.getColorName(DyeableItem.getColor(stack)), name});
    }

    public static int getColor(class_1767 color) {
        if (color == class_1767.field_7963) {
            return -13487566;
        }
        if (color == class_1767.field_7944) {
            return -10461088;
        }
        return color.method_7787();
    }

    public static Optional<class_1767> getDyeColor(class_1799 stack) {
        int color = DyeableItem.getColor(stack);
        return Arrays.stream(class_1767.values()).filter(dye -> DyeableItem.getColor(dye) == color).findFirst();
    }

    public static class_1799 setColor(class_1799 stack, class_1767 dye) {
        stack.method_57379(FairyLightItemComponents.COLOR, (Object)DyeableItem.getColor(dye));
        return stack;
    }

    public static class_1799 setColor(class_1799 stack, int color) {
        stack.method_57379(FairyLightItemComponents.COLOR, (Object)color);
        return stack;
    }

    public static int getColor(class_1799 stack) {
        return Objects.requireNonNullElse((Integer)stack.method_57824(FairyLightItemComponents.COLOR), -1);
    }

    public static int getColor(class_2487 tag) {
        return tag.method_10573("color", 3) ? tag.method_10550("color") : -1;
    }
}

