/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.items;

import de.lucalabs.fairylights.blocks.FairyLightBlocks;
import de.lucalabs.fairylights.blocks.FastenerBlock;
import de.lucalabs.fairylights.components.FairyLightComponents;
import de.lucalabs.fairylights.components.FastenerComponent;
import de.lucalabs.fairylights.connection.Connection;
import de.lucalabs.fairylights.connection.ConnectionType;
import de.lucalabs.fairylights.entity.FenceFastenerEntity;
import de.lucalabs.fairylights.fastener.Fastener;
import de.lucalabs.fairylights.items.components.ComponentRecords;
import de.lucalabs.fairylights.sounds.FairyLightSounds;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_4538;

public abstract class ConnectionItem
extends class_1792 {
    private final ConnectionType<?> type;

    public ConnectionItem(class_1792.class_1793 properties, ConnectionType<?> type) {
        super(properties);
        this.type = type;
    }

    public static boolean isFence(class_2680 state) {
        return state.method_51367() && state.method_26164(class_3481.field_16584);
    }

    public final ConnectionType<?> getConnectionType() {
        return this.type;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1530 entity;
        class_1657 user = context.method_8036();
        if (user == null) {
            return super.method_7884(context);
        }
        class_1937 world = context.method_8045();
        class_2350 side = context.method_8038();
        class_2338 clickPos = context.method_8037();
        class_1799 stack = context.method_8041();
        if (this.isConnectionInOtherHand(world, user, stack)) {
            return class_1269.field_5811;
        }
        class_2680 fastenerState = (class_2680)FairyLightBlocks.FASTENER.method_9564().method_11657((class_2769)FastenerBlock.field_10927, (Comparable)side);
        class_2680 currentBlockState = world.method_8320(clickPos);
        class_1750 blockContext = new class_1750(context);
        class_2338 placePos = blockContext.method_8037();
        if (currentBlockState.method_26204() == FairyLightBlocks.FASTENER) {
            if (!world.method_8608()) {
                this.connect(stack, user, world, clickPos);
            }
            return class_1269.field_5812;
        }
        if (blockContext.method_7716() && fastenerState.method_26184((class_4538)world, placePos)) {
            if (!world.method_8608()) {
                this.connect(stack, user, world, placePos, fastenerState);
            }
            return class_1269.field_5812;
        }
        if (ConnectionItem.isFence(currentBlockState) && ((entity = FenceFastenerEntity.findHanging(world, clickPos)) == null || entity instanceof FenceFastenerEntity)) {
            if (!world.method_8608()) {
                this.connectFence(stack, user, world, clickPos, (FenceFastenerEntity)entity);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private boolean isConnectionInOtherHand(class_1937 world, class_1657 user, class_1799 stack) {
        Fastener attacher = (Fastener)((FastenerComponent)FairyLightComponents.FASTENER.get((Object)user)).get().orElseThrow(IllegalStateException::new);
        return attacher.getFirstConnection().filter(connection -> !connection.serializeLogic().build().matchesItemStack(stack)).isPresent();
    }

    private void connect(class_1799 stack, class_1657 user, class_1937 world, class_2338 pos) {
        class_2586 entity = world.method_8321(pos);
        if (entity != null) {
            ((FastenerComponent)FairyLightComponents.FASTENER.get((Object)entity)).get().ifPresent(fastener -> this.connect(stack, user, world, (Fastener<?>)fastener));
        }
    }

    private void connect(class_1799 stack, class_1657 user, class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8652(pos, state, 3)) {
            state.method_26204().method_9567(world, pos, state, (class_1309)user, stack);
            class_2498 sound = state.method_26231();
            world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, sound.method_10598(), class_3419.field_15245, (sound.method_10597() + 1.0f) / 2.0f, sound.method_10599() * 0.8f);
            class_2586 entity = world.method_8321(pos);
            if (entity != null) {
                ((FastenerComponent)FairyLightComponents.FASTENER.get((Object)entity)).get().ifPresent(destination -> this.connect(stack, user, world, (Fastener<?>)destination, false));
            }
        }
    }

    public void connect(class_1799 stack, class_1657 user, class_1937 world, Fastener<?> fastener) {
        this.connect(stack, user, world, fastener, true);
    }

    public void connect(class_1799 stack, class_1657 user, class_1937 world, Fastener<?> fastener, boolean playConnectSound) {
        ((FastenerComponent)FairyLightComponents.FASTENER.get((Object)user)).get().ifPresent(attacher -> {
            boolean playSound = playConnectSound;
            Optional<Connection> placing = attacher.getFirstConnection();
            if (placing.isPresent()) {
                Connection conn = placing.get();
                if (conn.reconnect(fastener)) {
                    conn.onConnect(world, user, stack);
                    stack.method_7934(1);
                } else {
                    playSound = false;
                }
                attacher.removeConnection(placing.get());
            } else {
                fastener.connect(world, (Fastener<?>)attacher, this.getConnectionType(), ComponentRecords.ConnectionLogic.fromItemStack(stack), false);
            }
            if (playSound) {
                class_243 pos = fastener.getConnectionPoint();
                world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, FairyLightSounds.CORD_CONNECT, class_3419.field_15245, 1.0f, 1.0f);
            }
        });
    }

    private void connectFence(class_1799 stack, class_1657 user, class_1937 world, class_2338 pos, FenceFastenerEntity fastener) {
        boolean playConnectSound;
        if (fastener == null) {
            fastener = FenceFastenerEntity.create(world, pos);
            playConnectSound = false;
        } else {
            playConnectSound = true;
        }
        this.connect(stack, user, world, (Fastener)((FastenerComponent)FairyLightComponents.FASTENER.get((Object)fastener)).get().orElseThrow(IllegalStateException::new), playConnectSound);
    }
}

