/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.integrations.jei;

import com.google.common.collect.ImmutableList;
import de.lucalabs.fairylights.items.crafting.GenericIngredient;
import de.lucalabs.fairylights.items.crafting.GenericRecipe;
import de.lucalabs.fairylights.items.crafting.RegularIngredient;
import de.lucalabs.fairylights.items.crafting.ingredient.AuxiliaryIngredient;
import de.lucalabs.fairylights.util.MathHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_8786;
import net.minecraft.class_9694;

@Environment(value=EnvType.CLIENT)
public final class GenericRecipeWrapper
implements ICraftingCategoryExtension<GenericRecipe> {
    private GenericRecipe recipe;
    private List<List<class_1799>> allInputs;
    private List<List<class_1799>> minimalInputStacks;
    private List<class_1799> outputs;
    private GenericIngredient<?, ?>[] ingredientMatrix;
    private int subtypeIndex;

    private void setupForRecipe(GenericRecipe recipe) {
        this.recipe = recipe;
        ArrayList<List<class_1799>> allInputs = new ArrayList<List<class_1799>>();
        ArrayList<List<class_1799>> minimalInputStacks = new ArrayList<List<class_1799>>();
        RegularIngredient[] ingredients = recipe.getGenericIngredients();
        AuxiliaryIngredient<?>[] aux = recipe.getAuxiliaryIngredients();
        this.ingredientMatrix = new GenericIngredient[9];
        int subtypeIndex = -1;
        int auxIdx = 0;
        for (int i = 0; i < 9; ++i) {
            GenericIngredient<RegularIngredient, GenericRecipe.MatchResultRegular> ingredient;
            ImmutableList<class_1799> ingInputs;
            int x = i % 3;
            int y = i / 3;
            boolean isEmpty = true;
            if (x < recipe.getWidth() && y < recipe.getHeight() && !(ingInputs = (ingredient = ingredients[x + y * recipe.getWidth()]).getInputs()).isEmpty()) {
                if (ingredient.dictatesOutputType()) {
                    minimalInputStacks.add((List<class_1799>)ingInputs);
                    subtypeIndex = i;
                } else {
                    minimalInputStacks.add((List<class_1799>)ImmutableList.of((Object)((class_1799)ingInputs.get(0))));
                }
                this.ingredientMatrix[i] = ingredient;
                allInputs.add((List<class_1799>)ingInputs);
                isEmpty = false;
            }
            if (!isEmpty) continue;
            ingredient = null;
            ImmutableList stacks = null;
            boolean dictator = false;
            while (auxIdx < aux.length) {
                ImmutableList a;
                if ((a = (ingredient = aux[auxIdx++]).getInputs()).isEmpty()) continue;
                stacks = a;
                if (!ingredient.dictatesOutputType()) break;
                subtypeIndex = i;
                dictator = true;
                break;
            }
            if (stacks == null) {
                stacks = ImmutableList.of();
                ingredient = null;
            }
            minimalInputStacks.add((List<class_1799>)(stacks.isEmpty() || dictator ? stacks : ImmutableList.of((Object)((class_1799)stacks.get(0)))));
            this.ingredientMatrix[i] = ingredient;
            allInputs.add((List<class_1799>)stacks);
        }
        this.allInputs = allInputs;
        this.minimalInputStacks = minimalInputStacks;
        this.subtypeIndex = subtypeIndex;
        ImmutableList.Builder outputs = ImmutableList.builder();
        this.forOutputMatches((v, output) -> outputs.add(output));
        this.outputs = outputs.build();
    }

    private void forOutputMatches(BiConsumer<class_1799, class_1799> outputConsumer) {
        ArrayList<class_1799> ingredients = new ArrayList<class_1799>();
        if (this.subtypeIndex == -1) {
            for (int i = 0; i < this.minimalInputStacks.size(); ++i) {
                List<class_1799> stacks = this.minimalInputStacks.get(i);
                ingredients.set(i, stacks.isEmpty() ? class_1799.field_8037 : stacks.getFirst());
            }
            class_9694 crafting = class_9694.method_59986((int)3, (int)3, ingredients);
            if (this.recipe.matches(crafting, null)) {
                outputConsumer.accept(class_1799.field_8037, this.recipe.craft(crafting, null));
            }
        } else {
            List<class_1799> dictators = this.minimalInputStacks.get(this.subtypeIndex);
            for (class_1799 subtype : dictators) {
                for (int i = 0; i < this.minimalInputStacks.size(); ++i) {
                    if (i == this.subtypeIndex) {
                        ingredients.set(i, subtype);
                        continue;
                    }
                    List<class_1799> stacks = this.minimalInputStacks.get(i);
                    ingredients.set(i, stacks.isEmpty() ? class_1799.field_8037 : stacks.get(0));
                }
                class_9694 crafting = class_9694.method_59986((int)3, (int)3, ingredients);
                if (!this.recipe.matches(crafting, null)) continue;
                outputConsumer.accept(subtype, this.recipe.craft(crafting, null));
            }
        }
    }

    public int getWidth(class_8786<GenericRecipe> entry) {
        return 3;
    }

    public int getHeight(class_8786<GenericRecipe> entry) {
        return 3;
    }

    private Input getInputsForOutput(class_1799 output) {
        RegularIngredient[] ingredients = this.recipe.getGenericIngredients();
        ArrayList<List<class_1799>> inputs = new ArrayList<List<class_1799>>(9);
        GenericIngredient[] ingredientMat = new GenericIngredient[9];
        AuxiliaryIngredient<?>[] aux = this.recipe.getAuxiliaryIngredients();
        int auxIngIdx = 0;
        int auxIdx = 0;
        for (int i = 0; i < 9; ++i) {
            ImmutableList<ImmutableList<class_1799>> ingInputs;
            int x = i % 3;
            int y = i / 3;
            RegularIngredient ingredient = null;
            if (x < this.recipe.getWidth() && y < this.recipe.getHeight()) {
                ingredient = ingredients[x + y * this.recipe.getWidth()];
                ingInputs = ingredient.getInput(output);
            } else {
                ingInputs = null;
            }
            if (ingInputs == null || ingInputs.isEmpty()) {
                boolean isEmpty = true;
                if (auxIngIdx < aux.length) {
                    ImmutableList<ImmutableList<class_1799>> auxInputs = null;
                    AuxiliaryIngredient<?> ingredientAux = null;
                    while (auxIngIdx < aux.length && (auxInputs = (ingredientAux = aux[auxIngIdx]).getInput(output)).isEmpty()) {
                        ++auxIngIdx;
                    }
                    if (!auxInputs.isEmpty()) {
                        inputs.add((List)auxInputs.get(auxIdx++));
                        ingredientMat[i] = ingredientAux;
                        if (auxIdx == auxInputs.size()) {
                            auxIdx = 0;
                            ++auxIngIdx;
                        }
                        isEmpty = false;
                    }
                }
                if (!isEmpty) continue;
                inputs.add(Collections.emptyList());
                continue;
            }
            inputs.add((List)ingInputs.get(0));
            ingredientMat[i] = ingredient;
        }
        return new Input(inputs, ingredientMat);
    }

    private Input getInputsForIngredient(class_1799 ingredient) {
        for (int i = 0; i < this.allInputs.size(); ++i) {
            List<class_1799> options = this.allInputs.get(i);
            class_1799 matched = null;
            for (class_1799 o : options) {
                if (ingredient.method_7909() != o.method_7909()) continue;
                matched = ingredient.method_7972();
                matched.method_7939(1);
                break;
            }
            if (matched == null) continue;
            ArrayList<class_1799> ingredients = new ArrayList<class_1799>();
            for (int n = 0; n < this.minimalInputStacks.size(); ++n) {
                List<class_1799> stacks = this.minimalInputStacks.get(n);
                ingredients.set(n, i == n ? matched : (stacks.isEmpty() ? class_1799.field_8037 : stacks.get(0)));
            }
            class_9694 crafting = class_9694.method_59986((int)3, (int)3, ingredients);
            if (!this.recipe.matches(crafting, null)) continue;
            ArrayList<List<class_1799>> inputs = new ArrayList<List<class_1799>>(this.allInputs.size());
            for (int n = 0; n < this.allInputs.size(); ++n) {
                List<class_1799> stacks = this.allInputs.get(n);
                inputs.add(i == n ? Collections.singletonList(matched) : stacks);
            }
            return new Input(inputs, this.ingredientMatrix);
        }
        return null;
    }

    public List<class_1799> getOutput(List<List<class_1799>> inputs) {
        int size = 1;
        for (List<class_1799> stack : inputs) {
            if (stack.isEmpty()) continue;
            size = MathHelper.lcm(stack.size(), size);
        }
        ArrayList<class_1799> outputs = new ArrayList<class_1799>(size);
        ArrayList<class_1799> ingredients = new ArrayList<class_1799>();
        for (int n = 0; n < size; ++n) {
            for (int i = 0; i < inputs.size(); ++i) {
                List<class_1799> stacks = inputs.get(i);
                ingredients.set(i, stacks.isEmpty() ? class_1799.field_8037 : stacks.get(n % stacks.size()));
            }
            class_9694 crafting = class_9694.method_59986((int)3, (int)3, ingredients);
            if (!this.recipe.matches(crafting, null)) continue;
            outputs.add(this.recipe.craft(crafting, null));
        }
        return outputs;
    }

    public void setRecipe(class_8786<GenericRecipe> holder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        this.setupForRecipe((GenericRecipe)holder.comp_1933());
        focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).flatMap(focus -> {
            class_1799 stack = (class_1799)focus.getTypedValue().getIngredient();
            Input input = null;
            if (focus.getRole() == RecipeIngredientRole.INPUT) {
                input = this.getInputsForIngredient(stack);
            } else if (focus.getRole() == RecipeIngredientRole.OUTPUT) {
                input = this.getInputsForOutput(stack);
            }
            return Stream.ofNullable(input);
        }).findFirst().ifPresentOrElse(input -> {
            craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, this.getOutput(input.inputs));
            List slots = craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, input.inputs, 3, 3);
            for (int i = 0; i < 9; ++i) {
                GenericIngredient<?, ?> ingredient = input.ingredients[i];
                IRecipeSlotBuilder slot = (IRecipeSlotBuilder)slots.get(i);
                slot.addRichTooltipCallback((recipeSlotView, tooltip) -> {
                    if (recipeSlotView.getRole() == RecipeIngredientRole.INPUT) {
                        tooltip.addAll(ingredient.getTooltip());
                    }
                });
            }
        }, () -> {
            craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, this.outputs);
            craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, this.allInputs, 3, 3);
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static final class Input {
        List<List<class_1799>> inputs;
        GenericIngredient<?, ?>[] ingredients;

        private Input(List<List<class_1799>> inputs, GenericIngredient<?, ?>[] ingredients) {
            this.inputs = inputs;
            this.ingredients = ingredients;
        }
    }
}

