/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.feature.light;

import com.google.common.collect.ImmutableList;
import de.lucalabs.fairylights.feature.light.DefaultBehavior;
import de.lucalabs.fairylights.feature.light.Light;
import de.lucalabs.fairylights.feature.light.LightBehavior;
import de.lucalabs.fairylights.feature.light.StandardLightBehavior;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_243;

public class MultiLightBehavior
implements LightBehavior {
    private final ImmutableList<StandardLightBehavior> lights;
    private final DefaultBehavior fallback;

    public MultiLightBehavior(ImmutableList<StandardLightBehavior> lights) {
        this.lights = lights;
        this.fallback = new DefaultBehavior(1.0f, 1.0f, 1.0f);
    }

    public StandardLightBehavior get(int index) {
        if (index >= 0 && index < this.lights.size()) {
            return (StandardLightBehavior)this.lights.get(index);
        }
        return this.fallback;
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
        for (StandardLightBehavior behvior : this.lights) {
            behvior.power(powered, now, light);
        }
        this.fallback.power(powered, now, light);
    }

    @Override
    public void tick(class_1937 world, class_243 origin, Light<?> light) {
        for (StandardLightBehavior behavior : this.lights) {
            behavior.tick(world, origin, light);
        }
        this.fallback.tick(world, origin, light);
    }

    public static MultiLightBehavior create(int count, Supplier<StandardLightBehavior> factory) {
        ImmutableList.Builder behaviors = new ImmutableList.Builder();
        for (int n = 0; n < count; ++n) {
            behaviors.add((Object)factory.get());
        }
        return new MultiLightBehavior((ImmutableList<StandardLightBehavior>)behaviors.build());
    }
}

