/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.feature.light;

import de.lucalabs.fairylights.feature.HangingFeature;
import de.lucalabs.fairylights.feature.light.LightBehavior;
import de.lucalabs.fairylights.items.LightVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;

public final class Light<T extends LightBehavior>
extends HangingFeature {
    private static final int SWAY_RATE = 10;
    private static final int SWAY_PEAK_COUNT = 5;
    private static final int SWAY_CYCLE = 50;
    private final class_1799 item;
    private final LightVariant<T> variant;
    private final T behavior;
    private int sway;
    private boolean swaying;
    private boolean swayDirection;
    private int tick;
    private boolean powered;

    public Light(int index, class_243 point, float yaw, float pitch, class_1799 item, LightVariant<T> variant, float descent) {
        super(index, point, yaw, pitch, 0.0f, descent);
        this.item = item;
        this.variant = variant;
        this.behavior = variant.createBehavior(item);
    }

    public T getBehavior() {
        return this.behavior;
    }

    public class_1799 getItem() {
        return this.item;
    }

    public LightVariant<T> getVariant() {
        return this.variant;
    }

    public void startSwaying(boolean swayDirection) {
        this.swayDirection = swayDirection;
        this.swaying = true;
        this.sway = 0;
    }

    public void stopSwaying() {
        this.sway = 0;
        this.roll = 0.0f;
        this.swaying = false;
    }

    public void power(boolean powered, boolean now) {
        this.behavior.power(powered, now, this);
        this.powered = powered;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void tick(class_1937 world, class_243 origin) {
        super.tick(world);
        this.behavior.tick(world, origin, this);
        if (this.swaying) {
            if (this.sway >= 50) {
                this.stopSwaying();
            } else {
                this.roll = (float)(Math.sin((double)((this.swayDirection ? 1 : -1) * 2) * Math.PI / 10.0 * (double)this.sway) * Math.pow(114.59155902616465, (float)(-this.sway) / 50.0f));
                ++this.sway;
            }
        }
        ++this.tick;
    }

    @Override
    public class_238 getBounds() {
        return this.getVariant().getBounds();
    }

    @Override
    public boolean parallelsCord() {
        return this.getVariant().parallelsCord();
    }
}

