/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.feature.light;

import de.lucalabs.fairylights.feature.light.ColorLightBehavior;
import de.lucalabs.fairylights.feature.light.FixedColorBehavior;
import de.lucalabs.fairylights.feature.light.Light;
import de.lucalabs.fairylights.items.components.FairyLightItemComponents;
import de.lucalabs.fairylights.util.MathHelper;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class ColorChangingBehavior
implements ColorLightBehavior {
    private final float[] red;
    private final float[] green;
    private final float[] blue;
    private final float rate;
    private boolean powered;

    public ColorChangingBehavior(float[] red, float[] green, float[] blue, float rate) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.rate = rate;
    }

    public static ColorLightBehavior create(class_1799 stack) {
        List colors = (List)stack.method_57824(FairyLightItemComponents.COLORS);
        if (colors == null) {
            return new FixedColorBehavior(1.0f, 1.0f, 1.0f);
        }
        float[] red = new float[colors.size()];
        float[] green = new float[colors.size()];
        float[] blue = new float[colors.size()];
        for (int i = 0; i < colors.size(); ++i) {
            int color = (Integer)colors.get(i);
            red[i] = (float)(color >> 16 & 0xFF) / 255.0f;
            green[i] = (float)(color >> 8 & 0xFF) / 255.0f;
            blue[i] = (float)(color & 0xFF) / 255.0f;
        }
        return new ColorChangingBehavior(red, green, blue, (float)colors.size() / 960.0f);
    }

    public static int animate(class_1799 stack) {
        List colors = (List)stack.method_57824(FairyLightItemComponents.COLORS);
        if (colors == null || colors.isEmpty()) {
            return 0xFFFFFF;
        }
        if (colors.size() == 1) {
            return (Integer)colors.getFirst();
        }
        float p = MathHelper.mod((float)class_156.method_658() * 0.02f * ((float)colors.size() / 960.0f), (float)colors.size());
        int i = (int)p;
        int c0 = (Integer)colors.get(i % colors.size());
        float r0 = (float)(c0 >> 16 & 0xFF) / 255.0f;
        float g0 = (float)(c0 >> 8 & 0xFF) / 255.0f;
        float b0 = (float)(c0 & 0xFF) / 255.0f;
        int c1 = (Integer)colors.get((i + 1) % colors.size());
        float r1 = (float)(c1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(c1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(c1 & 0xFF) / 255.0f;
        return (int)(class_3532.method_16439((float)(p - (float)i), (float)r0, (float)r1) * 255.0f) << 16 | (int)(class_3532.method_16439((float)(p - (float)i), (float)g0, (float)g1) * 255.0f) << 8 | (int)(class_3532.method_16439((float)(p - (float)i), (float)b0, (float)b1) * 255.0f);
    }

    public static boolean exists(class_1799 stack) {
        return stack.method_57826(FairyLightItemComponents.COLORS);
    }

    @Override
    public float getRed(float delta) {
        return this.get(this.red, delta);
    }

    @Override
    public float getGreen(float delta) {
        return this.get(this.green, delta);
    }

    @Override
    public float getBlue(float delta) {
        return this.get(this.blue, delta);
    }

    private float get(float[] values, float delta) {
        float p = this.powered ? MathHelper.mod((float)class_156.method_658() * 0.02f * this.rate, (float)values.length) : 0.0f;
        int i = (int)p;
        return class_3532.method_16439((float)(p - (float)i), (float)values[i % values.length], (float)values[(i + 1) % values.length]);
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
        this.powered = powered;
    }

    @Override
    public void tick(class_1937 world, class_243 origin, Light<?> light) {
    }
}

