/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.fastener.accessor;

import de.lucalabs.fairylights.components.FairyLightComponents;
import de.lucalabs.fairylights.components.FastenerComponent;
import de.lucalabs.fairylights.components.GenericComponent;
import de.lucalabs.fairylights.fastener.EntityFastener;
import de.lucalabs.fairylights.fastener.Fastener;
import de.lucalabs.fairylights.fastener.accessor.FastenerAccessor;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public abstract class EntityFastenerAccessor<E extends class_1297>
implements FastenerAccessor {
    private final Class<? extends E> entityClass;
    private UUID uuid;
    @Nullable
    private E entity;
    @Nullable
    private class_243 pos;

    public EntityFastenerAccessor(Class<? extends E> entityClass) {
        this(entityClass, (UUID)null);
    }

    public EntityFastenerAccessor(Class<? extends E> entityClass, EntityFastener<E> fastener) {
        this(entityClass, fastener.getEntity().method_5667());
        this.entity = fastener.getEntity();
        this.pos = this.entity.method_19538();
    }

    public EntityFastenerAccessor(Class<? extends E> entityClass, UUID uuid) {
        this.entityClass = entityClass;
        this.uuid = uuid;
    }

    @Override
    public Optional<Fastener<?>> get(class_1937 world, boolean load) {
        block3: {
            block4: {
                if (this.entity != null) break block3;
                if (!(world instanceof class_3218)) break block4;
                class_1297 e = ((class_3218)world).method_14190(this.uuid);
                if (!this.entityClass.isInstance(e)) break block3;
                this.entity = (class_1297)this.entityClass.cast(e);
                break block3;
            }
            if (this.pos != null) {
                List relevantEntities = world.method_18467(this.entityClass, new class_238(this.pos.method_1023(1.0, 1.0, 1.0), this.pos.method_1031(1.0, 1.0, 1.0)));
                for (class_1297 entity : relevantEntities) {
                    if (!this.uuid.equals(entity.method_5667())) continue;
                    this.entity = entity;
                    break;
                }
            }
        }
        if (this.entity != null && this.entity.method_37908() == world) {
            this.pos = this.entity.method_19538();
            return FairyLightComponents.FASTENER.maybeGet(this.entity).flatMap(GenericComponent::get);
        }
        return Optional.empty();
    }

    @Override
    public boolean isGone(class_1937 world) {
        return !world.method_8608() && this.entity != null && (((FastenerComponent)FairyLightComponents.FASTENER.get(this.entity)).get().isEmpty() || this.entity.method_37908() != world);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EntityFastenerAccessor) {
            return this.uuid.equals(((EntityFastenerAccessor)obj).uuid);
        }
        return false;
    }

    @Override
    public class_2487 serialize() {
        class_2487 tag = new class_2487();
        tag.method_25927("UUID", this.uuid);
        if (this.pos != null) {
            class_2499 pos = new class_2499();
            pos.add((Object)class_2489.method_23241((double)this.pos.field_1352));
            pos.add((Object)class_2489.method_23241((double)this.pos.field_1351));
            pos.add((Object)class_2489.method_23241((double)this.pos.field_1350));
            tag.method_10566("Pos", (class_2520)pos);
        }
        return tag;
    }

    @Override
    public void deserialize(class_2487 tag) {
        this.uuid = tag.method_25926("UUID");
        if (tag.method_10573("Pos", 9)) {
            class_2499 pos = tag.method_10554("Pos", 6);
            this.pos = new class_243(pos.method_10611(0), pos.method_10611(1), pos.method_10611(2));
        } else {
            this.pos = null;
        }
        this.entity = null;
    }
}

