/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.fastener;

import de.lucalabs.fairylights.connection.Connection;
import de.lucalabs.fairylights.fastener.EntityFastener;
import de.lucalabs.fairylights.fastener.accessor.PlayerFastenerAccessor;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public final class PlayerFastener
extends EntityFastener<class_1657> {
    public PlayerFastener(class_1657 entity) {
        super(entity);
    }

    @Override
    public class_243 getConnectionPoint() {
        double dy;
        double forwardDist;
        class_243 point = super.getConnectionPoint();
        if (((class_1657)this.entity).method_6128()) {
            return point;
        }
        double angle = (((class_1657)this.entity).field_6283 - 90.0f) * ((float)Math.PI / 180);
        double perpAngle = angle - 1.5707963267948966;
        boolean sneaking = ((class_1657)this.entity).method_18276();
        double perpDist = 0.4 * (double)(this.matchesStack(((class_1657)this.entity).method_6047()) ? 1 : -1);
        if (sneaking) {
            forwardDist = 0.0;
            dy = 0.6;
        } else {
            forwardDist = 0.2;
            dy = 0.8;
        }
        double dx = Math.cos(perpAngle) * perpDist - Math.cos(angle) * forwardDist;
        double dz = Math.sin(perpAngle) * perpDist - Math.sin(angle) * forwardDist;
        return point.method_1031(dx, dy, dz);
    }

    @Override
    public boolean isMoving() {
        return true;
    }

    @Override
    public boolean update() {
        if (!(this.hasNoConnections() || this.matchesStack(((class_1657)this.entity).method_6047()) || this.matchesStack(((class_1657)this.entity).method_6079()))) {
            for (Connection connection : this.getAllConnections()) {
                if (connection.shouldDrop()) continue;
                connection.remove();
            }
        }
        return super.update();
    }

    private boolean matchesStack(class_1799 stack) {
        return this.getFirstConnection().filter(connection -> connection.matches(stack)).isPresent();
    }

    @Override
    public void resistSnap(class_243 from) {
        double dist = this.getConnectionPoint().method_1022(from);
        if (dist > 32.0) {
            double arcX;
            double arcY;
            double arcZ;
            double dx = ((class_1657)this.entity).method_23317() - from.field_1352;
            double dy = ((class_1657)this.entity).method_23318() - from.field_1351;
            double dz = ((class_1657)this.entity).method_23321() - from.field_1350;
            double vectorX = dx / dist;
            double vectorY = dy / dist;
            double vectorZ = dz / dist;
            double factor = Math.min((dist - 32.0) / 5.0, 5.0);
            class_243 motion = ((class_1657)this.entity).method_18798();
            double tangent = Math.cos(class_3532.method_15349((double)dy, (double)Math.sqrt(dx * dx + dz * dz))) * Math.signum(motion.field_1351);
            double speed = motion.method_1033();
            double swing = Math.abs(speed) < 1.0E-6 ? 0.0 : (1.0 - Math.abs(motion.field_1351 / speed - tangent)) * 0.1;
            double mag = Math.sqrt(motion.field_1352 * motion.field_1352 + tangent * tangent + motion.field_1350 * motion.field_1350);
            if (dy > 0.0 || Math.abs(mag) < 1.0E-6) {
                arcZ = 0.0;
                arcY = 0.0;
                arcX = 0.0;
            } else {
                arcX = motion.field_1352 / mag * swing;
                arcY = tangent / mag * swing;
                arcZ = motion.field_1350 / mag * swing;
            }
            ((class_1657)this.entity).method_18800(motion.field_1352 + vectorX * -Math.abs(vectorX) * factor + arcX, motion.field_1351 + vectorY * -Math.abs(vectorY) * factor + arcY, motion.field_1350 + vectorZ * -Math.abs(vectorZ) * factor + arcZ);
            ((class_1657)this.entity).field_6017 = 0.0f;
            if (this.entity instanceof class_3222) {
                ((class_3222)this.entity).field_13987.method_14364((class_2596)new class_2743(this.entity));
            }
        }
    }

    @Override
    public PlayerFastenerAccessor createAccessor() {
        return new PlayerFastenerAccessor(this);
    }
}

