/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.fastener;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.DynamicOps;
import de.lucalabs.fairylights.connection.Connection;
import de.lucalabs.fairylights.connection.ConnectionType;
import de.lucalabs.fairylights.fastener.Fastener;
import de.lucalabs.fairylights.fastener.accessor.FastenerAccessor;
import de.lucalabs.fairylights.items.components.ComponentRecords;
import de.lucalabs.fairylights.registries.FairyLightRegistries;
import de.lucalabs.fairylights.util.BoxBuilder;
import de.lucalabs.fairylights.util.Constants;
import de.lucalabs.fairylights.util.Curve;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFastener<F extends FastenerAccessor>
implements Fastener<F> {
    private final Map<UUID, Connection> outgoing = new HashMap<UUID, Connection>();
    private final Map<UUID, Incoming> incoming = new HashMap<UUID, Incoming>();
    protected class_238 bounds = Constants.INFINITE_BOX;
    @Nullable
    private class_1937 world;
    private boolean dirty;

    @Override
    public Optional<Connection> get(UUID id) {
        return Optional.ofNullable(this.outgoing.get(id));
    }

    @Override
    public List<Connection> getOwnConnections() {
        return ImmutableList.copyOf(this.outgoing.values());
    }

    @Override
    public List<Connection> getAllConnections() {
        ImmutableList.Builder list = new ImmutableList.Builder();
        list.addAll(this.outgoing.values());
        if (this.world != null) {
            this.incoming.values().forEach(i -> i.get(this.world).ifPresent(arg_0 -> ((ImmutableList.Builder)list).add(arg_0)));
        }
        return list.build();
    }

    @Override
    public class_238 getBounds() {
        return this.bounds;
    }

    @Override
    public abstract class_2338 getPos();

    @Override
    @Nullable
    public class_1937 getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(class_1937 world) {
        this.world = world;
        this.outgoing.values().forEach(c -> c.setWorld(world));
    }

    @Override
    public boolean update() {
        Iterator<Connection> it = this.outgoing.values().iterator();
        class_243 fromOffset = this.getConnectionPoint();
        boolean dirty = this.dirty;
        this.dirty = false;
        while (it.hasNext()) {
            Connection connection = it.next();
            if (connection.update(fromOffset)) {
                dirty = true;
            }
            if (!connection.isRemoved()) continue;
            dirty = true;
            it.remove();
            this.incoming.remove(connection.getUUID());
            if (this.world == null) continue;
            this.drop(this.world, this.getPos(), connection);
        }
        if (this.world != null) {
            this.incoming.values().removeIf(incoming -> incoming.gone(this.world));
        }
        if (dirty) {
            this.calculateBoundingBox();
        }
        return dirty;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    protected void calculateBoundingBox() {
        if (this.outgoing.isEmpty()) {
            this.bounds = new class_238(this.getPos());
            return;
        }
        BoxBuilder builder = new BoxBuilder();
        for (Connection connection : this.outgoing.values()) {
            Curve catenary = connection.getCatenary();
            if (catenary == null) continue;
            Curve.SegmentIterator it = catenary.iterator();
            while (it.next()) {
                builder.include(it.getX(0.0f), it.getY(0.0f), it.getZ(0.0f));
                if (it.hasNext()) continue;
                builder.include(it.getX(1.0f), it.getY(1.0f), it.getZ(1.0f));
            }
        }
        this.bounds = builder.add(this.getConnectionPoint()).build();
    }

    @Override
    public void dropItems(class_1937 world, class_2338 pos) {
        for (Connection connection : this.getAllConnections()) {
            this.drop(world, pos, connection);
        }
    }

    private void drop(class_1937 world, class_2338 pos, Connection connection) {
        if (!connection.shouldDrop()) {
            return;
        }
        float offsetX = world.field_9229.method_43057() * 0.8f + 0.1f;
        float offsetY = world.field_9229.method_43057() * 0.8f + 0.1f;
        float offsetZ = world.field_9229.method_43057() * 0.8f + 0.1f;
        class_1799 stack = connection.getItemStack();
        class_1542 entityItem = new class_1542(world, (double)((float)pos.method_10263() + offsetX), (double)((float)pos.method_10264() + offsetY), (double)((float)pos.method_10260() + offsetZ), stack);
        float scale = 0.05f;
        entityItem.method_18800(world.field_9229.method_43059() * (double)0.05f, world.field_9229.method_43059() * (double)0.05f + (double)0.2f, world.field_9229.method_43059() * (double)0.05f);
        world.method_8649((class_1297)entityItem);
        connection.noDrop();
    }

    @Override
    public void remove() {
        this.outgoing.values().forEach(Connection::remove);
    }

    @Override
    public boolean hasNoConnections() {
        return this.outgoing.isEmpty() && this.incoming.isEmpty();
    }

    @Override
    public boolean hasConnectionWith(Fastener<?> fastener) {
        return this.getConnectionTo((FastenerAccessor)fastener.createAccessor()) != null;
    }

    @Override
    @Nullable
    public Connection getConnectionTo(FastenerAccessor destination) {
        for (Connection connection : this.outgoing.values()) {
            if (!connection.isDestination(destination)) continue;
            return connection;
        }
        return null;
    }

    @Override
    public boolean removeConnection(UUID uuid) {
        Connection connection = this.outgoing.remove(uuid);
        if (connection != null) {
            connection.remove();
            this.setDirty();
            return true;
        }
        if (this.incoming.remove(uuid) != null) {
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeConnection(Connection connection) {
        return this.removeConnection(connection.getUUID());
    }

    @Override
    public boolean reconnect(class_1937 world, Connection connection, Fastener<?> newDestination) {
        if (this.equals(newDestination) || newDestination.hasConnectionWith(this)) {
            return false;
        }
        UUID uuid = connection.getUUID();
        if (connection.getDestination().get(world, false).filter(t -> {
            t.removeConnection(uuid);
            return true;
        }).isPresent()) {
            connection.setDestination(newDestination);
            connection.setDrop();
            newDestination.createIncomingConnection(this.world, uuid, this, connection.getType());
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public Connection connect(class_1937 world, Fastener<?> destination, ConnectionType<?> type, ComponentRecords.ConnectionLogic logic, boolean drop) {
        UUID uuid = class_3532.method_15394();
        Connection connection = this.createOutgoingConnection(world, uuid, destination, type, logic, drop);
        destination.createIncomingConnection(world, uuid, this, type);
        return connection;
    }

    @Override
    public Connection createOutgoingConnection(class_1937 world, UUID uuid, Fastener<?> destination, ConnectionType<?> type, ComponentRecords.ConnectionLogic logic, boolean drop) {
        Object c = type.create(world, this, uuid);
        ((Connection)c).deserialize(destination, logic, drop);
        this.outgoing.put(uuid, (Connection)c);
        this.setDirty();
        return c;
    }

    @Override
    public void createIncomingConnection(class_1937 world, UUID uuid, Fastener<?> destination, ConnectionType<?> type) {
        this.incoming.put(uuid, new Incoming((FastenerAccessor)destination.createAccessor(), uuid));
        this.setDirty();
    }

    @Override
    public void writeToNbt(class_2487 compound) {
        class_2499 outgoing = new class_2499();
        for (Map.Entry<UUID, Connection> connectionEntry : this.outgoing.entrySet()) {
            UUID uuid = connectionEntry.getKey();
            Connection connection = connectionEntry.getValue();
            class_2487 connectionCompound = new class_2487();
            class_2520 connectionNbt = (class_2520)ComponentRecords.ConnectionStatus.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)connection.serialize().build()).getOrThrow();
            connectionCompound.method_10566("connection", connectionNbt);
            Optional<class_2960> connectionTypeId = FairyLightRegistries.CONNECTION_TYPES.method_29113(connection.getType()).map(class_5321::method_29177);
            if (!connectionTypeId.isPresent()) continue;
            connectionCompound.method_10582("type", connectionTypeId.get().toString());
            connectionCompound.method_25927("uuid", uuid);
            outgoing.add((Object)connectionCompound);
        }
        compound.method_10566("outgoing", (class_2520)outgoing);
        class_2499 incoming = new class_2499();
        for (Map.Entry<UUID, Incoming> e : this.incoming.entrySet()) {
            class_2487 tag = new class_2487();
            tag.method_25927("uuid", e.getKey());
            class_2520 fastenerNbt = (class_2520)ComponentRecords.FastenerAccessorData.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)ComponentRecords.FastenerAccessorData.from(e.getValue().fastener())).getOrThrow();
            tag.method_10566("fastener", fastenerNbt);
            incoming.add((Object)tag);
        }
        compound.method_10566("incoming", (class_2520)incoming);
    }

    @Override
    public void readFromNbt(class_2487 compound) {
        class_2499 listConnections = compound.method_10554("outgoing", 10);
        ArrayList<UUID> nbtUuids = new ArrayList<UUID>();
        for (int i = 0; i < listConnections.size(); ++i) {
            class_2487 connectionCompound = listConnections.method_10602(i);
            UUID uuid = connectionCompound.method_25928("uuid") ? connectionCompound.method_25926("uuid") : class_3532.method_15394();
            nbtUuids.add(uuid);
            if (this.outgoing.containsKey(uuid)) {
                Connection connection = this.outgoing.get(uuid);
                ComponentRecords.ConnectionStatus status = (ComponentRecords.ConnectionStatus)ComponentRecords.ConnectionStatus.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)connectionCompound.method_10562("connection")).getOrThrow();
                connection.deserialize(status);
                continue;
            }
            ConnectionType type = (ConnectionType)FairyLightRegistries.CONNECTION_TYPES.method_10223(class_2960.method_12829((String)connectionCompound.method_10558("type")));
            if (type == null) continue;
            Object connection = type.create(this.world, this, uuid);
            ComponentRecords.ConnectionStatus status = (ComponentRecords.ConnectionStatus)ComponentRecords.ConnectionStatus.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)connectionCompound.method_10562("connection")).getOrThrow();
            ((Connection)connection).deserialize(status);
            this.outgoing.put(uuid, (Connection)connection);
        }
        Iterator<Map.Entry<UUID, Connection>> connectionsIter = this.outgoing.entrySet().iterator();
        while (connectionsIter.hasNext()) {
            Map.Entry<UUID, Connection> connection = connectionsIter.next();
            if (nbtUuids.contains(connection.getKey())) continue;
            connectionsIter.remove();
            connection.getValue().remove();
        }
        this.incoming.clear();
        class_2499 incoming = compound.method_10554("incoming", 10);
        for (int i = 0; i < incoming.size(); ++i) {
            class_2487 incomingNbt = incoming.method_10602(i);
            UUID uuid = incomingNbt.method_25926("uuid");
            FastenerAccessor fastener = ((ComponentRecords.FastenerAccessorData)ComponentRecords.FastenerAccessorData.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)incomingNbt.method_10562("fastener")).getOrThrow()).accessor();
            this.incoming.put(uuid, new Incoming(fastener, uuid));
        }
        this.setDirty();
    }

    record Incoming(FastenerAccessor fastener, UUID id) {
        boolean gone(class_1937 world) {
            return this.fastener.isGone(world);
        }

        Optional<Connection> get(class_1937 world) {
            return this.fastener.get(world, false).flatMap(f -> f.get(this.id));
        }
    }
}

