/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.events;

import com.google.common.collect.Sets;
import de.lucalabs.fairylights.collision.Collidable;
import de.lucalabs.fairylights.collision.Intersection;
import de.lucalabs.fairylights.components.FairyLightComponents;
import de.lucalabs.fairylights.components.GenericComponent;
import de.lucalabs.fairylights.connection.Connection;
import de.lucalabs.fairylights.connection.PlayerAction;
import de.lucalabs.fairylights.entity.FenceFastenerEntity;
import de.lucalabs.fairylights.fastener.Fastener;
import de.lucalabs.fairylights.fastener.FastenerType;
import de.lucalabs.fairylights.net.serverbound.InteractionConnectionMessagePayload;
import de.lucalabs.fairylights.util.Curve;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2802;
import net.minecraft.class_2818;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.ladysnake.cca.api.v3.component.ComponentAccess;

@Environment(value=EnvType.CLIENT)
public final class ClientEventHandler {
    private ClientEventHandler() {
    }

    public static void onDrawEntityHighlight(class_1297 entity, class_4184 camera, float tickDelta, class_4587 matrix, class_4597 buf) {
        class_243 pos = camera.method_19326();
        if (entity instanceof FenceFastenerEntity) {
            ClientEventHandler.drawFenceFastenerHighlight((FenceFastenerEntity)entity, matrix, buf.getBuffer(class_1921.method_23594()), tickDelta, pos.field_1352, pos.field_1351, pos.field_1350);
        } else if (entity instanceof HitConnection) {
            HitConnection hit = (HitConnection)entity;
            if (hit.result.intersection.featureType() == Connection.CORD_FEATURE) {
                matrix.method_22903();
                class_243 p = hit.result.connection.getFastener().getConnectionPoint();
                matrix.method_22904(p.field_1352 - pos.field_1352, p.field_1351 - pos.field_1351, p.field_1350 - pos.field_1350);
                ClientEventHandler.renderHighlight(hit.result.connection, matrix, buf.getBuffer(class_1921.method_23594()));
                matrix.method_22909();
            } else {
                class_238 bb = hit.result.intersection.hitBox().method_989(-pos.field_1352, -pos.field_1351, -pos.field_1350).method_1014(0.002);
                class_761.method_22982((class_4587)matrix, (class_4588)buf.getBuffer(class_1921.method_23594()), (class_238)bb, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            }
        }
    }

    private static void drawFenceFastenerHighlight(FenceFastenerEntity fence, class_4587 matrix, class_4588 buf, float delta, double dx, double dy, double dz) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && (player.method_6057((class_1297)fence) || player.method_5858((class_1297)fence) <= 9.0)) {
            class_238 selection = fence.method_5829().method_989(-dx, -dy, -dz).method_1014(0.002);
            class_761.method_22982((class_4587)matrix, (class_4588)buf, (class_238)selection, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        }
    }

    private static void renderHighlight(Connection connection, class_4587 matrix, class_4588 buf) {
        Curve cat = connection.getCatenary();
        if (cat == null) {
            return;
        }
        Vector3f p = new Vector3f();
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        LineBuilder builder = new LineBuilder(matrix, buf);
        float r = connection.getRadius() + 0.01f;
        for (int edge = 0; edge < 4; ++edge) {
            int n;
            p.set(cat.getX(0), cat.getY(0), cat.getZ(0));
            v1.set(cat.getDx(0), cat.getDy(0), cat.getDz(0));
            v1.normalize();
            v2.set(-v1.x(), -v1.y(), -v1.z());
            for (n = 0; edge == 0 && n < 8; ++n) {
                ClientEventHandler.addVertex(builder, (n + 1) / 2 % 4, p, v1, v2, r);
            }
            ClientEventHandler.addVertex(builder, edge, p, v1, v2, r);
            for (int i = 1; i < cat.getCount() - 1; ++i) {
                p.set(cat.getX(i), cat.getY(i), cat.getZ(i));
                v2.set(-cat.getDx(i), -cat.getDy(i), -cat.getDz(i));
                v2.normalize();
                ClientEventHandler.addVertex(builder, edge, p, v1, v2, r);
                ClientEventHandler.addVertex(builder, edge, p, v1, v2, r);
                v1.set(-v2.x(), -v2.y(), -v2.z());
            }
            p.set(cat.getX(), cat.getY(), cat.getZ());
            v2.set(-v1.x(), -v1.y(), -v1.z());
            ClientEventHandler.addVertex(builder, edge, p, v1, v2, r);
            for (n = 0; edge == 0 && n < 8; ++n) {
                ClientEventHandler.addVertex(builder, (n + 1) / 2 % 4, p, v1, v2, r);
            }
        }
    }

    @Nullable
    public static Connection getHitConnection() {
        class_1297 entity;
        class_239 result = class_310.method_1551().field_1765;
        if (result instanceof class_3966 && (entity = ((class_3966)result).method_17782()) instanceof HitConnection) {
            return ((HitConnection)entity).result.connection;
        }
        return null;
    }

    @Nullable
    private static HitResult getHitConnection(class_1937 world, class_1297 viewer) {
        class_238 bounds = new class_238(viewer.method_24515()).method_1014(33.0);
        Set<Fastener<?>> fasteners = ClientEventHandler.collectFasteners(world, bounds);
        return ClientEventHandler.getHitConnection(viewer, bounds, fasteners);
    }

    @Nullable
    private static HitResult getHitConnection(class_1297 viewer, class_238 bounds, Set<Fastener<?>> fasteners) {
        if (fasteners.isEmpty()) {
            return null;
        }
        class_243 origin = viewer.method_5836(1.0f);
        class_243 look = viewer.method_5720();
        double reach = class_310.method_1551().field_1761.method_2920().method_8386() ? 5.0 : 4.5;
        class_243 end = origin.method_1031(look.field_1352 * reach, look.field_1351 * reach, look.field_1350 * reach);
        Connection found = null;
        Intersection rayTrace = null;
        double distance = Double.MAX_VALUE;
        for (Fastener<?> fastener : fasteners) {
            for (Connection connection : fastener.getOwnConnections()) {
                double dist;
                Collidable collision;
                Intersection result;
                if (connection.getDestination().getType() == FastenerType.PLAYER || (result = (collision = connection.getCollision()).intersect(origin, end)) == null || !((dist = result.result().method_1022(origin)) < distance)) continue;
                distance = dist;
                found = connection;
                rayTrace = result;
            }
        }
        if (found == null) {
            return null;
        }
        return new HitResult(found, rayTrace);
    }

    public static void updateHitConnection() {
        HitResult result;
        class_310 mc = class_310.method_1551();
        class_1297 viewer = mc.method_1560();
        if (mc.field_1765 != null && mc.field_1687 != null && viewer != null && (result = ClientEventHandler.getHitConnection((class_1937)mc.field_1687, viewer)) != null) {
            class_243 eyes = viewer.method_5836(1.0f);
            if (result.intersection.result().method_1022(eyes) < mc.field_1765.method_17784().method_1022(eyes)) {
                mc.field_1765 = new class_3966((class_1297)new HitConnection((class_1937)mc.field_1687, result));
                mc.field_1692 = null;
            }
        }
    }

    private static Set<Fastener<?>> collectFasteners(class_1937 world, class_238 bounds) {
        LinkedHashSet fasteners = Sets.newLinkedHashSet();
        world.method_18467(FenceFastenerEntity.class, bounds).forEach(e -> ClientEventHandler.collectFastenersAttachedToEntity((ComponentAccess)e, bounds, fasteners));
        int minX = class_3532.method_15357((double)(bounds.field_1323 / 16.0));
        int maxX = class_3532.method_15384((double)(bounds.field_1320 / 16.0));
        int minZ = class_3532.method_15357((double)(bounds.field_1321 / 16.0));
        int maxZ = class_3532.method_15384((double)(bounds.field_1324 / 16.0));
        class_2802 provider = world.method_8398();
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                class_2818 chunk = provider.method_12126(x, z, false);
                if (chunk == null) continue;
                try {
                    for (class_2586 e2 : chunk.method_12214().values()) {
                        ClientEventHandler.collectFastenersAttachedToEntity((ComponentAccess)e2, bounds, fasteners);
                    }
                    continue;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
        }
        return fasteners;
    }

    private static void collectFastenersAttachedToEntity(ComponentAccess e, class_238 bounds, Set<Fastener<?>> fasteners) {
        FairyLightComponents.FASTENER.maybeGet((Object)e).flatMap(GenericComponent::get).ifPresent(f -> {
            if (bounds.method_1006(f.getConnectionPoint())) {
                fasteners.add((Fastener<?>)f);
            }
        });
    }

    private static void addVertex(LineBuilder builder, int edge, Vector3f p, Vector3f v1, Vector3f v2, float r) {
        builder.accept(ClientEventHandler.get(edge, p, v1, v2, r));
    }

    private static Vector3f get(int edge, Vector3f p, Vector3f v1, Vector3f v2, float r) {
        Vector3f up = new Vector3f();
        Vector3f side = new Vector3f();
        if (v1.dot((Vector3fc)v2) < -0.99f) {
            float h = class_3532.method_15355((float)(v1.x() * v1.x() + v1.z() * v1.z()));
            if (h < 0.01f) {
                up.set(-1.0f, 0.0f, 0.0f);
            } else {
                up.set(-v1.x() / h * -v1.y(), -h, -v1.z() / h * -v1.y());
            }
        } else {
            up.set(v2.x(), v2.y(), v2.z());
            up.lerp((Vector3fc)v1, 0.5f);
        }
        up.normalize();
        side.set(v1.x(), v1.y(), v1.z());
        side.cross((Vector3fc)up);
        side.normalize();
        side.mul(edge == 0 || edge == 3 ? -r : r);
        up.mul(edge < 2 ? -r : r);
        up.add((Vector3fc)side);
        up.add((Vector3fc)p);
        return up;
    }

    @Environment(value=EnvType.CLIENT)
    static class HitConnection
    extends class_1297 {
        final HitResult result;

        HitConnection(class_1937 world, HitResult result) {
            super(class_1299.field_6052, world);
            this.method_5838(-1);
            this.result = result;
            this.method_33574(result.intersection.result());
        }

        public boolean method_5643(class_1282 source, float amount) {
            if (source.method_5529() == class_310.method_1551().field_1724) {
                this.processAction(PlayerAction.ATTACK);
                return true;
            }
            return false;
        }

        public class_1269 method_5688(class_1657 player, class_1268 hand) {
            if (player == class_310.method_1551().field_1724) {
                this.processAction(PlayerAction.INTERACT);
                return class_1269.field_5812;
            }
            return super.method_5688(player, hand);
        }

        private void processAction(PlayerAction action) {
            ClientPlayNetworking.send((class_8710)new InteractionConnectionMessagePayload(this.result.connection, action, this.result.intersection));
        }

        public class_1799 method_31480() {
            return this.result.connection.getItemStack();
        }

        protected void method_5693(class_2945.class_9222 builder) {
        }

        protected void method_5652(class_2487 compound) {
        }

        protected void method_5749(class_2487 compound) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record HitResult(Connection connection, Intersection intersection) {
    }

    @Environment(value=EnvType.CLIENT)
    static class LineBuilder {
        final class_4587 matrix;
        final class_4588 buf;
        Vector3f last;

        LineBuilder(class_4587 matrix, class_4588 buf) {
            this.matrix = matrix;
            this.buf = buf;
        }

        void accept(Vector3f pos) {
            if (this.last == null) {
                this.last = pos;
            } else {
                Vector3f n = new Vector3f((Vector3fc)pos);
                n.sub((Vector3fc)this.last);
                n.normalize();
                n = this.matrix.method_23760().method_23762().transform(n);
                this.buf.method_22918(this.matrix.method_23760().method_23761(), this.last.x(), this.last.y(), this.last.z()).method_22915(0.0f, 0.0f, 0.0f, 0.4f).method_22914(n.x(), n.y(), n.z());
                this.buf.method_22918(this.matrix.method_23760().method_23761(), pos.x(), pos.y(), pos.z()).method_22915(0.0f, 0.0f, 0.0f, 0.4f).method_22914(n.x(), n.y(), n.z());
                this.last = null;
            }
        }
    }
}

