/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.entity;

import de.lucalabs.fairylights.blocks.FairyLightBlocks;
import de.lucalabs.fairylights.components.FairyLightComponents;
import de.lucalabs.fairylights.components.FastenerComponent;
import de.lucalabs.fairylights.entity.FairyLightEntities;
import de.lucalabs.fairylights.fastener.Fastener;
import de.lucalabs.fairylights.items.ConnectionItem;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2945;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public final class FenceFastenerEntity
extends class_1530 {
    private int surfaceCheckTime;

    public FenceFastenerEntity(class_1299<? extends FenceFastenerEntity> type, class_1937 world) {
        super(type, world);
    }

    public FenceFastenerEntity(class_1937 world) {
        this(FairyLightEntities.FASTENER, world);
    }

    public FenceFastenerEntity(class_1937 world, class_2338 pos) {
        this(world);
        this.method_5814(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static FenceFastenerEntity create(class_1937 world, class_2338 fence) {
        FenceFastenerEntity fastener = new FenceFastenerEntity(world, fence);
        world.method_8649((class_1297)fastener);
        fastener.method_6894();
        return fastener;
    }

    @Nullable
    public static FenceFastenerEntity find(class_1937 world, class_2338 pos) {
        class_1530 entity = FenceFastenerEntity.findHanging(world, pos);
        if (entity instanceof FenceFastenerEntity) {
            return (FenceFastenerEntity)entity;
        }
        return null;
    }

    @Nullable
    public static class_1530 findHanging(class_1937 world, class_2338 pos) {
        for (class_1530 e : world.method_18467(class_1530.class, new class_238(pos).method_1014(2.0))) {
            if (!e.method_59940().equals((Object)pos)) continue;
            return e;
        }
        return null;
    }

    public boolean method_5640(double distance) {
        return distance < 4096.0;
    }

    public boolean method_5822(boolean allowVehicles) {
        return false;
    }

    public boolean method_5659(class_1927 exp) {
        return true;
    }

    public boolean method_6888() {
        return !this.method_37908().method_8477(this.field_51589) || ConnectionItem.isFence(this.method_37908().method_8320(this.field_51589));
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.getFastener().ifPresent(Fastener::remove);
        super.method_5650(reason);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (!this.method_37908().method_8608() && this.method_5805()) {
            this.method_5785();
            this.method_6889(source.method_5529());
            this.method_5650(class_1297.class_5529.field_26998);
        }
        return true;
    }

    public void method_6889(@Nullable class_1297 breaker) {
        this.getFastener().ifPresent(fastener -> fastener.dropItems(this.method_37908(), this.field_51589));
        if (breaker != null) {
            this.method_37908().method_20290(2001, this.field_51589, class_2248.method_9507((class_2680)FairyLightBlocks.FASTENER.method_9564()));
        }
    }

    public void method_6894() {
        class_2498 sound = FairyLightBlocks.FASTENER.method_9564().method_26231();
        this.method_5783(sound.method_10598(), (sound.method_10597() + 1.0f) / 2.0f, sound.method_10599() * 0.8f);
    }

    public class_3419 method_5634() {
        return class_3419.field_15245;
    }

    public void method_5814(double x, double y, double z) {
        super.method_5814((double)class_3532.method_15357((double)x) + 0.5, (double)class_3532.method_15357((double)y) + 0.5, (double)class_3532.method_15357((double)z) + 0.5);
    }

    public void method_6892(class_2350 facing) {
    }

    protected class_238 method_59943(class_2338 pos, class_2350 side) {
        double posX = (double)this.field_51589.method_10263() + 0.5;
        double posY = (double)this.field_51589.method_10264() + 0.5;
        double posZ = (double)this.field_51589.method_10260() + 0.5;
        this.method_23327(posX, posY, posZ);
        float w = 0.1875f;
        float h = 0.1875f;
        return new class_238(posX - 0.1875, posY - 0.1875, posZ - 0.1875, posX + 0.1875, posY + 0.1875, posZ + 0.1875);
    }

    public class_238 method_5830() {
        return this.getFastener().map(fastener -> fastener.getBounds().method_1014(1.0)).orElseGet(() -> super.method_5830());
    }

    public void method_5773() {
        this.getFastener().ifPresent(fastener -> {
            if (!this.method_37908().method_8608() && (fastener.hasNoConnections() || this.checkSurface())) {
                this.method_6889(null);
                this.method_5650(class_1297.class_5529.field_26999);
            } else if (fastener.update() && !this.method_37908().method_8608()) {
                FairyLightComponents.FASTENER.sync((Object)this);
            }
        });
    }

    private boolean checkSurface() {
        if (this.surfaceCheckTime++ == 100) {
            this.surfaceCheckTime = 0;
            return !this.method_6888();
        }
        return false;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() instanceof ConnectionItem) {
            if (this.method_37908().method_8608()) {
                player.method_6104(hand);
            } else {
                this.getFastener().ifPresent(fastener -> ((ConnectionItem)stack.method_7909()).connect(stack, player, this.method_37908(), (Fastener<?>)fastener));
            }
            return class_1269.field_5812;
        }
        return super.method_5688(player, hand);
    }

    public boolean method_5740() {
        return true;
    }

    private Optional<Fastener<?>> getFastener() {
        return ((FastenerComponent)FairyLightComponents.FASTENER.get((Object)this)).get();
    }
}

