/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.fairylights.collision;

import com.google.common.collect.ImmutableList;
import de.lucalabs.fairylights.collision.Collidable;
import de.lucalabs.fairylights.collision.Intersection;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public final class CollidableList
implements Collidable {
    private final ImmutableList<Collidable> collision;

    private CollidableList(Builder builder) {
        this.collision = builder.collision.build();
    }

    @Override
    @Nullable
    public Intersection intersect(class_243 origin, class_243 end) {
        Intersection result = null;
        double distance = Double.MAX_VALUE;
        for (Collidable collidable : this.collision) {
            double d;
            Intersection r = collidable.intersect(origin, end);
            if (r == null || !((d = r.result().method_1022(origin)) < distance)) continue;
            result = r;
            distance = d;
        }
        return result;
    }

    public static class Builder {
        final ImmutableList.Builder<Collidable> collision = new ImmutableList.Builder();

        public Builder add(Collidable collidable) {
            this.collision.add((Object)collidable);
            return this;
        }

        public CollidableList build() {
            return new CollidableList(this);
        }
    }
}

