/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.trinkets.wrapper;

import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories_compat.AccessoriesCompatInit;
import io.wispforest.accessories_compat.trinkets.utils.OuterGroupMap;
import io.wispforest.accessories_compat.trinkets.wrapper.TrinketsWrappingUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public record WrappedTrinketComponent(LivingEntity entity) implements TrinketComponent
{
    private static final Logger LOGGER = LogUtils.getLogger();

    public AccessoriesCapability capability() {
        return AccessoriesCapability.get((LivingEntity)this.entity);
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public Map<String, SlotGroup> getGroups() {
        return TrinketsApi.getEntitySlots((Level)this.entity().level(), (EntityType)this.entity().getType());
    }

    public Map<String, Map<String, TrinketInventory>> getInventory() {
        LivingEntity entity = this.entity();
        return new OuterGroupMap(TrinketsWrappingUtils.getGroupedSlots(entity.level().isClientSide(), entity.getType()), this, this.capability(), (type, additionalMsg) -> {
            if (!AccessoriesCompatInit.CONFIG.dumpDataWhenNullEntries()) {
                return;
            }
            LOGGER.warn("Unable to get some value leading to a possible error, here comes the dumping data!");
            LOGGER.warn("Entity: {}", (Object)this.entity());
            LOGGER.warn("Entity Slots: {}", (Object)EntitySlotLoader.getEntitySlots((LivingEntity)this.entity()));
            LOGGER.warn("Current Containers: {}", (Object)this.capability().getContainers());
            LOGGER.warn("More Info: ({})", additionalMsg);
        });
    }

    public void update() {
        this.capability().updateContainers();
    }

    public void addTemporaryModifiers(Multimap<String, AttributeModifier> modifiers) {
        this.capability().addTransientSlotModifiers(modifiers);
    }

    public void addPersistentModifiers(Multimap<String, AttributeModifier> modifiers) {
        this.capability().addPersistentSlotModifiers(modifiers);
    }

    public void removeModifiers(Multimap<String, AttributeModifier> modifiers) {
        this.capability().removeSlotModifiers(modifiers);
    }

    public void clearModifiers() {
        this.capability().clearSlotModifiers();
    }

    public Multimap<String, AttributeModifier> getModifiers() {
        return this.capability().getSlotModifiers();
    }

    public boolean isEquipped(Predicate<ItemStack> predicate) {
        return this.capability().isEquipped(predicate);
    }

    public List<Tuple<dev.emi.trinkets.api.SlotReference, ItemStack>> getEquipped(Predicate<ItemStack> predicate) {
        List equipped = this.capability().getEquipped(predicate);
        return equipped.stream().map(slotResult -> {
            Optional<dev.emi.trinkets.api.SlotReference> reference = TrinketsWrappingUtils.createTrinketsReference(slotResult.reference());
            return reference.map(slotReference -> new Tuple(slotReference, (Object)slotResult.stack())).orElse(null);
        }).filter(Objects::nonNull).toList();
    }

    public List<Tuple<dev.emi.trinkets.api.SlotReference, ItemStack>> getAllEquipped() {
        return this.capability().getAllEquipped().stream().map(slotResult -> {
            Optional<dev.emi.trinkets.api.SlotReference> reference = TrinketsWrappingUtils.createTrinketsReference(slotResult.reference());
            return reference.map(slotReference -> new Tuple(slotReference, (Object)slotResult.stack())).orElse(null);
        }).filter(Objects::nonNull).toList();
    }

    public void forEach(BiConsumer<dev.emi.trinkets.api.SlotReference, ItemStack> consumer) {
        for (Tuple<dev.emi.trinkets.api.SlotReference, ItemStack> tuple : this.getAllEquipped()) {
            consumer.accept((dev.emi.trinkets.api.SlotReference)tuple.getA(), (ItemStack)tuple.getB());
        }
    }

    public Set<TrinketInventory> getTrackingUpdates() {
        return new HashSet<TrinketInventory>();
    }

    public void clearCachedModifiers() {
        this.capability().clearCachedSlotModifiers();
    }

    public void readFromNbt(CompoundTag tag, HolderLookup.Provider registryLookup) {
        if (tag.contains("data_written_by_accessories")) {
            return;
        }
        AccessoriesHolder holder = this.capability().getHolder();
        List dropped = ((AccessoriesHolderImpl)holder).invalidStacks;
        for (String groupKey : tag.getAllKeys()) {
            ListTag list;
            CompoundTag slotTag;
            CompoundTag groupTag = tag.getCompound(groupKey);
            if (groupTag == null) continue;
            Map<String, TrinketInventory> groupSlots = this.getInventory().get(groupKey);
            if (groupSlots != null) {
                for (String slotKey : groupTag.getAllKeys()) {
                    slotTag = groupTag.getCompound(slotKey);
                    list = slotTag.getList("Items", 10);
                    TrinketInventory inv = groupSlots.get(slotKey);
                    if (inv != null) {
                        inv.fromTag(slotTag.getCompound("Metadata"));
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        CompoundTag c = list.getCompound(i);
                        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)registryLookup, (CompoundTag)c);
                        if (inv != null && i < inv.getContainerSize()) {
                            inv.setItem(i, stack);
                            continue;
                        }
                        dropped.add(stack);
                    }
                }
                continue;
            }
            for (String slotKey : groupTag.getAllKeys()) {
                slotTag = groupTag.getCompound(slotKey);
                list = slotTag.getList("Items", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag c = list.getCompound(i);
                    dropped.add(ItemStack.parseOptional((HolderLookup.Provider)registryLookup, (CompoundTag)c));
                }
            }
        }
        for (SlotEntryReference entryRef : this.capability().getAllEquipped()) {
            SlotReference reference = entryRef.reference();
            SlotType slotType = reference.type();
            if (AccessoriesAPI.getPredicateResults((Set)slotType.validators(), (Level)reference.entity().level(), (LivingEntity)reference.entity(), (SlotType)slotType, (int)0, (ItemStack)entryRef.stack())) continue;
            dropped.add(entryRef.stack().copy());
            entryRef.reference().setStack(ItemStack.EMPTY);
        }
    }

    public void writeToNbt(CompoundTag tag, HolderLookup.Provider registryLookup) {
        tag.put("data_written_by_accessories", (Tag)new CompoundTag());
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            CompoundTag groupTag = new CompoundTag();
            for (Map.Entry<String, TrinketInventory> slot : group.getValue().entrySet()) {
                CompoundTag slotTag = new CompoundTag();
                ListTag list = new ListTag();
                TrinketInventory inv = slot.getValue();
                for (int i = 0; i < inv.getContainerSize(); ++i) {
                    CompoundTag c = (CompoundTag)inv.getItem(i).saveOptional(registryLookup);
                    list.add((Object)c);
                }
                slotTag.put("Metadata", (Tag)inv.toTag());
                slotTag.put("Items", (Tag)list);
                groupTag.put(slot.getKey(), (Tag)slotTag);
            }
            tag.put(group.getKey(), (Tag)groupTag);
        }
    }

    private /* synthetic */ void lambda$readFromNbt$5(Multimap slotMap, dev.emi.trinkets.api.SlotReference ref, ItemStack stack) {
        if (!stack.isEmpty()) {
            Multimap map = TrinketModifiers.get((ItemStack)stack, (dev.emi.trinkets.api.SlotReference)ref, (LivingEntity)this.entity());
            for (Holder entityAttribute : map.keySet()) {
                Object patt0$temp;
                if (!entityAttribute.isBound() || !((patt0$temp = entityAttribute.value()) instanceof SlotAttributes.SlotEntityAttribute)) continue;
                SlotAttributes.SlotEntityAttribute slotEntityAttribute = (SlotAttributes.SlotEntityAttribute)patt0$temp;
                slotMap.putAll((Object)slotEntityAttribute.slot, (Iterable)map.get((Object)entityAttribute));
            }
        }
    }
}

