/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.trinkets.wrapper;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketInventory;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories_compat.AccessoriesCompatInit;
import io.wispforest.accessories_compat.trinkets.pond.SlotGroupExtension;
import io.wispforest.accessories_compat.trinkets.wrapper.WrappedSlotGroup;
import io.wispforest.accessories_compat.trinkets.wrapper.WrappedSlotType;
import io.wispforest.accessories_compat.trinkets.wrapper.WrappedTrinketComponent;
import io.wispforest.accessories_compat.trinkets.wrapper.WrappedTrinketInventory;
import io.wispforest.accessories_compat.utils.ImmutableDelegatingMap;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class TrinketsWrappingUtils {
    public static final Map<EntityType<?>, Map<String, Set<String>>> CURRENT_SLOT_INFO = new HashMap();
    public static final TagKey<Item> ALL_TRINKET_ITEMS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tclayer", (String)"all_trinket_items"));
    private static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<dev.emi.trinkets.api.SlotReference> createTrinketsReference(SlotReference slotReference) {
        return TrinketsWrappingUtils.createTrinketsReference(slotReference, false);
    }

    public static Optional<dev.emi.trinkets.api.SlotReference> createTrinketsReference(SlotReference slotReference, boolean allowAlternativeHand) {
        try {
            AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)slotReference.entity());
            if (capability == null) {
                return Optional.empty();
            }
            AccessoriesContainer container = (AccessoriesContainer)capability.getContainers().get(slotReference.slotName());
            io.wispforest.accessories.api.slot.SlotType slotType = SlotTypeLoader.getSlotType((Level)slotReference.entity().level(), (String)container.getSlotName());
            WrappedTrinketInventory trinketInv = new WrappedTrinketInventory(new WrappedTrinketComponent(slotReference.entity()), container, slotType);
            if (allowAlternativeHand) {
                if (slotReference.slotName().contains("offhand")) {
                    trinketInv.setOtherGroupName("offhand");
                } else if (slotReference.slotName().equals("hand") && slotReference.slot() % 2 != 0) {
                    trinketInv.setOtherGroupName("offhand");
                }
            }
            return Optional.of(new dev.emi.trinkets.api.SlotReference((TrinketInventory)trinketInv, slotReference.slot()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<SlotReference> createAccessoriesReference(dev.emi.trinkets.api.SlotReference slotReference) {
        TrinketInventory trinketInventory = slotReference.inventory();
        if (!(trinketInventory instanceof WrappedTrinketInventory)) {
            return Optional.empty();
        }
        WrappedTrinketInventory wrappedTrinketInventory = (WrappedTrinketInventory)trinketInventory;
        return Optional.of(SlotReference.of((LivingEntity)wrappedTrinketInventory.container.capability().entity(), (String)wrappedTrinketInventory.container.getSlotName(), (int)slotReference.index()));
    }

    public static Map<String, Map<String, io.wispforest.accessories.api.slot.SlotType>> getGroupedSlots(boolean isClient, EntityType<?> type) {
        HashMap<String, Map<String, io.wispforest.accessories.api.slot.SlotType>> groups = new HashMap<String, Map<String, io.wispforest.accessories.api.slot.SlotType>>();
        Map entitySlots = EntitySlotLoader.INSTANCE.getSlotTypes(isClient, type);
        if (entitySlots == null) {
            return Map.of();
        }
        for (io.wispforest.accessories.api.slot.SlotGroup group : SlotGroupLoader.INSTANCE.getGroups(isClient, false)) {
            for (String slot : group.slots()) {
                if (!entitySlots.containsKey(slot)) continue;
                groups.computeIfAbsent(group.name(), string -> new HashMap()).put(slot, (io.wispforest.accessories.api.slot.SlotType)entitySlots.get(slot));
            }
        }
        return groups;
    }

    public static io.wispforest.accessories.api.slot.SlotGroup getGroup(Level level, String accessoriesSlot) {
        List groups = SlotGroupLoader.getGroups((Level)level, (boolean)false);
        io.wispforest.accessories.api.slot.SlotGroup foundGroup = (io.wispforest.accessories.api.slot.SlotGroup)SlotGroupLoader.getGroup((Level)level, (String)"unsorted").get();
        for (io.wispforest.accessories.api.slot.SlotGroup group : groups) {
            if (!group.slots().contains(accessoriesSlot)) continue;
            foundGroup = group;
            break;
        }
        return foundGroup;
    }

    public static SequencedCollection<String> getGroupFromDefaultSlot(String slot) {
        if (!AccessoriesCompatInit.defaultSlots.contains(slot)) {
            return List.of();
        }
        return switch (slot) {
            case "anklet", "shoes" -> List.of("feet");
            case "belt" -> List.of("legs");
            case "hand", "ring", "wrist" -> List.of("hand", "offhand");
            case "face", "hat" -> List.of("head");
            case "back", "cape", "necklace" -> List.of("chest");
            default -> List.of();
        };
    }

    public static String trinketsToAccessories_Slot(Optional<String> group, String trinketType) {
        return (String)TrinketsWrappingUtils.trinketsToAccessories_SlotEither(group, trinketType).map(string -> string, string -> string);
    }

    public static Either<String, String> trinketsToAccessories_SlotEither(Optional<String> group, String trinketType) {
        Object accessoriesType;
        switch (trinketType) {
            case "glove": {
                Object object = "hand";
                break;
            }
            case "aglet": {
                Object object = "anklet";
                break;
            }
            default: {
                Object object = accessoriesType = trinketType;
            }
        }
        if (AccessoriesCompatInit.defaultSlots.contains(accessoriesType)) {
            return Either.right((Object)accessoriesType);
        }
        if (group.isPresent()) {
            accessoriesType = "trinket_group_" + group.get() + "-" + (String)accessoriesType;
        }
        return Either.left((Object)accessoriesType);
    }

    public static String accessoriesToTrinkets_Slot(String accessoryType) {
        String trinketType = switch (accessoryType) {
            case "hand" -> "glove";
            case "anklet" -> "aglet";
            default -> accessoryType;
        };
        return TrinketsWrappingUtils.filterGroupInfo(trinketType);
    }

    public static String trinketsToAccessories_Group(String trinketType) {
        return switch (trinketType) {
            case "legs" -> "leg";
            case "offhand", "hand" -> "arm";
            case "charm" -> "misc";
            default -> trinketType;
        };
    }

    public static String accessoriesToTrinkets_Group(String accessoryType) {
        return switch (accessoryType) {
            case "leg" -> "legs";
            case "arm" -> "hand";
            case "misc" -> "charm";
            default -> accessoryType;
        };
    }

    public static ResourceLocation trinketsToAccessories_Validators(ResourceLocation location) {
        return switch (location.toString()) {
            case "trinkets:all" -> Accessories.of((String)"all");
            case "trinkets:none" -> Accessories.of((String)"none");
            case "trinkets:tag" -> Accessories.of((String)"tag");
            case "trinkets:relevant" -> Accessories.of((String)"relevant");
            default -> location;
        };
    }

    public static String filterGroupInfo(String trinketType) {
        return trinketType.replaceAll("(trinket_group_).*-", "");
    }

    @Nullable
    public static String getGroupInfo(String trinketType) {
        if (!trinketType.contains("trinket_group_")) {
            return null;
        }
        String groupWithPrefix = trinketType.replace(trinketType.replaceAll("(trinket_group_).*-", ""), "");
        return groupWithPrefix.replace("trinket_group_", "");
    }

    public static Pair<Optional<String>, String> splitGroupInfo(String path) {
        if (!path.contains("/")) {
            return Pair.of(Optional.empty(), (Object)path);
        }
        String[] parts = path.split("/");
        if (parts.length <= 1) {
            return Pair.of(Optional.empty(), (Object)path);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < parts.length; ++i) {
            builder.append(parts[i]);
        }
        return Pair.of(Optional.of(parts[0]), (Object)builder.toString());
    }

    public static DropRule convertDropRule(TrinketEnums.DropRule dropRule) {
        return switch (dropRule) {
            default -> throw new MatchException(null, null);
            case TrinketEnums.DropRule.KEEP -> DropRule.KEEP;
            case TrinketEnums.DropRule.DROP -> DropRule.DROP;
            case TrinketEnums.DropRule.DESTROY -> DropRule.DESTROY;
            case TrinketEnums.DropRule.DEFAULT -> DropRule.DEFAULT;
        };
    }

    public static TrinketEnums.DropRule convertDropRule(DropRule dropRule) {
        return switch (dropRule) {
            default -> throw new MatchException(null, null);
            case DropRule.KEEP -> TrinketEnums.DropRule.KEEP;
            case DropRule.DROP -> TrinketEnums.DropRule.DROP;
            case DropRule.DESTROY -> TrinketEnums.DropRule.DESTROY;
            case DropRule.DEFAULT -> TrinketEnums.DropRule.DEFAULT;
        };
    }

    public static Map<String, SlotType> slotType(Map<String, io.wispforest.accessories.api.slot.SlotType> map, String group) {
        return new ImmutableDelegatingMap<String, SlotType, io.wispforest.accessories.api.slot.SlotType>("slot_types", String.class, SlotType.class, map, TrinketsWrappingUtils::accessoriesToTrinkets_Slot, string -> TrinketsWrappingUtils.trinketsToAccessories_Slot(Optional.empty(), string), slotType -> new WrappedSlotType((io.wispforest.accessories.api.slot.SlotType)slotType, group), trinketSlot -> {
            io.wispforest.accessories.api.slot.SlotType slotType;
            if (trinketSlot instanceof WrappedSlotType) {
                WrappedSlotType wrappedSlotType = (WrappedSlotType)((Object)trinketSlot);
                slotType = wrappedSlotType.slotType;
            } else {
                slotType = null;
            }
            return slotType;
        });
    }

    public static Map<String, SlotGroup> slotGroups(Map<String, Map<String, io.wispforest.accessories.api.slot.SlotType>> map, boolean isClientSide) {
        return new ImmutableDelegatingMap<String, SlotGroup, Map>("slot_group", String.class, SlotGroup.class, map, TrinketsWrappingUtils::accessoriesToTrinkets_Group, TrinketsWrappingUtils::trinketsToAccessories_Group, (group, slotData) -> WrappedSlotGroup.of(group, slotData, isClientSide), trinketSlot -> {
            SlotGroupExtension ext = (SlotGroupExtension)trinketSlot;
            return ext.isWrapped() ? ext.accessories$slots() : null;
        });
    }

    public static Map<String, Map<String, TrinketInventory>> trinketComponentView(Map<String, Map<String, io.wispforest.accessories.api.slot.SlotType>> map, WrappedTrinketComponent component, Map<String, AccessoriesContainer> containerMap, Runnable errorMessage) {
        return new ImmutableDelegatingMap<String, Map, Map>("grouped_trinket_inventories", String.class, Map.class, map, TrinketsWrappingUtils::accessoriesToTrinkets_Group, TrinketsWrappingUtils::trinketsToAccessories_Group, (group, slotData) -> TrinketsWrappingUtils.groupedTrinketInventories(group, component, slotData, containerMap), trinketSlots -> null).errorMessageSupplier(errorMessage);
    }

    public static Map<String, TrinketInventory> groupedTrinketInventories(String group, WrappedTrinketComponent component, Map<String, io.wispforest.accessories.api.slot.SlotType> slotTypeMap, Map<String, AccessoriesContainer> containerMap) {
        return new ImmutableDelegatingMap<String, TrinketInventory, io.wispforest.accessories.api.slot.SlotType>("trinket_inventories", String.class, TrinketInventory.class, slotTypeMap, TrinketsWrappingUtils::accessoriesToTrinkets_Slot, string -> TrinketsWrappingUtils.trinketsToAccessories_Slot(Optional.of(group), string), (key, type) -> {
            AccessoriesContainer container = (AccessoriesContainer)containerMap.get(type.name());
            if (container == null) {
                throw new IllegalStateException("Unable to get the required Accessories container to wrap for Trinkets API call: [Slot: " + type.name() + "]");
            }
            return new WrappedTrinketInventory(component, container, (io.wispforest.accessories.api.slot.SlotType)type);
        }, object -> null);
    }
}

