/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios.wrapper;

import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.events.extra.AllowWalkingOnSnow;
import io.wispforest.accessories.api.events.extra.EndermanMasked;
import io.wispforest.accessories.api.events.extra.FortuneAdjustment;
import io.wispforest.accessories.api.events.extra.PiglinNeutralInducer;
import io.wispforest.accessories.api.events.extra.v2.LootingAdjustment;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories_compat.curios.wrapper.CuriosConversionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class AccessoryFromCurio
implements Accessory,
LootingAdjustment,
FortuneAdjustment,
AllowWalkingOnSnow,
EndermanMasked,
PiglinNeutralInducer {
    private final Function<ItemStack, @Nullable ICurio> getter;

    public AccessoryFromCurio(Function<ItemStack, ICurio> getter) {
        this.getter = getter;
    }

    public Optional<ICurio> iCurio(ItemStack stack) {
        return Optional.ofNullable(this.getter.apply(stack));
    }

    public TriState allowWalkingOnSnow(ItemStack itemStack, SlotReference slotReference) {
        return this.convertBoolean(this.iCurio(itemStack).map(iCurio -> iCurio.canWalkOnPowderedSnow(CuriosConversionUtils.objectsConvertToC(slotReference))).orElse(false));
    }

    public TriState isEndermanMasked(EnderMan enderMan, ItemStack itemStack, SlotReference slotReference) {
        return this.convertBoolean(this.iCurio(itemStack).map(iCurio -> iCurio.isEnderMask(CuriosConversionUtils.objectsConvertToC(slotReference), enderMan)).orElse(false));
    }

    public TriState makePiglinsNeutral(ItemStack itemStack, SlotReference slotReference) {
        return this.convertBoolean(this.iCurio(itemStack).map(iCurio -> iCurio.makesPiglinsNeutral(CuriosConversionUtils.objectsConvertToC(slotReference))).orElse(false));
    }

    public int getFortuneAdjustment(ItemStack itemStack, SlotReference slotReference, LootContext lootContext, int i) {
        return this.iCurio(itemStack).map(iCurio -> iCurio.getFortuneLevel(CuriosConversionUtils.objectsConvertToC(slotReference), lootContext)).orElse(0);
    }

    public int getLootingAdjustment(ItemStack itemStack, SlotReference slotReference, LivingEntity livingEntity, LootContext lootContext, DamageSource damageSource, int i) {
        return this.iCurio(itemStack).map(iCurio -> iCurio.getLootingLevel(CuriosConversionUtils.objectsConvertToC(slotReference), lootContext)).orElse(0);
    }

    private TriState convertBoolean(boolean value) {
        return value ? TriState.TRUE : TriState.DEFAULT;
    }

    public void tick(ItemStack stack, SlotReference reference) {
        this.iCurio(stack).ifPresent(iCurio -> iCurio.curioTick(CuriosConversionUtils.objectsConvertToC(reference)));
    }

    public void onEquip(ItemStack stack, SlotReference reference) {
        this.iCurio(stack).ifPresent(iCurio -> iCurio.onEquip(CuriosConversionUtils.objectsConvertToC(reference), ItemStack.EMPTY));
    }

    public void onUnequip(ItemStack stack, SlotReference reference) {
        this.iCurio(stack).ifPresent(iCurio -> iCurio.onUnequip(CuriosConversionUtils.objectsConvertToC(reference), ItemStack.EMPTY));
    }

    public boolean canEquip(ItemStack stack, SlotReference reference) {
        return this.iCurio(stack).map(iCurio -> iCurio.canEquip(CuriosConversionUtils.objectsConvertToC(reference))).orElse(false);
    }

    public boolean canUnequip(ItemStack stack, SlotReference reference) {
        return this.iCurio(stack).map(iCurio -> iCurio.canUnequip(CuriosConversionUtils.objectsConvertToC(reference))).orElse(true);
    }

    public void getDynamicModifiers(ItemStack stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        SlotContext ctx = CuriosConversionUtils.objectsConvertToC(reference);
        super.getDynamicModifiers(stack, reference, builder);
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"curios", (String)reference.createSlotPath());
        this.iCurio(stack).ifPresent(iCurio -> iCurio.getAttributeModifiers(ctx, id).forEach((arg_0, arg_1) -> ((AccessoryAttributeBuilder)builder).addExclusive(arg_0, arg_1)));
    }

    public DropRule getDropRule(ItemStack stack, SlotReference reference, DamageSource source) {
        return CuriosConversionUtils.dropRuleConvertToA(this.iCurio(stack).map(iCurio -> iCurio.getDropRule(CuriosConversionUtils.objectsConvertToC(reference), source, true)).orElse(ICurio.DropRule.DEFAULT));
    }

    public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        this.iCurio(stack).ifPresent(iCurio -> iCurio.onEquipFromUse(CuriosConversionUtils.objectsConvertToC(reference)));
    }

    public boolean canEquipFromUse(ItemStack stack) {
        try {
            return this.iCurio(stack).map(iCurio -> iCurio.canEquipFromUse(null)).orElse(false);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Nullable
    public SoundEventData getEquipSound(ItemStack stack, SlotReference reference) {
        SlotContext ctx = CuriosConversionUtils.objectsConvertToC(reference);
        return this.iCurio(stack).map(iCurio -> iCurio.getEquipSound(ctx)).map(info -> new SoundEventData(Holder.direct((Object)info.soundEvent()), info.volume(), info.pitch())).orElse(super.getEquipSound(stack, reference));
    }

    public void onBreak(ItemStack stack, SlotReference reference) {
        this.iCurio(stack).ifPresent(iCurio -> iCurio.curioBreak(CuriosConversionUtils.objectsConvertToC(reference)));
    }

    public void getAttributesTooltip(ItemStack stack, SlotType type, List<Component> tooltips, Item.TooltipContext tooltipContext, TooltipFlag tooltipType) {
        this.iCurio(stack).ifPresent(iCurio -> {
            List curioList = iCurio.getAttributesTooltip(new ArrayList(tooltips), tooltipContext);
            tooltips.clear();
            tooltips.addAll(curioList);
        });
    }

    public void getExtraTooltip(ItemStack stack, List<Component> tooltips, Item.TooltipContext tooltipContext, TooltipFlag tooltipType) {
        this.iCurio(stack).ifPresent(iCurio -> tooltips.addAll(iCurio.getSlotsTooltip(new ArrayList(), tooltipContext)));
    }
}

