/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ToxlacanthSmokeParticle
extends SimpleAnimatedParticle {
    ToxlacanthSmokeParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, int pPackedColor, SpriteSet pSprites) {
        super(pLevel, pX, pY, pZ, pSprites, 0.0f);
        this.friction = 0.92f;
        this.quadSize = 0.5f;
        this.setAlpha(1.0f);
        this.setColor((float)FastColor.ARGB32.red((int)pPackedColor) / 255.0f, (float)FastColor.ARGB32.green((int)pPackedColor) / 255.0f, (float)FastColor.ARGB32.blue((int)pPackedColor) / 255.0f);
        this.lifetime = (int)((double)(this.quadSize * 12.0f) / (Math.random() * (double)0.8f + (double)0.2f));
        this.setSpriteFromAge(pSprites);
        this.hasPhysics = false;
        this.xd = pXSpeed;
        this.yd = pYSpeed;
        this.zd = pZSpeed;
    }

    public void tick() {
        super.tick();
        if (!this.removed) {
            this.setSpriteFromAge(this.sprites);
            if (this.age > this.lifetime / 2) {
                this.setAlpha(1.0f - ((float)this.age - (float)(this.lifetime / 2)) / (float)this.lifetime);
            }
            if (this.level.getBlockState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).isAir()) {
                this.yd -= (double)0.0074f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new ToxlacanthSmokeParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255), this.sprites);
        }
    }
}

