/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.network.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.entity.Surfer;

public record SurferJumpPacket(int surferId, int power) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SurferJumpPacket> TYPE = new CustomPacketPayload.Type(WanAncientBeasts.resource("surfer_jump"));
    public static final StreamCodec<ByteBuf, SurferJumpPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SurferJumpPacket::surferId, (StreamCodec)ByteBufCodecs.INT, SurferJumpPacket::power, SurferJumpPacket::new);

    public void handle(IPayloadContext context) {
        Entity entity1 = context.player().level().getEntity(this.surferId);
        if (entity1 instanceof Surfer) {
            Surfer surfer = (Surfer)entity1;
            surfer.jump(Math.max(Math.min(this.power, 100), 0));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

