/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.network.bidirection;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.entity.Glider;
import net.wanmine.wab.init.data.WabTriggers;

public record GliderPartyingPacket(int gliderId, boolean isPartying) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GliderPartyingPacket> TYPE = new CustomPacketPayload.Type(WanAncientBeasts.resource("glider_partying"));
    public static final StreamCodec<ByteBuf, GliderPartyingPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, GliderPartyingPacket::gliderId, (StreamCodec)ByteBufCodecs.BOOL, GliderPartyingPacket::isPartying, GliderPartyingPacket::new);

    public void handleClient(IPayloadContext context) {
        Entity entity = Minecraft.getInstance().level.getEntity(this.gliderId);
        if (entity instanceof Glider) {
            Glider glider = (Glider)entity;
            glider.setPartying(this.isPartying);
        }
    }

    public void handleServer(IPayloadContext context) {
        Entity entity = context.player().level().getEntity(this.gliderId);
        if (entity instanceof Glider) {
            Glider glider = (Glider)entity;
            glider.setPartying(this.isPartying);
            WabTriggers.triggerNearby(WabTriggers.NEAR_GLIDER_DANCE, (Entity)glider, 8);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new GliderPartyingPacket(this.gliderId, this.isPartying), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

