/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.item;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.wanmine.wab.init.world.WabItems;

public class HangGlider
extends Item {
    public HangGlider(Item.Properties pProperties) {
        super(pProperties);
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.canUse((LivingEntity)player)) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack itemStack, int remainingUseDuration) {
        if (this.canUse(entity)) {
            Vec3 dir = entity.getLookAngle().scale(0.4);
            entity.setDeltaMovement(dir.x * 0.6, -0.08 + (double)entity.fallDistance * -0.06, dir.z * 0.6);
            if (level.getGameTime() % 50L == 0L) {
                itemStack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
            }
            entity.fallDistance = Math.max(entity.fallDistance * 0.9f, 1.0f);
        } else {
            entity.stopUsingItem();
        }
    }

    public boolean canUse(LivingEntity entity) {
        return !entity.onGround() && entity.getDeltaMovement().y < 0.0 && !entity.isInWater() && !entity.isInLava() && !entity.isInPowderSnow;
    }

    public boolean isValidRepairItem(ItemStack pToRepair, ItemStack pRepair) {
        return pRepair.is((Item)WabItems.GLIDER_FEATHER.get());
    }
}

